/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.lang;

import com.google.gwt.lang.BigLongLib;
import com.google.gwt.lang.BigLongLibBase;

public class LongLib {
    protected static boolean RUN_IN_JVM = false;

    public static LongEmul add(LongEmul a, LongEmul b) {
        double result;
        if (LongLib.isSmallLong(a) && LongLib.isSmallLong(b) && LongLib.isSafeIntegerRange(result = LongLib.asDouble(a) + LongLib.asDouble(b))) {
            return LongLib.createSmallLongEmul(result);
        }
        return LongLib.createLongEmul(BigLongLib.add(LongLib.toBigLong(a), LongLib.toBigLong(b)));
    }

    public static LongEmul sub(LongEmul a, LongEmul b) {
        double result;
        if (LongLib.isSmallLong(a) && LongLib.isSmallLong(b) && LongLib.isSafeIntegerRange(result = LongLib.asDouble(a) - LongLib.asDouble(b))) {
            return LongLib.createSmallLongEmul(result);
        }
        return LongLib.createLongEmul(BigLongLib.sub(LongLib.toBigLong(a), LongLib.toBigLong(b)));
    }

    public static LongEmul neg(LongEmul a) {
        double result;
        if (LongLib.isSmallLong(a) && !Double.isNaN(result = 0.0 - LongLib.asDouble(a))) {
            return LongLib.createSmallLongEmul(result);
        }
        return LongLib.createLongEmul(BigLongLib.neg(LongLib.asBigLong(a)));
    }

    public static boolean gt(LongEmul a, LongEmul b) {
        return LongLib.compare(a, b) > 0.0;
    }

    public static boolean gte(LongEmul a, LongEmul b) {
        return LongLib.compare(a, b) >= 0.0;
    }

    public static boolean lt(LongEmul a, LongEmul b) {
        return LongLib.compare(a, b) < 0.0;
    }

    public static boolean lte(LongEmul a, LongEmul b) {
        return LongLib.compare(a, b) <= 0.0;
    }

    public static boolean eq(LongEmul a, LongEmul b) {
        return LongLib.compare(a, b) == 0.0;
    }

    public static boolean neq(LongEmul a, LongEmul b) {
        return LongLib.compare(a, b) != 0.0;
    }

    static double compare(LongEmul a, LongEmul b) {
        double result;
        if (LongLib.isSmallLong(a) && LongLib.isSmallLong(b) && !Double.isNaN(result = LongLib.asDouble(a) - LongLib.asDouble(b))) {
            return result;
        }
        return BigLongLib.compare(LongLib.toBigLong(a), LongLib.toBigLong(b));
    }

    public static LongEmul div(LongEmul a, LongEmul b) {
        double result;
        if (LongLib.isSmallLong(a) && LongLib.isSmallLong(b) && LongLib.isSafeIntegerRange(result = LongLib.asDouble(a) / LongLib.asDouble(b))) {
            return LongLib.createSmallLongEmul(LongLib.truncate(result));
        }
        return LongLib.createLongEmul(BigLongLib.div(LongLib.toBigLong(a), LongLib.toBigLong(b)));
    }

    public static LongEmul mod(LongEmul a, LongEmul b) {
        double result;
        if (LongLib.isSmallLong(a) && LongLib.isSmallLong(b) && LongLib.isSafeIntegerRange(result = LongLib.asDouble(a) % LongLib.asDouble(b))) {
            return LongLib.createSmallLongEmul(result);
        }
        return LongLib.createLongEmul(BigLongLib.mod(LongLib.toBigLong(a), LongLib.toBigLong(b)));
    }

    public static LongEmul mul(LongEmul a, LongEmul b) {
        double result;
        if (LongLib.isSmallLong(a) && LongLib.isSmallLong(b) && LongLib.isSafeIntegerRange(result = LongLib.asDouble(a) * LongLib.asDouble(b))) {
            return LongLib.createSmallLongEmul(result);
        }
        return LongLib.createLongEmul(BigLongLib.mul(LongLib.toBigLong(a), LongLib.toBigLong(b)));
    }

    public static LongEmul not(LongEmul a) {
        return LongLib.createLongEmul(BigLongLib.not(LongLib.toBigLong(a)));
    }

    public static LongEmul and(LongEmul a, LongEmul b) {
        return LongLib.createLongEmul(BigLongLib.and(LongLib.toBigLong(a), LongLib.toBigLong(b)));
    }

    public static LongEmul or(LongEmul a, LongEmul b) {
        return LongLib.createLongEmul(BigLongLib.or(LongLib.toBigLong(a), LongLib.toBigLong(b)));
    }

    public static LongEmul xor(LongEmul a, LongEmul b) {
        return LongLib.createLongEmul(BigLongLib.xor(LongLib.toBigLong(a), LongLib.toBigLong(b)));
    }

    public static LongEmul shl(LongEmul a, int n) {
        return LongLib.createLongEmul(BigLongLib.shl(LongLib.toBigLong(a), n));
    }

    public static LongEmul shr(LongEmul a, int n) {
        return LongLib.createLongEmul(BigLongLib.shr(LongLib.toBigLong(a), n));
    }

    public static LongEmul shru(LongEmul a, int n) {
        return LongLib.createLongEmul(BigLongLib.shru(LongLib.toBigLong(a), n));
    }

    public static LongEmul fromDouble(double value) {
        if (LongLib.isSafeIntegerRange(value)) {
            return LongLib.createSmallLongEmul(LongLib.truncate(value));
        }
        return LongLib.createLongEmul(BigLongLib.fromDouble(value));
    }

    public static double toDouble(LongEmul a) {
        if (LongLib.isSmallLong(a)) {
            double d = LongLib.asDouble(a);
            return d == -0.0 ? 0.0 : d;
        }
        return BigLongLib.toDouble(LongLib.asBigLong(a));
    }

    public static LongEmul fromInt(int value) {
        return LongLib.createSmallLongEmul(value);
    }

    public static int toInt(LongEmul a) {
        if (LongLib.isSmallLong(a)) {
            return LongLib.coerceToInt(LongLib.asDouble(a));
        }
        return BigLongLib.toInt(LongLib.asBigLong(a));
    }

    public static String toString(LongEmul a) {
        if (LongLib.isSmallLong(a)) {
            return LongLib.toString(LongLib.asDouble(a));
        }
        return BigLongLib.toString(LongLib.asBigLong(a));
    }

    public static long[] getAsLongArray(long l) {
        if (LongLib.isSafeIntegerRange(l)) {
            return new long[]{l};
        }
        return BigLongLib.getAsLongArray(l);
    }

    private static boolean isSafeIntegerRange(double value) {
        return -1.7592186044416E13 < value && value < 1.7592186044416E13;
    }

    private static double truncate(double value) {
        return value < 0.0 ? Math.ceil(value) : Math.floor(value);
    }

    private static int coerceToInt(double value) {
        if (RUN_IN_JVM) {
            return (int)value;
        }
        return LongLib.coerceToInt0(value);
    }

    private static int coerceToInt0(double d) {
        throw new RuntimeException("Cannot call native method");
    }

    private static String toString(double value) {
        if (RUN_IN_JVM) {
            return String.valueOf((long)value);
        }
        return String.valueOf(value);
    }

    private static double asDouble(LongEmul value) {
        return LongLib.asDouble(LongLib.asSmallLong(value));
    }

    private static SmallLong asSmallLong(LongEmul value) {
        if (RUN_IN_JVM) {
            return value.small;
        }
        return LongLib.asSmallLong0(value);
    }

    private static SmallLong asSmallLong0(LongEmul longEmul) {
        throw new RuntimeException("Cannot call native method");
    }

    private static double asDouble(SmallLong value) {
        if (RUN_IN_JVM) {
            return value == null ? Double.NaN : value.d;
        }
        return LongLib.asDouble0(value);
    }

    private static double asDouble0(SmallLong smallLong) {
        throw new RuntimeException("Cannot call native method");
    }

    private static boolean isSmallLong(LongEmul value) {
        if (RUN_IN_JVM) {
            return value.small != null;
        }
        return LongLib.isSmallLong0(value);
    }

    private static boolean isSmallLong0(LongEmul longEmul) {
        throw new RuntimeException("Cannot call native method");
    }

    static BigLongLibBase.BigLong asBigLong(LongEmul value) {
        if (RUN_IN_JVM) {
            return value.big;
        }
        return LongLib.asBigLong0(value);
    }

    private static BigLongLibBase.BigLong asBigLong0(LongEmul longEmul) {
        throw new RuntimeException("Cannot call native method");
    }

    private static BigLongLibBase.BigLong toBigLong(LongEmul value) {
        return LongLib.isSmallLong(value) ? LongLib.toBigLong(LongLib.asSmallLong(value)) : LongLib.asBigLong(value);
    }

    private static BigLongLibBase.BigLong toBigLong(SmallLong longValue) {
        double value = LongLib.asDouble(longValue);
        int a3 = 0;
        if (value < 0.0) {
            value += 1.7592186044416E13;
            a3 = 1048575;
        }
        int a1 = (int)(value / 4194304.0);
        int a0 = (int)(value - (double)a1 * 4194304.0);
        return BigLongLibBase.create(a0, a1, a3);
    }

    private static LongEmul createSmallLongEmul(double value) {
        if (RUN_IN_JVM) {
            SmallLong small = new SmallLong();
            small.d = value;
            LongEmul emul = new LongEmul();
            emul.small = small;
            return emul;
        }
        return LongLib.createSmallLongEmul0(value);
    }

    private static LongEmul createSmallLongEmul0(double d) {
        throw new RuntimeException("Cannot call native method");
    }

    private static LongEmul createLongEmul(BigLongLibBase.BigLong big) {
        int a2 = BigLongLibBase.getH(big);
        if (a2 == 0) {
            return LongLib.createSmallLongEmul((double)BigLongLibBase.getL(big) + (double)BigLongLibBase.getM(big) * 4194304.0);
        }
        if (a2 == 1048575) {
            return LongLib.createSmallLongEmul((double)BigLongLibBase.getL(big) + (double)BigLongLibBase.getM(big) * 4194304.0 - 1.7592186044416E13);
        }
        return LongLib.createBigLongEmul(big);
    }

    private static LongEmul createBigLongEmul(BigLongLibBase.BigLong big) {
        if (RUN_IN_JVM) {
            LongEmul emul = new LongEmul();
            emul.big = big;
            return emul;
        }
        return LongLib.createBigLongEmul0(big);
    }

    private static LongEmul createBigLongEmul0(BigLongLibBase.BigLong bigLong) {
        throw new RuntimeException("Cannot call native method");
    }

    static LongEmul copy(LongEmul value) {
        if (LongLib.isSmallLong(value)) {
            return LongLib.createSmallLongEmul(LongLib.asDouble(value));
        }
        return LongLib.createBigLongEmul(BigLongLibBase.create(LongLib.asBigLong(value)));
    }

    private LongLib() {
    }

    static class SmallLong {
        double d;

        SmallLong() {
        }
    }

    static class LongEmul {
        SmallLong small;
        BigLongLibBase.BigLong big;

        LongEmul() {
        }
    }
}

