/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.lang;

import com.google.gwt.lang.BigLongLib;
import com.google.gwt.lang.LongLib;

class BigLongLibBase {
    protected static final int BITS = 22;
    protected static final int BITS01 = 44;
    protected static final int BITS2 = 20;
    protected static final int MASK = 0x3FFFFF;
    protected static final int MASK_2 = 1048575;
    protected static BigLong remainder;
    protected static final int SIGN_BIT = 19;
    protected static final int SIGN_BIT_VALUE = 524288;
    protected static final double TWO_PWR_15_DBL = 32768.0;
    protected static final double TWO_PWR_16_DBL = 65536.0;
    protected static final double TWO_PWR_22_DBL = 4194304.0;
    protected static final double TWO_PWR_31_DBL = 2.147483648E9;
    protected static final double TWO_PWR_32_DBL = 4.294967296E9;
    protected static final double TWO_PWR_44_DBL = 1.7592186044416E13;
    protected static final double TWO_PWR_63_DBL = 9.223372036854776E18;

    protected static BigLong create(int value) {
        int a2;
        int a0 = value & 0x3FFFFF;
        int a1 = value >> 22 & 0x3FFFFF;
        int n = a2 = value < 0 ? 1048575 : 0;
        if (LongLib.RUN_IN_JVM) {
            BigLong a = new BigLong();
            a.l = a0;
            a.m = a1;
            a.h = a2;
            return a;
        }
        return BigLongLibBase.create0(a0, a1, a2);
    }

    protected static BigLong create(int a0, int a1, int a2) {
        if (LongLib.RUN_IN_JVM) {
            BigLong a = new BigLong();
            a.l = a0;
            a.m = a1;
            a.h = a2;
            return a;
        }
        return BigLongLibBase.create0(a0, a1, a2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static BigLong divMod(BigLong a, BigLong b, boolean computeRemainder) {
        BigLong bigLong;
        boolean aIsCopy;
        boolean aIsMinValue;
        boolean aIsNegative;
        int bpower;
        boolean negative;
        block13: {
            if (BigLongLibBase.isZero(b)) {
                throw new ArithmeticException("divide by zero");
            }
            if (BigLongLibBase.isZero(a)) {
                if (!computeRemainder) return BigLongLibBase.create();
                remainder = BigLongLibBase.create();
                return BigLongLibBase.create();
            }
            if (BigLongLibBase.isMinValue(b)) {
                return BigLongLibBase.divModByMinValue(a, computeRemainder);
            }
            negative = false;
            if (BigLongLibBase.isNegative(b)) {
                b = BigLongLib.neg(b);
                negative = !negative;
            }
            bpower = BigLongLibBase.powerOfTwo(b);
            aIsNegative = false;
            aIsMinValue = false;
            aIsCopy = false;
            if (BigLongLibBase.isMinValue(a)) {
                aIsMinValue = true;
                aIsNegative = true;
                if (bpower == -1) {
                    a = BigLongLibBase.create(BigLongLib.Const.MAX_VALUE);
                    aIsCopy = true;
                    negative = !negative;
                    break block13;
                } else {
                    BigLong c = BigLongLib.shr(a, bpower);
                    if (negative) {
                        BigLongLibBase.negate(c);
                    }
                    if (!computeRemainder) return c;
                    remainder = BigLongLibBase.create();
                    return c;
                }
            }
            if (BigLongLibBase.isNegative(a)) {
                aIsNegative = true;
                a = BigLongLib.neg(a);
                aIsCopy = true;
                boolean bl = negative = !negative;
            }
        }
        if (bpower != -1) {
            return BigLongLibBase.divModByShift(a, bpower, negative, aIsNegative, computeRemainder);
        }
        if (BigLongLib.compare(a, b) < 0.0) {
            if (!computeRemainder) return BigLongLibBase.create();
            if (aIsNegative) {
                remainder = BigLongLib.neg(a);
                return BigLongLibBase.create();
            }
            remainder = BigLongLibBase.create(a);
            return BigLongLibBase.create();
        }
        if (aIsCopy) {
            bigLong = a;
            return BigLongLibBase.divModHelper(bigLong, b, negative, aIsNegative, aIsMinValue, computeRemainder);
        }
        bigLong = BigLongLibBase.create(a);
        return BigLongLibBase.divModHelper(bigLong, b, negative, aIsNegative, aIsMinValue, computeRemainder);
    }

    protected static int getH(BigLong a) {
        if (LongLib.RUN_IN_JVM) {
            return a.h;
        }
        return BigLongLibBase.getHNative(a);
    }

    protected static int getL(BigLong a) {
        if (LongLib.RUN_IN_JVM) {
            return a.l;
        }
        return BigLongLibBase.getLNative(a);
    }

    protected static int getM(BigLong a) {
        if (LongLib.RUN_IN_JVM) {
            return a.m;
        }
        return BigLongLibBase.getMNative(a);
    }

    protected static boolean isMinValue(BigLong a) {
        return BigLongLibBase.getH(a) == 524288 && BigLongLibBase.getM(a) == 0 && BigLongLibBase.getL(a) == 0;
    }

    protected static boolean isNegative(BigLong a) {
        return BigLongLibBase.sign(a) != 0;
    }

    protected static boolean isZero(BigLong a) {
        return BigLongLibBase.getL(a) == 0 && BigLongLibBase.getM(a) == 0 && BigLongLibBase.getH(a) == 0;
    }

    protected static void negate(BigLong a) {
        int neg0 = ~BigLongLibBase.getL(a) + 1 & 0x3FFFFF;
        int neg1 = ~BigLongLibBase.getM(a) + (neg0 == 0 ? 1 : 0) & 0x3FFFFF;
        int neg2 = ~BigLongLibBase.getH(a) + (neg0 == 0 && neg1 == 0 ? 1 : 0) & 0xFFFFF;
        if (LongLib.RUN_IN_JVM) {
            a.l = neg0;
            a.m = neg1;
            a.h = neg2;
        } else {
            BigLongLibBase.setL(a, neg0);
            BigLongLibBase.setM(a, neg1);
            BigLongLibBase.setH(a, neg2);
        }
    }

    protected static int sign(BigLong a) {
        return BigLongLibBase.getH(a) >> 19;
    }

    protected static double toDoubleHelper(BigLong a) {
        return (double)BigLongLibBase.getL(a) + (double)BigLongLibBase.getM(a) * 4194304.0 + (double)BigLongLibBase.getH(a) * 1.7592186044416E13;
    }

    static int numberOfLeadingZeros(BigLong a) {
        int b2 = Integer.numberOfLeadingZeros(BigLongLibBase.getH(a));
        if (b2 == 32) {
            int b1 = Integer.numberOfLeadingZeros(BigLongLibBase.getM(a));
            if (b1 == 32) {
                return Integer.numberOfLeadingZeros(BigLongLibBase.getL(a)) + 32;
            }
            return b1 + 20 - 10;
        }
        return b2 - 12;
    }

    private static BigLong create() {
        if (LongLib.RUN_IN_JVM) {
            return new BigLong();
        }
        return BigLongLibBase.create0(0, 0, 0);
    }

    static BigLong create(BigLong a) {
        if (LongLib.RUN_IN_JVM) {
            BigLong b = new BigLong();
            b.l = BigLongLibBase.getL(a);
            b.m = BigLongLibBase.getM(a);
            b.h = BigLongLibBase.getH(a);
            return b;
        }
        return BigLongLibBase.create0(BigLongLibBase.getL(a), BigLongLibBase.getM(a), BigLongLibBase.getH(a));
    }

    private static BigLong create0(int n, int n2, int n3) {
        throw new RuntimeException("Cannot call native method");
    }

    private static BigLong divModByMinValue(BigLong a, boolean computeRemainder) {
        if (BigLongLibBase.isMinValue(a)) {
            if (computeRemainder) {
                remainder = BigLongLibBase.create();
            }
            return BigLongLibBase.create(BigLongLib.Const.ONE);
        }
        if (computeRemainder) {
            remainder = BigLongLibBase.create(a);
        }
        return BigLongLibBase.create();
    }

    private static BigLong divModByShift(BigLong a, int bpower, boolean negative, boolean aIsNegative, boolean computeRemainder) {
        BigLong c = BigLongLib.shr(a, bpower);
        if (negative) {
            BigLongLibBase.negate(c);
        }
        if (computeRemainder) {
            a = BigLongLibBase.maskRight(a, bpower);
            remainder = aIsNegative ? BigLongLib.neg(a) : BigLongLibBase.create(a);
        }
        return c;
    }

    private static BigLong divModHelper(BigLong a, BigLong b, boolean negative, boolean aIsNegative, boolean aIsMinValue, boolean computeRemainder) {
        int shift;
        BigLong bshift = BigLongLib.shl(b, shift);
        BigLong quotient = BigLongLibBase.create();
        for (shift = BigLongLibBase.numberOfLeadingZeros(b) - BigLongLibBase.numberOfLeadingZeros(a); shift >= 0; --shift) {
            boolean gte = BigLongLibBase.trialSubtract(a, bshift);
            if (gte) {
                BigLongLibBase.setBit(quotient, shift);
                if (BigLongLibBase.isZero(a)) break;
            }
            BigLongLibBase.toShru1(bshift);
        }
        if (negative) {
            BigLongLibBase.negate(quotient);
        }
        if (computeRemainder) {
            if (aIsNegative) {
                remainder = BigLongLib.neg(a);
                if (aIsMinValue) {
                    remainder = BigLongLib.sub(remainder, BigLongLib.Const.ONE);
                }
            } else {
                remainder = BigLongLibBase.create(a);
            }
        }
        return quotient;
    }

    private static int getHNative(BigLong bigLong) {
        throw new RuntimeException("Cannot call native method");
    }

    private static int getLNative(BigLong bigLong) {
        throw new RuntimeException("Cannot call native method");
    }

    private static int getMNative(BigLong bigLong) {
        throw new RuntimeException("Cannot call native method");
    }

    private static BigLong maskRight(BigLong a, int bits) {
        int b1;
        int b2;
        int b0;
        if (bits <= 22) {
            b0 = BigLongLibBase.getL(a) & (1 << bits) - 1;
            b2 = 0;
            b1 = 0;
        } else if (bits <= 44) {
            b0 = BigLongLibBase.getL(a);
            b1 = BigLongLibBase.getM(a) & (1 << bits - 22) - 1;
            b2 = 0;
        } else {
            b0 = BigLongLibBase.getL(a);
            b1 = BigLongLibBase.getM(a);
            b2 = BigLongLibBase.getH(a) & (1 << bits - 44) - 1;
        }
        return BigLongLibBase.create(b0, b1, b2);
    }

    private static int powerOfTwo(BigLong a) {
        int l = BigLongLibBase.getL(a);
        if ((l & l - 1) != 0) {
            return -1;
        }
        int m = BigLongLibBase.getM(a);
        if ((m & m - 1) != 0) {
            return -1;
        }
        int h = BigLongLibBase.getH(a);
        if ((h & h - 1) != 0) {
            return -1;
        }
        if (h == 0 && m == 0 && l == 0) {
            return -1;
        }
        if (h == 0 && m == 0 && l != 0) {
            return Integer.numberOfTrailingZeros(l);
        }
        if (h == 0 && m != 0 && l == 0) {
            return Integer.numberOfTrailingZeros(m) + 22;
        }
        if (h != 0 && m == 0 && l == 0) {
            return Integer.numberOfTrailingZeros(h) + 44;
        }
        return -1;
    }

    private static void setBit(BigLong a, int bit) {
        if (LongLib.RUN_IN_JVM) {
            if (bit < 22) {
                a.l |= 1 << bit;
            } else if (bit < 44) {
                a.m |= 1 << bit - 22;
            } else {
                a.h |= 1 << bit - 44;
            }
        } else if (bit < 22) {
            BigLongLibBase.setBitL(a, bit);
        } else if (bit < 44) {
            BigLongLibBase.setBitM(a, bit - 22);
        } else {
            BigLongLibBase.setBitH(a, bit - 44);
        }
    }

    private static void setBitH(BigLong bigLong, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static void setBitL(BigLong bigLong, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static void setBitM(BigLong bigLong, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static void setH(BigLong bigLong, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static void setL(BigLong bigLong, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static void setM(BigLong bigLong, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    private static void toShru1(BigLong a) {
        int a1 = BigLongLibBase.getM(a);
        int a2 = BigLongLibBase.getH(a);
        int a0 = BigLongLibBase.getL(a);
        if (LongLib.RUN_IN_JVM) {
            a.h = a2 >>> 1;
            a.m = a1 >>> 1 | (a2 & 1) << 21;
            a.l = a0 >>> 1 | (a1 & 1) << 21;
        } else {
            BigLongLibBase.setH(a, a2 >>> 1);
            BigLongLibBase.setM(a, a1 >>> 1 | (a2 & 1) << 21);
            BigLongLibBase.setL(a, a0 >>> 1 | (a1 & 1) << 21);
        }
    }

    private static boolean trialSubtract(BigLong a, BigLong b) {
        int sum2 = BigLongLibBase.getH(a) - BigLongLibBase.getH(b);
        if (sum2 < 0) {
            return false;
        }
        int sum0 = BigLongLibBase.getL(a) - BigLongLibBase.getL(b);
        int sum1 = BigLongLibBase.getM(a) - BigLongLibBase.getM(b) + (sum0 >> 22);
        if ((sum2 += sum1 >> 22) < 0) {
            return false;
        }
        if (LongLib.RUN_IN_JVM) {
            a.l = sum0 & 0x3FFFFF;
            a.m = sum1 & 0x3FFFFF;
            a.h = sum2 & 0xFFFFF;
        } else {
            BigLongLibBase.setL(a, sum0 & 0x3FFFFF);
            BigLongLibBase.setM(a, sum1 & 0x3FFFFF);
            BigLongLibBase.setH(a, sum2 & 0xFFFFF);
        }
        return true;
    }

    BigLongLibBase() {
    }

    static class BigLong {
        int l;
        int m;
        int h;

        BigLong() {
        }
    }
}

