/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.lang;

import com.google.gwt.lang.BigLongLibBase;

class BigLongLib
extends BigLongLibBase {
    public static BigLongLibBase.BigLong add(BigLongLibBase.BigLong a, BigLongLibBase.BigLong b) {
        int sum0 = BigLongLib.getL(a) + BigLongLib.getL(b);
        int sum1 = BigLongLib.getM(a) + BigLongLib.getM(b) + (sum0 >> 22);
        int sum2 = BigLongLib.getH(a) + BigLongLib.getH(b) + (sum1 >> 22);
        return BigLongLib.create(sum0 & 0x3FFFFF, sum1 & 0x3FFFFF, sum2 & 0xFFFFF);
    }

    public static BigLongLibBase.BigLong and(BigLongLibBase.BigLong a, BigLongLibBase.BigLong b) {
        return BigLongLib.create(BigLongLib.getL(a) & BigLongLib.getL(b), BigLongLib.getM(a) & BigLongLib.getM(b), BigLongLib.getH(a) & BigLongLib.getH(b));
    }

    public static double compare(BigLongLibBase.BigLong a, BigLongLibBase.BigLong b) {
        int b1;
        int b2;
        int signB;
        int signA = BigLongLib.sign(a);
        if (signA != (signB = BigLongLib.sign(b))) {
            return signB - signA;
        }
        int a2 = BigLongLib.getH(a);
        if (a2 != (b2 = BigLongLib.getH(b))) {
            return a2 - b2;
        }
        int a1 = BigLongLib.getM(a);
        if (a1 != (b1 = BigLongLib.getM(b))) {
            return a1 - b1;
        }
        int a0 = BigLongLib.getL(a);
        int b0 = BigLongLib.getL(b);
        return a0 - b0;
    }

    public static BigLongLibBase.BigLong div(BigLongLibBase.BigLong a, BigLongLibBase.BigLong b) {
        return BigLongLib.divMod(a, b, false);
    }

    public static BigLongLibBase.BigLong fromDouble(double value) {
        if (Double.isNaN(value)) {
            return Const.ZERO;
        }
        if (value < -9.223372036854776E18) {
            return Const.MIN_VALUE;
        }
        if (value >= 9.223372036854776E18) {
            return Const.MAX_VALUE;
        }
        boolean negative = false;
        if (value < 0.0) {
            negative = true;
            value = -value;
        }
        int a2 = 0;
        if (value >= 1.7592186044416E13) {
            a2 = (int)(value / 1.7592186044416E13);
            value -= (double)a2 * 1.7592186044416E13;
        }
        int a1 = 0;
        if (value >= 4194304.0) {
            a1 = (int)(value / 4194304.0);
            value -= (double)a1 * 4194304.0;
        }
        int a0 = (int)value;
        BigLongLibBase.BigLong result = BigLongLib.create(a0, a1, a2);
        if (negative) {
            BigLongLib.negate(result);
        }
        return result;
    }

    public static BigLongLibBase.BigLong fromInt(int value) {
        return BigLongLib.create(value);
    }

    public static long[] getAsLongArray(long l) {
        long[] a = new long[]{(int)(l & 0x3FFFFFL), (int)(l >> 22 & 0x3FFFFFL), (int)(l >> 44 & 0xFFFFFL)};
        return a;
    }

    public static BigLongLibBase.BigLong mod(BigLongLibBase.BigLong a, BigLongLibBase.BigLong b) {
        BigLongLib.divMod(a, b, true);
        return remainder;
    }

    public static BigLongLibBase.BigLong mul(BigLongLibBase.BigLong a, BigLongLibBase.BigLong b) {
        int a0 = BigLongLib.getL(a) & 0x1FFF;
        int a1 = BigLongLib.getL(a) >> 13 | (BigLongLib.getM(a) & 0xF) << 9;
        int a2 = BigLongLib.getM(a) >> 4 & 0x1FFF;
        int a3 = BigLongLib.getM(a) >> 17 | (BigLongLib.getH(a) & 0xFF) << 5;
        int a4 = (BigLongLib.getH(a) & 0xFFF00) >> 8;
        int b0 = BigLongLib.getL(b) & 0x1FFF;
        int b1 = BigLongLib.getL(b) >> 13 | (BigLongLib.getM(b) & 0xF) << 9;
        int b2 = BigLongLib.getM(b) >> 4 & 0x1FFF;
        int b3 = BigLongLib.getM(b) >> 17 | (BigLongLib.getH(b) & 0xFF) << 5;
        int b4 = (BigLongLib.getH(b) & 0xFFF00) >> 8;
        int p0 = a0 * b0;
        int p1 = a1 * b0;
        int p2 = a2 * b0;
        int p3 = a3 * b0;
        int p4 = a4 * b0;
        if (b1 != 0) {
            p1 += a0 * b1;
            p2 += a1 * b1;
            p3 += a2 * b1;
            p4 += a3 * b1;
        }
        if (b2 != 0) {
            p2 += a0 * b2;
            p3 += a1 * b2;
            p4 += a2 * b2;
        }
        if (b3 != 0) {
            p3 += a0 * b3;
            p4 += a1 * b3;
        }
        if (b4 != 0) {
            p4 += a0 * b4;
        }
        int c00 = p0 & 0x3FFFFF;
        int c01 = (p1 & 0x1FF) << 13;
        int c0 = c00 + c01;
        int c10 = p0 >> 22;
        int c11 = p1 >> 9;
        int c12 = (p2 & 0x3FFFF) << 4;
        int c13 = (p3 & 0x1F) << 17;
        int c1 = c10 + c11 + c12 + c13;
        int c22 = p2 >> 18;
        int c23 = p3 >> 5;
        int c24 = (p4 & 0xFFF) << 8;
        int c2 = c22 + c23 + c24;
        c1 += c0 >> 22;
        c2 += c1 >> 22;
        return BigLongLib.create(c0 &= 0x3FFFFF, c1 &= 0x3FFFFF, c2 &= 0xFFFFF);
    }

    public static BigLongLibBase.BigLong neg(BigLongLibBase.BigLong a) {
        int neg0 = ~BigLongLib.getL(a) + 1 & 0x3FFFFF;
        int neg1 = ~BigLongLib.getM(a) + (neg0 == 0 ? 1 : 0) & 0x3FFFFF;
        int neg2 = ~BigLongLib.getH(a) + (neg0 == 0 && neg1 == 0 ? 1 : 0) & 0xFFFFF;
        return BigLongLib.create(neg0, neg1, neg2);
    }

    public static BigLongLibBase.BigLong not(BigLongLibBase.BigLong a) {
        return BigLongLib.create(~BigLongLib.getL(a) & 0x3FFFFF, ~BigLongLib.getM(a) & 0x3FFFFF, ~BigLongLib.getH(a) & 0xFFFFF);
    }

    public static BigLongLibBase.BigLong or(BigLongLibBase.BigLong a, BigLongLibBase.BigLong b) {
        return BigLongLib.create(BigLongLib.getL(a) | BigLongLib.getL(b), BigLongLib.getM(a) | BigLongLib.getM(b), BigLongLib.getH(a) | BigLongLib.getH(b));
    }

    public static BigLongLibBase.BigLong shl(BigLongLibBase.BigLong a, int n) {
        int res2;
        int res1;
        int res0;
        if ((n &= 0x3F) < 22) {
            res0 = BigLongLib.getL(a) << n;
            res1 = BigLongLib.getM(a) << n | BigLongLib.getL(a) >> 22 - n;
            res2 = BigLongLib.getH(a) << n | BigLongLib.getM(a) >> 22 - n;
        } else if (n < 44) {
            res0 = 0;
            res1 = BigLongLib.getL(a) << n - 22;
            res2 = BigLongLib.getM(a) << n - 22 | BigLongLib.getL(a) >> 44 - n;
        } else {
            res0 = 0;
            res1 = 0;
            res2 = BigLongLib.getL(a) << n - 44;
        }
        return BigLongLib.create(res0 & 0x3FFFFF, res1 & 0x3FFFFF, res2 & 0xFFFFF);
    }

    public static BigLongLibBase.BigLong shr(BigLongLibBase.BigLong a, int n) {
        int res0;
        int res1;
        int res2;
        boolean negative;
        n &= 0x3F;
        int a2 = BigLongLib.getH(a);
        boolean bl = negative = (a2 & 0x80000) != 0;
        if (negative) {
            a2 |= 0xFFF00000;
        }
        if (n < 22) {
            res2 = a2 >> n;
            res1 = BigLongLib.getM(a) >> n | a2 << 22 - n;
            res0 = BigLongLib.getL(a) >> n | BigLongLib.getM(a) << 22 - n;
        } else if (n < 44) {
            res2 = negative ? 1048575 : 0;
            res1 = a2 >> n - 22;
            res0 = BigLongLib.getM(a) >> n - 22 | a2 << 44 - n;
        } else {
            res2 = negative ? 1048575 : 0;
            res1 = negative ? 0x3FFFFF : 0;
            res0 = a2 >> n - 44;
        }
        return BigLongLib.create(res0 & 0x3FFFFF, res1 & 0x3FFFFF, res2 & 0xFFFFF);
    }

    public static BigLongLibBase.BigLong shru(BigLongLibBase.BigLong a, int n) {
        int res0;
        int res1;
        int res2;
        int a2 = BigLongLib.getH(a) & 0xFFFFF;
        if ((n &= 0x3F) < 22) {
            res2 = a2 >>> n;
            res1 = BigLongLib.getM(a) >> n | a2 << 22 - n;
            res0 = BigLongLib.getL(a) >> n | BigLongLib.getM(a) << 22 - n;
        } else if (n < 44) {
            res2 = 0;
            res1 = a2 >>> n - 22;
            res0 = BigLongLib.getM(a) >> n - 22 | BigLongLib.getH(a) << 44 - n;
        } else {
            res2 = 0;
            res1 = 0;
            res0 = a2 >>> n - 44;
        }
        return BigLongLib.create(res0 & 0x3FFFFF, res1 & 0x3FFFFF, res2 & 0xFFFFF);
    }

    public static BigLongLibBase.BigLong sub(BigLongLibBase.BigLong a, BigLongLibBase.BigLong b) {
        int sum0 = BigLongLib.getL(a) - BigLongLib.getL(b);
        int sum1 = BigLongLib.getM(a) - BigLongLib.getM(b) + (sum0 >> 22);
        int sum2 = BigLongLib.getH(a) - BigLongLib.getH(b) + (sum1 >> 22);
        return BigLongLib.create(sum0 & 0x3FFFFF, sum1 & 0x3FFFFF, sum2 & 0xFFFFF);
    }

    public static double toDouble(BigLongLibBase.BigLong a) {
        if (BigLongLib.compare(a, Const.ZERO) < 0.0) {
            return -BigLongLib.toDoubleHelper(BigLongLib.neg(a));
        }
        return BigLongLib.toDoubleHelper(a);
    }

    public static int toInt(BigLongLibBase.BigLong a) {
        return BigLongLib.getL(a) | BigLongLib.getM(a) << 22;
    }

    public static String toString(BigLongLibBase.BigLong a) {
        if (BigLongLibBase.isZero(a)) {
            return "0";
        }
        if (BigLongLibBase.isMinValue(a)) {
            return "-9223372036854775808";
        }
        if (BigLongLibBase.isNegative(a)) {
            return "-" + BigLongLib.toString(BigLongLib.neg(a));
        }
        BigLongLibBase.BigLong rem = a;
        String res = "";
        while (!BigLongLibBase.isZero(rem)) {
            int tenPowerZeroes = 9;
            int tenPower = 1000000000;
            BigLongLibBase.BigLong tenPowerLong = BigLongLib.fromInt(1000000000);
            rem = BigLongLib.divMod(rem, tenPowerLong, true);
            String digits = "" + BigLongLib.toInt(BigLongLibBase.remainder);
            if (!BigLongLibBase.isZero(rem)) {
                for (int zeroesNeeded = 9 - digits.length(); zeroesNeeded > 0; --zeroesNeeded) {
                    digits = "0" + digits;
                }
            }
            res = digits + res;
        }
        return res;
    }

    public static BigLongLibBase.BigLong xor(BigLongLibBase.BigLong a, BigLongLibBase.BigLong b) {
        return BigLongLib.create(BigLongLib.getL(a) ^ BigLongLib.getL(b), BigLongLib.getM(a) ^ BigLongLib.getM(b), BigLongLib.getH(a) ^ BigLongLib.getH(b));
    }

    private BigLongLib() {
    }

    static class Const {
        static final BigLongLibBase.BigLong MAX_VALUE = BigLongLibBase.create(0x3FFFFF, 0x3FFFFF, 524287);
        static final BigLongLibBase.BigLong MIN_VALUE = BigLongLibBase.create(0, 0, 524288);
        static final BigLongLibBase.BigLong ONE = BigLongLib.fromInt(1);
        static final BigLongLibBase.BigLong TWO = BigLongLib.fromInt(2);
        static final BigLongLibBase.BigLong ZERO = BigLongLib.fromInt(0);

        Const() {
        }
    }
}

