/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.junit.BatchingStrategy;
import com.google.gwt.junit.CompileStrategy;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.client.GWTTestCase;
import java.util.HashMap;
import java.util.Map;

class PreCompileStrategy
extends CompileStrategy {
    Map<String, ModuleDef> preCompiledModuleDefs;

    public PreCompileStrategy(JUnitShell junitShell) {
        super(junitShell);
    }

    @Override
    public ModuleDef maybeCompileModule(String moduleName, String syntheticModuleName, JUnitShell.Strategy strategy, BatchingStrategy batchingStrategy, TreeLogger treeLogger) throws UnableToCompleteException {
        this.maybePrecompileModules(batchingStrategy, treeLogger);
        return this.preCompiledModuleDefs.get(syntheticModuleName);
    }

    private void maybePrecompileModules(BatchingStrategy batchingStrategy, TreeLogger treeLogger) throws UnableToCompleteException {
        if (this.preCompiledModuleDefs == null) {
            this.preCompiledModuleDefs = new HashMap<String, ModuleDef>();
            for (String moduleName : GWTTestCase.getAllTestModuleNames()) {
                GWTTestCase.TestModuleInfo moduleInfo = GWTTestCase.getTestsForModule(moduleName);
                String syntheticModuleName = moduleInfo.getSyntheticModuleName();
                if (syntheticModuleName == null) continue;
                ModuleDef moduleDef = this.maybeCompileModuleImpl(moduleInfo.getModuleName(), syntheticModuleName, moduleInfo.getStrategy(), batchingStrategy, treeLogger);
                this.preCompiledModuleDefs.put(syntheticModuleName, moduleDef);
            }
        }
    }
}

