/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.junit.BatchingStrategy;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.PreCompileStrategy;
import com.google.gwt.junit.client.GWTTestCase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ParallelCompileStrategy
extends PreCompileStrategy {
    private BatchingStrategy batchingStrategy;
    private List<String> modulesToCompile = new ArrayList<String>();
    private TreeLogger treeLogger;

    public ParallelCompileStrategy(JUnitShell junitShell) {
        super(junitShell);
    }

    @Override
    public void maybeCompileAhead() throws UnableToCompleteException {
        if (this.modulesToCompile.size() > 0) {
            String nextModule = this.modulesToCompile.remove(0);
            GWTTestCase.TestModuleInfo moduleInfo = GWTTestCase.getTestsForModule(nextModule);
            String syntheticModuleName = moduleInfo.getSyntheticModuleName();
            this.maybeCompileModuleImpl(moduleInfo.getModuleName(), syntheticModuleName, moduleInfo.getStrategy(), this.batchingStrategy, this.treeLogger);
        }
    }

    @Override
    public ModuleDef maybeCompileModule(String moduleName, String syntheticModuleName, JUnitShell.Strategy strategy, BatchingStrategy batchingStrategy, TreeLogger treeLogger) throws UnableToCompleteException {
        ModuleDef moduleDef;
        if (this.preCompiledModuleDefs == null) {
            String[] allModuleNames;
            this.batchingStrategy = batchingStrategy;
            this.treeLogger = treeLogger;
            this.preCompiledModuleDefs = new HashMap();
            for (String curModuleName : allModuleNames = GWTTestCase.getAllTestModuleNames()) {
                this.modulesToCompile.add(curModuleName);
            }
        }
        if ((moduleDef = (ModuleDef)this.preCompiledModuleDefs.get(syntheticModuleName)) == null) {
            moduleDef = this.maybeCompileModuleImpl(moduleName, syntheticModuleName, strategy, batchingStrategy, treeLogger);
        }
        return moduleDef;
    }

    @Override
    protected ModuleDef maybeCompileModuleImpl(String moduleName, String syntheticModuleName, JUnitShell.Strategy strategy, BatchingStrategy batchingStrategy, TreeLogger treeLogger) throws UnableToCompleteException {
        this.modulesToCompile.remove(syntheticModuleName);
        ModuleDef moduleDef = super.maybeCompileModuleImpl(moduleName, syntheticModuleName, strategy, batchingStrategy, treeLogger);
        this.preCompiledModuleDefs.put(syntheticModuleName, moduleDef);
        return moduleDef;
    }
}

