/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.core.ext.Linker;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.impl.StandardLinkerContext;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.core.shared.SerializableThrowable;
import com.google.gwt.dev.ArgProcessorBase;
import com.google.gwt.dev.Compiler;
import com.google.gwt.dev.CompilerContext;
import com.google.gwt.dev.CompilerOptions;
import com.google.gwt.dev.DevMode;
import com.google.gwt.dev.DevModeBase;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.Properties;
import com.google.gwt.dev.cfg.Property;
import com.google.gwt.dev.javac.CompilationProblemReporter;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.jjs.JsOutputOption;
import com.google.gwt.dev.shell.jetty.JettyLauncher;
import com.google.gwt.dev.util.arg.ArgHandlerClosureFormattedOutput;
import com.google.gwt.dev.util.arg.ArgHandlerDeployDir;
import com.google.gwt.dev.util.arg.ArgHandlerDeprecatedOptimizeDataflow;
import com.google.gwt.dev.util.arg.ArgHandlerDisableCastChecking;
import com.google.gwt.dev.util.arg.ArgHandlerDisableClassMetadata;
import com.google.gwt.dev.util.arg.ArgHandlerDisableClusterSimilarFunctions;
import com.google.gwt.dev.util.arg.ArgHandlerDisableInlineLiteralParameters;
import com.google.gwt.dev.util.arg.ArgHandlerDisableOrdinalizeEnums;
import com.google.gwt.dev.util.arg.ArgHandlerDisableRemoveDuplicateFunctions;
import com.google.gwt.dev.util.arg.ArgHandlerDisableRunAsync;
import com.google.gwt.dev.util.arg.ArgHandlerDraftCompile;
import com.google.gwt.dev.util.arg.ArgHandlerEnableAssertions;
import com.google.gwt.dev.util.arg.ArgHandlerExtraDir;
import com.google.gwt.dev.util.arg.ArgHandlerFilterJsInteropExports;
import com.google.gwt.dev.util.arg.ArgHandlerGenDir;
import com.google.gwt.dev.util.arg.ArgHandlerGenerateJsInteropExports;
import com.google.gwt.dev.util.arg.ArgHandlerIncrementalCompile;
import com.google.gwt.dev.util.arg.ArgHandlerLocalWorkers;
import com.google.gwt.dev.util.arg.ArgHandlerLogLevel;
import com.google.gwt.dev.util.arg.ArgHandlerNamespace;
import com.google.gwt.dev.util.arg.ArgHandlerOptimize;
import com.google.gwt.dev.util.arg.ArgHandlerScriptStyle;
import com.google.gwt.dev.util.arg.ArgHandlerSetProperties;
import com.google.gwt.dev.util.arg.ArgHandlerSourceLevel;
import com.google.gwt.dev.util.arg.ArgHandlerWarDir;
import com.google.gwt.dev.util.arg.ArgHandlerWorkDirOptional;
import com.google.gwt.junit.BatchingStrategy;
import com.google.gwt.junit.ClassBatchingStrategy;
import com.google.gwt.junit.CompileStrategy;
import com.google.gwt.junit.DoNotRunWith;
import com.google.gwt.junit.JUnitFatalLaunchException;
import com.google.gwt.junit.JUnitMessageQueue;
import com.google.gwt.junit.ModuleBatchingStrategy;
import com.google.gwt.junit.NoBatchingStrategy;
import com.google.gwt.junit.ParallelCompileStrategy;
import com.google.gwt.junit.Platform;
import com.google.gwt.junit.PreCompileStrategy;
import com.google.gwt.junit.RunStyle;
import com.google.gwt.junit.RunStyleManual;
import com.google.gwt.junit.SimpleCompileStrategy;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.junit.client.TimeoutException;
import com.google.gwt.junit.client.impl.JUnitHost;
import com.google.gwt.junit.client.impl.JUnitResult;
import com.google.gwt.thirdparty.guava.common.base.Splitter;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerInt;
import com.google.gwt.util.tools.ArgHandlerString;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class JUnitShell
extends DevMode {
    private static final int DEFAULT_BEGIN_TIMEOUT_MINUTES = 1;
    private static final String PROP_GWT_ARGS = "gwt.args";
    private static JUnitShell unitTestShell;
    WebAppContext wac;
    private long baseTestBeginTimeoutMillis;
    private long baseTestMethodTimeoutMillis;
    private BatchingStrategy batchingStrategy = new NoBatchingStrategy();
    private CompileStrategy compileStrategy = new SimpleCompileStrategy(this);
    private CompilationState currentCompilationState;
    private ModuleDef currentModule;
    private JUnitHost.TestInfo currentTestInfo;
    private boolean developmentMode = false;
    private boolean runStyleStarted;
    private boolean waitingForClients = true;
    private boolean lastLaunchFailed;
    private ModuleDef lastModule;
    private final Map<String, String> loadedServletsByPath = new HashMap<String, String>();
    private JUnitMessageQueue messageQueue;
    private UnableToCompleteException pendingException;
    Set<String> userAgentsOpt;
    private RunStyle runStyle = null;
    private String runStyleName = "HtmlUnit";
    private long testBatchingMethodTimeoutMillis;
    private long testBeginTime;
    private long testBeginTimeout;
    private long testMethodTimeout;
    private int tries;

    public static JUnitMessageQueue getMessageQueue() {
        if (unitTestShell == null) {
            return null;
        }
        return JUnitShell.unitTestShell.messageQueue;
    }

    public static Set<String> getRemoteUserAgents() {
        if (unitTestShell == null) {
            return null;
        }
        return JUnitShell.unitTestShell.runStyle.getUserAgents();
    }

    public static CompilerOptions getCompilerOptions() {
        if (unitTestShell == null) {
            return null;
        }
        return JUnitShell.unitTestShell.options;
    }

    public static boolean mustNotExecuteTest(JUnitHost.TestInfo testInfo) {
        if (unitTestShell == null) {
            throw new IllegalStateException("mustNotExecuteTest cannot be called before runTest()");
        }
        try {
            Class<?> testClass = TestCase.class.getClassLoader().loadClass(testInfo.getTestClass());
            return unitTestShell.mustNotExecuteTest(JUnitShell.getBannedPlatforms(testClass, testInfo.getTestMethod()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load test class: " + testInfo.getTestClass());
        }
    }

    public static void runTest(GWTTestCase testCase, TestResult testResult) throws UnableToCompleteException {
        JUnitShell.getUnitTestShell().runTestImpl(testCase, testResult);
    }

    static JUnitShell getUnitTestShell() {
        if (unitTestShell == null) {
            unitTestShell = new JUnitShell();
            JUnitShell.unitTestShell.lastLaunchFailed = true;
            ArgProcessor argProcessor = new ArgProcessor(unitTestShell);
            String[] args = unitTestShell.synthesizeArgs();
            if (!argProcessor.processArgs(args)) {
                throw new JUnitFatalLaunchException("Error processing shell arguments");
            }
            JUnitShell.unitTestShell.options.setBindAddress("0.0.0.0");
            try {
                JUnitShell.unitTestShell.options.setConnectAddress(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                throw new JUnitFatalLaunchException("Unable to resolve my address", e);
            }
            if (!unitTestShell.startUp()) {
                throw new JUnitFatalLaunchException("Shell failed to start");
            }
            JUnitShell.unitTestShell.lastLaunchFailed = false;
        }
        unitTestShell.checkArgs();
        return unitTestShell;
    }

    private static JUnitFatalLaunchException checkTestClassInCurrentModule(TreeLogger logger, CompilationState compilationState, String moduleName, TestCase testCase) {
        String errMsg;
        com.google.gwt.dev.javac.typemodel.TypeOracle typeOracle = compilationState.getTypeOracle();
        String typeName = testCase.getClass().getName();
        JClassType foundType = ((TypeOracle)typeOracle).findType(typeName = typeName.replace('$', '.'));
        if (foundType != null) {
            return null;
        }
        Map<String, CompilationUnit> unitMap = compilationState.getCompilationUnitMap();
        CompilationUnit unit = unitMap.get(typeName);
        if (unit == null) {
            errMsg = "The test class '" + typeName + "' was not found in module '" + moduleName + "'; no compilation unit for that type was seen";
        } else {
            CompilationProblemReporter.logErrorTrace(logger, TreeLogger.ERROR, compilationState.getCompilerContext(), typeName, true);
            errMsg = "The test class '" + typeName + "' had compile errors; check log for details";
        }
        return new JUnitFatalLaunchException(errMsg);
    }

    private static Set<Platform> getBannedPlatforms(Class<?> testClass, String methodName) {
        EnumSet<Platform> bannedSet = EnumSet.noneOf(Platform.class);
        if (testClass.isAnnotationPresent(DoNotRunWith.class)) {
            bannedSet.addAll(Arrays.asList(testClass.getAnnotation(DoNotRunWith.class).value()));
        }
        try {
            Method testMethod = testClass.getMethod(methodName, new Class[0]);
            if (testMethod.isAnnotationPresent(DoNotRunWith.class)) {
                bannedSet.addAll(Arrays.asList(testMethod.getAnnotation(DoNotRunWith.class).value()));
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return bannedSet;
    }

    JUnitShell() {
        this.setRunTomcat(true);
        this.setHeadless(true);
    }

    public String getModuleUrl(String moduleName) {
        String localhost = this.runStyle.getLocalHostName();
        int codeServerPort = this.developmentMode ? this.listener.getSocketPort() : 0;
        return this.getModuleUrl(localhost, this.getPort(), moduleName, codeServerPort);
    }

    public CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    @Override
    protected DevMode.HostedModeOptions createOptions() {
        DevMode.HostedModeOptions options = super.createOptions();
        options.setSuperDevMode(false);
        options.setIncrementalCompileEnabled(false);
        return options;
    }

    @Override
    protected boolean doStartup() {
        if (!super.doStartup()) {
            return false;
        }
        int numClients = this.createRunStyle(this.runStyleName);
        if (numClients < 0) {
            return false;
        }
        this.messageQueue = new JUnitMessageQueue(numClients);
        if (this.tries >= 1) {
            this.runStyle.setTries(this.tries);
        }
        if (this.userAgentsOpt != null) {
            this.runStyle.setUserAgents(this.userAgentsOpt);
        }
        if (!this.runStyle.setupMode(this.getTopLogger(), this.developmentMode)) {
            this.getTopLogger().log(TreeLogger.ERROR, "Run style does not support " + (this.developmentMode ? "development" : "production") + " mode");
            return false;
        }
        return true;
    }

    @Override
    protected void ensureCodeServerListener() {
        if (this.developmentMode) {
            super.ensureCodeServerListener();
            this.listener.setIgnoreRemoteDeath(true);
        }
    }

    @Override
    protected void inferStartupUrls() {
    }

    @Override
    protected ModuleDef loadModule(TreeLogger logger, String moduleName, boolean refresh) throws UnableToCompleteException {
        return super.loadModule(logger, moduleName, false);
    }

    protected boolean notDone() {
        int activeClients = this.messageQueue.getNumClientsRetrievedTest(this.currentTestInfo);
        int expectedClients = this.messageQueue.getNumClients();
        if (this.runStyle instanceof RunStyleManual && this.waitingForClients) {
            String[] newClients = this.messageQueue.getNewClients();
            int printIndex = activeClients - newClients.length + 1;
            for (String newClient : newClients) {
                System.out.println(printIndex + " - " + newClient);
                ++printIndex;
            }
            if (activeClients < expectedClients) {
                return true;
            }
            this.waitingForClients = false;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (activeClients >= expectedClients) {
            if (activeClients > expectedClients) {
                this.getTopLogger().log(TreeLogger.WARN, "Too many clients: expected " + expectedClients + ", found " + activeClients);
            }
            this.lastModule = this.currentModule;
            if (this.testMethodTimeout == 0L) {
                this.testMethodTimeout = currentTimeMillis + this.testBatchingMethodTimeoutMillis;
            } else if (this.testMethodTimeout < currentTimeMillis) {
                double elapsed = (double)(currentTimeMillis - this.testBeginTime) / 1000.0;
                throw new TimeoutException("The browser did not complete the test method " + this.currentTestInfo.toString() + " in " + this.testBatchingMethodTimeoutMillis + "ms.\n  We have no results from:\n" + this.messageQueue.getWorkingClients(this.currentTestInfo) + "Actual time elapsed: " + elapsed + " seconds.\nTry increasing this timeout using the '-testMethodTimeout minutes' option\n");
            }
        } else if (this.testBeginTimeout < currentTimeMillis) {
            double elapsed = (double)(currentTimeMillis - this.testBeginTime) / 1000.0;
            throw new TimeoutException("The browser did not contact the server within " + this.baseTestBeginTimeoutMillis + "ms.\n" + this.messageQueue.getUnretrievedClients(this.currentTestInfo) + "\n Actual time elapsed: " + elapsed + " seconds.\nTry increasing this timeout using the '-testBeginTimeout minutes' option\nThe default value of minutes is 1, i.e., the server waits 1 minute or 60 seconds.\n");
        }
        String[] interruptedHosts = this.runStyle.getInterruptedHosts();
        if (interruptedHosts != null) {
            StringBuilder msg = new StringBuilder();
            msg.append("A remote browser died a mysterious death.\n");
            msg.append("  We lost communication with:");
            for (String host : interruptedHosts) {
                msg.append("\n  ").append(host);
            }
            throw new TimeoutException(msg.toString());
        }
        if (this.messageQueue.hasResults(this.currentTestInfo)) {
            return false;
        }
        if (this.pendingException == null) {
            try {
                this.compileStrategy.maybeCompileAhead();
            }
            catch (UnableToCompleteException e) {
                this.pendingException = e;
            }
        }
        return true;
    }

    @Override
    protected void warnAboutNoStartupUrls() {
    }

    void compileForWebMode(ModuleDef module, Set<String> userAgents) throws UnableToCompleteException {
        Properties props;
        Property userAgent;
        if (userAgents != null && !userAgents.isEmpty() && (userAgent = (props = module.getProperties()).find("user.agent")) instanceof BindingProperty) {
            BindingProperty bindingProperty = (BindingProperty)userAgent;
            bindingProperty.setRootGeneratedValues(userAgents.toArray(new String[0]));
        }
        if (this.options.isClosureCompilerFormatEnabled()) {
            module.addLinker("closureHelpers");
        }
        boolean success = false;
        try {
            success = Compiler.compile(this.getTopLogger(), this.options, module);
        }
        catch (Exception e) {
            CompilationProblemReporter.logAndTranslateException(this.getTopLogger(), e);
        }
        if (!success) {
            throw new UnableToCompleteException();
        }
    }

    String getModuleUrl(String hostName, int port, String moduleName, int codeServerPort) {
        String url = "http://" + hostName + ":" + port + "/" + moduleName + "/junit.html";
        if (this.developmentMode) {
            url = url + "?gwt.codesvr=" + hostName + ":" + codeServerPort;
        }
        return url;
    }

    void maybeCompileForWebMode(ModuleDef module, Set<String> userAgents) throws UnableToCompleteException {
        this.compilerContext = this.compilerContextBuilder.module(module).build();
        for (String path : module.getServletPaths()) {
            String servletClass = module.findServletForPath(path);
            if (servletClass.equals(this.loadedServletsByPath.get(path = '/' + module.getName() + path))) continue;
            try {
                Class<Servlet> clazz = this.wac.loadClass(servletClass).asSubclass(Servlet.class);
                this.wac.addServlet(clazz, path);
                this.loadedServletsByPath.put(path, servletClass);
            }
            catch (ClassNotFoundException e) {
                this.getTopLogger().log(TreeLogger.WARN, "Failed to load servlet class '" + servletClass + "' declared in '" + module.getName() + "'", e);
            }
        }
        BindingProperty strictCspTestingEnabledProperty = module.getProperties().findBindingProp("gwt.strictCspTestingEnabled");
        if (strictCspTestingEnabledProperty != null && "true".equals(strictCspTestingEnabledProperty.getConstrainedValue())) {
            this.addCspFilter("/" + module.getName() + "/*");
        }
        if (this.developmentMode) {
            try {
                Linker l = module.getActivePrimaryLinker().newInstance();
                StandardLinkerContext context = new StandardLinkerContext(this.getTopLogger(), module, this.compilerContext.getPublicResourceOracle(), JsOutputOption.PRETTY);
                if (!l.supportsDevModeInJunit(context) && module.getLinker("std") != null) {
                    module.addLinker("std");
                }
            }
            catch (Exception e) {
                this.getTopLogger().log(TreeLogger.WARN, "Failed to instantiate linker: " + e);
            }
            super.link(this.getTopLogger(), module);
        } else {
            this.compileForWebMode(module, userAgents);
        }
    }

    private void addCspFilter(String path) {
        this.wac.addFilter(new FilterHolder(new Filter(){

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.addHeader("Content-Security-Policy", "script-src 'nonce-gwt-nonce' 'unsafe-inline' 'strict-dynamic' https: http: 'unsafe-eval' 'report-sample'");
                chain.doFilter(request, response);
            }

            public void init(FilterConfig arg0) throws ServletException {
            }

            public void destroy() {
            }
        }), path, EnumSet.of(DispatcherType.REQUEST));
    }

    private void checkArgs() {
        if (this.runStyle.getTries() > 1 && !(this.batchingStrategy instanceof NoBatchingStrategy)) {
            throw new JUnitFatalLaunchException("Batching does not work with tries > 1");
        }
    }

    private int createRunStyle(String runStyleName) {
        String args = null;
        String name = runStyleName;
        int colon = name.indexOf(58);
        if (colon >= 0) {
            args = name.substring(colon + 1);
            name = name.substring(0, colon);
        }
        if (name.indexOf(46) < 0) {
            name = RunStyle.class.getName() + name;
        }
        Exception caught = null;
        try {
            Class<?> clazz = Class.forName(name);
            Class<RunStyle> runStyleClass = clazz.asSubclass(RunStyle.class);
            Constructor<RunStyle> ctor = runStyleClass.getConstructor(JUnitShell.class);
            this.runStyle = ctor.newInstance(this);
            return this.runStyle.initialize(args);
        }
        catch (ClassNotFoundException e) {
            String msg = "Unable to create runStyle \"" + runStyleName + "\"";
            msg = runStyleName.indexOf(46) < 0 && runStyleName.length() > 0 && Character.isLowerCase(runStyleName.charAt(0)) ? msg + " - did you mean \"" + Character.toUpperCase(runStyleName.charAt(0)) + runStyleName.substring(1) + "\"?" : msg + " -- is it spelled correctly?";
            this.getTopLogger().log(TreeLogger.ERROR, msg);
            return -1;
        }
        catch (SecurityException e) {
            caught = e;
        }
        catch (NoSuchMethodException e) {
            caught = e;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (InstantiationException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e;
        }
        this.getTopLogger().log(TreeLogger.ERROR, "Unable to create runStyle \"" + runStyleName + "\"", caught);
        return -1;
    }

    private boolean mustNotExecuteTest(Set<Platform> bannedPlatforms) {
        if (!Collections.disjoint(bannedPlatforms, this.runStyle.getPlatforms())) {
            return true;
        }
        return this.developmentMode ? bannedPlatforms.contains((Object)Platform.Devel) : bannedPlatforms.contains((Object)Platform.Prod);
    }

    private boolean mustRetry(int numTries) {
        if (numTries >= this.runStyle.getTries()) {
            return false;
        }
        assert (this.batchingStrategy instanceof NoBatchingStrategy);
        return true;
    }

    private void processTestResult(TestCase testCase, TestResult testResult) {
        Map<JUnitMessageQueue.ClientStatus, JUnitResult> results = this.messageQueue.getResults(this.currentTestInfo);
        assert (results != null);
        assert (results.size() == this.messageQueue.getNumClients()) : results.size() + " != " + this.messageQueue.getNumClients();
        for (Map.Entry<JUnitMessageQueue.ClientStatus, JUnitResult> entry : results.entrySet()) {
            JUnitResult result = entry.getValue();
            assert (result != null);
            if (!result.isAnyException()) continue;
            if (result.isExceptionOf(AssertionFailedError.class)) {
                testResult.addFailure(testCase, this.toAssertionFailedError(result.getException()));
                continue;
            }
            testResult.addError(testCase, result.getException());
        }
    }

    private AssertionFailedError toAssertionFailedError(SerializableThrowable thrown) {
        AssertionFailedError error = new AssertionFailedError(thrown.getMessage());
        error.setStackTrace(thrown.getStackTrace());
        if (thrown.getCause() != null) {
            error.initCause(thrown.getCause());
        }
        return error;
    }

    private void runTestImpl(GWTTestCase testCase, TestResult testResult) throws UnableToCompleteException {
        this.runTestImpl(testCase, testResult, 0);
    }

    private void runTestImpl(GWTTestCase testCase, TestResult testResult, int numTries) throws UnableToCompleteException {
        boolean mustRetry;
        block18: {
            boolean sameTest;
            this.testBatchingMethodTimeoutMillis = (long)this.batchingStrategy.getTimeoutMultiplier() * this.baseTestMethodTimeoutMillis;
            if (this.mustNotExecuteTest(JUnitShell.getBannedPlatforms(testCase.getClass(), testCase.getName()))) {
                return;
            }
            if (this.lastLaunchFailed) {
                throw new UnableToCompleteException();
            }
            String moduleName = testCase.getModuleName();
            String syntheticModuleName = testCase.getSyntheticModuleName();
            Strategy strategy = testCase.getStrategy();
            boolean bl = sameTest = this.currentModule != null && syntheticModuleName.equals(this.currentModule.getName());
            if (sameTest && this.lastLaunchFailed) {
                throw new UnableToCompleteException();
            }
            if (!sameTest) {
                try {
                    this.currentModule = this.compileStrategy.maybeCompileModule(moduleName, syntheticModuleName, strategy, this.batchingStrategy, this.getTopLogger());
                    this.compilerContext = this.compilerContextBuilder.module(this.currentModule).build();
                    this.currentCompilationState = this.currentModule.getCompilationState(this.getTopLogger(), this.compilerContext);
                }
                catch (UnableToCompleteException e) {
                    this.lastLaunchFailed = true;
                    throw e;
                }
            }
            assert (this.currentModule != null);
            JUnitFatalLaunchException launchException = JUnitShell.checkTestClassInCurrentModule(this.getTopLogger(), this.currentCompilationState, moduleName, testCase);
            if (launchException != null) {
                testResult.addError(testCase, launchException);
                return;
            }
            this.currentTestInfo = new JUnitHost.TestInfo(this.currentModule.getName(), testCase.getClass().getName(), testCase.getName());
            ++numTries;
            if (this.messageQueue.hasResults(this.currentTestInfo)) {
                this.processTestResult(testCase, testResult);
                return;
            }
            this.compileStrategy.maybeAddTestBlockForCurrentTest(testCase, this.batchingStrategy);
            try {
                if (!this.runStyleStarted) {
                    this.runStyle.launchModule(this.currentModule.getName());
                }
            }
            catch (UnableToCompleteException e) {
                this.lastLaunchFailed = true;
                testResult.addError(testCase, new JUnitFatalLaunchException(e));
                return;
            }
            this.runStyleStarted = true;
            mustRetry = this.mustRetry(numTries);
            try {
                this.testBeginTime = System.currentTimeMillis();
                this.testBeginTimeout = this.testBeginTime + this.baseTestBeginTimeoutMillis;
                this.testMethodTimeout = 0L;
                while (this.notDone()) {
                    this.messageQueue.waitForResults(1000);
                }
                if (!mustRetry && this.pendingException != null) {
                    UnableToCompleteException e = this.pendingException;
                    this.pendingException = null;
                    throw e;
                }
            }
            catch (TimeoutException e) {
                if (mustRetry) break block18;
                this.lastLaunchFailed = true;
                testResult.addError(testCase, e);
                return;
            }
        }
        if (mustRetry && this.messageQueue.needsRerunning(this.currentTestInfo)) {
            this.messageQueue.removeResults(this.currentTestInfo);
            this.getTopLogger().log(TreeLogger.WARN, this.currentTestInfo + " is being retried, retry attempt = " + numTries);
            this.runTestImpl(testCase, testResult, numTries);
            return;
        }
        assert (this.messageQueue.hasResults(this.currentTestInfo));
        this.processTestResult(testCase, testResult);
    }

    private String[] synthesizeArgs() {
        ArrayList<String> argList = new ArrayList<String>();
        String args = System.getProperty(PROP_GWT_ARGS);
        if (args != null) {
            Pattern pattern = Pattern.compile("[^\\s\"]+|\"[^\"\\\\]*(\\\\.[^\"\\\\]*)*\"");
            Matcher matcher = pattern.matcher(args);
            Pattern quotedArgsPattern = Pattern.compile("^([\"'])(.*)([\"'])$");
            while (matcher.find()) {
                String arg = matcher.group();
                Matcher qmatcher = quotedArgsPattern.matcher(arg);
                if (qmatcher.matches()) {
                    argList.add(qmatcher.group(2));
                    continue;
                }
                argList.add(arg);
            }
        }
        return argList.toArray(new String[argList.size()]);
    }

    private final class MyJettyLauncher
    extends JettyLauncher {
        private MyJettyLauncher() {
        }

        @Override
        protected JettyLauncher.JettyServletContainer createServletContainer(TreeLogger logger, File appRootDir, Server server, WebAppContext wac, int localPort) {
            server.setStopAtShutdown(false);
            JUnitShell.this.wac = wac;
            return super.createServletContainer(logger, appRootDir, server, wac, localPort);
        }

        @Override
        protected WebAppContext createWebAppContext(TreeLogger logger, File appRootDir) {
            return new WebAppContext(appRootDir.getAbsolutePath(), "/"){
                {
                    this.getInitParams().put("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
                    this.setParentLoaderPriority(true);
                }
            };
        }
    }

    static class ArgProcessor
    extends ArgProcessorBase {
        public ArgProcessor(final JUnitShell shell) {
            DevMode.HostedModeOptions options = shell.options;
            this.registerHandler(new DevModeBase.ArgHandlerPort(options){

                @Override
                public String[] getDefaultArgs() {
                    return new String[]{"-port", "auto"};
                }
            });
            this.registerHandler(new DevModeBase.ArgHandlerLogDir(options));
            this.registerHandler(new ArgHandlerLogLevel(options));
            this.registerHandler(new ArgHandlerGenDir(options));
            this.registerHandler(new DevModeBase.ArgHandlerCodeServerPort(options){

                @Override
                public String[] getDefaultArgs() {
                    return new String[]{this.getTag(), "auto"};
                }
            });
            JettyLauncher.suppressDeprecationWarningForTests();
            JUnitShell jUnitShell = shell;
            Objects.requireNonNull(jUnitShell);
            options.setServletContainerLauncher(jUnitShell.new MyJettyLauncher());
            this.registerHandler(new ArgHandlerWarDir(options){
                private static final String OUT_TAG = "-out";

                @Override
                public String[] getTags() {
                    return new String[]{this.getTag(), OUT_TAG};
                }

                @Override
                public int handle(String[] args, int tagIndex) {
                    if (OUT_TAG.equals(args[tagIndex])) {
                        System.err.println("The -out option is deprecated. This option will be removed in future GWT release and will throw an error if it is still used. Please use -war option instead.");
                    }
                    return super.handle(args, tagIndex);
                }
            });
            this.registerHandler(new ArgHandlerDeployDir(options));
            this.registerHandler(new ArgHandlerExtraDir(options));
            this.registerHandler(new ArgHandlerWorkDirOptional(options));
            this.registerHandler(new ArgHandlerSourceLevel(options));
            this.registerHandler(new ArgHandlerScriptStyle(options));
            this.registerHandler(new ArgHandlerEnableAssertions(options));
            this.registerHandler(new ArgHandlerDisableCastChecking(options));
            this.registerHandler(new ArgHandlerDisableClassMetadata(options));
            this.registerHandler(new ArgHandlerDisableClusterSimilarFunctions(options));
            this.registerHandler(new ArgHandlerDisableInlineLiteralParameters(options));
            this.registerHandler(new ArgHandlerDeprecatedOptimizeDataflow(options));
            this.registerHandler(new ArgHandlerDisableOrdinalizeEnums(options));
            this.registerHandler(new ArgHandlerDisableRemoveDuplicateFunctions(options));
            this.registerHandler(new ArgHandlerDisableRunAsync(options));
            this.registerHandler(new ArgHandlerDraftCompile(options));
            this.registerHandler(new ArgHandlerLocalWorkers(options));
            this.registerHandler(new ArgHandlerNamespace(options));
            this.registerHandler(new ArgHandlerOptimize(options));
            this.registerHandler(new ArgHandlerIncrementalCompile(options));
            this.registerHandler(new ArgHandlerGenerateJsInteropExports(options));
            this.registerHandler(new ArgHandlerFilterJsInteropExports(options));
            this.registerHandler(new ArgHandlerSetProperties(options));
            this.registerHandler(new ArgHandlerClosureFormattedOutput(options));
            this.registerHandler(new ArgHandlerLogLevel(options, TreeLogger.WARN));
            this.registerHandler(new ArgHandlerRunCompiledJavascript(shell));
            this.registerHandler(new ArgHandlerInt(){

                @Override
                public String[] getDefaultArgs() {
                    return new String[]{this.getTag(), "5"};
                }

                @Override
                public String getPurpose() {
                    return "Set the test method timeout, in minutes";
                }

                @Override
                public String getTag() {
                    return "-testMethodTimeout";
                }

                @Override
                public String[] getTagArgs() {
                    return new String[]{"minutes"};
                }

                @Override
                public boolean isUndocumented() {
                    return false;
                }

                @Override
                public void setInt(int minutes) {
                    shell.baseTestMethodTimeoutMillis = minutes * 60 * 1000;
                }
            });
            this.registerHandler(new ArgHandlerInt(){

                @Override
                public String[] getDefaultArgs() {
                    return new String[]{this.getTag(), String.valueOf(1)};
                }

                @Override
                public String getPurpose() {
                    return "Set the test begin timeout (time for clients to contact server), in minutes";
                }

                @Override
                public String getTag() {
                    return "-testBeginTimeout";
                }

                @Override
                public String[] getTagArgs() {
                    return new String[]{"minutes"};
                }

                @Override
                public boolean isUndocumented() {
                    return false;
                }

                @Override
                public void setInt(int minutes) {
                    shell.baseTestBeginTimeoutMillis = minutes * 60 * 1000;
                }
            });
            this.registerHandler(new ArgHandlerString(){

                @Override
                public String getPurpose() {
                    return "Selects the runstyle to use for this test.  The name is a suffix of com.google.gwt.junit.RunStyle or is a fully qualified class name, and may be followed with a colon and an argument for this runstyle.  The specified class mustextend RunStyle.";
                }

                @Override
                public String getTag() {
                    return "-runStyle";
                }

                @Override
                public String[] getTagArgs() {
                    return new String[]{"runstyle[:args]"};
                }

                @Override
                public boolean isUndocumented() {
                    return false;
                }

                @Override
                public boolean setString(String runStyleArg) {
                    shell.runStyleName = runStyleArg;
                    return true;
                }
            });
            this.registerHandler(new ArgHandlerString(){

                @Override
                public String getPurpose() {
                    return "Configure batch execution of tests";
                }

                @Override
                public String getTag() {
                    return "-batch";
                }

                @Override
                public String[] getTagArgs() {
                    return new String[]{"none|class|module"};
                }

                @Override
                public boolean isUndocumented() {
                    return true;
                }

                @Override
                public boolean setString(String str) {
                    if (str.equals("none")) {
                        shell.batchingStrategy = new NoBatchingStrategy();
                    } else if (str.equals("class")) {
                        shell.batchingStrategy = new ClassBatchingStrategy();
                    } else if (str.equals("module")) {
                        shell.batchingStrategy = new ModuleBatchingStrategy();
                    } else {
                        return false;
                    }
                    return true;
                }
            });
            this.registerHandler(new ArgHandlerShowWindows(shell));
            this.registerHandler(new ArgHandlerString(){

                @Override
                public String getPurpose() {
                    return "Precompile modules as tests are running (speeds up remote tests but requires more memory)";
                }

                @Override
                public String getTag() {
                    return "-precompile";
                }

                @Override
                public String[] getTagArgs() {
                    return new String[]{"simple|all|parallel"};
                }

                @Override
                public boolean isUndocumented() {
                    return true;
                }

                @Override
                public boolean setString(String str) {
                    if (str.equals("simple")) {
                        shell.compileStrategy = new SimpleCompileStrategy(shell);
                    } else if (str.equals("all")) {
                        shell.compileStrategy = new PreCompileStrategy(shell);
                    } else if (str.equals("parallel")) {
                        shell.compileStrategy = new ParallelCompileStrategy(shell);
                    } else {
                        return false;
                    }
                    return true;
                }
            });
            this.registerHandler(new ArgHandlerInt(){

                @Override
                public String getPurpose() {
                    return "EXPERIMENTAL: Sets the maximum number of attempts for running each test method";
                }

                @Override
                public String getTag() {
                    return "-Xtries";
                }

                @Override
                public String[] getTagArgs() {
                    return new String[]{"1"};
                }

                @Override
                public boolean isRequired() {
                    return false;
                }

                @Override
                public boolean isUndocumented() {
                    return false;
                }

                @Override
                public void setInt(int value) {
                    shell.tries = value;
                }

                @Override
                public boolean isExperimental() {
                    return true;
                }
            });
            this.registerHandler(new ArgHandlerString(){

                @Override
                public String getPurpose() {
                    return "Specify the user agents to reduce the number of permutations for remote browser tests; e.g. safari,gecko1_8";
                }

                @Override
                public String getTag() {
                    return "-userAgents";
                }

                @Override
                public String[] getTagArgs() {
                    return new String[]{"userAgents"};
                }

                @Override
                public boolean setString(String str) {
                    Splitter splitter = Splitter.on(",").omitEmptyStrings().trimResults();
                    shell.userAgentsOpt = ImmutableSet.copyOf(splitter.split(str));
                    return true;
                }
            });
        }

        @Override
        protected String getName() {
            return JUnitShell.class.getName();
        }
    }

    private static class ArgHandlerShowWindows
    extends ArgHandlerFlag {
        private JUnitShell shell;

        public ArgHandlerShowWindows(JUnitShell shell) {
            this.shell = shell;
            this.addTagValue("-notHeadless", true);
        }

        @Override
        public String getPurposeSnippet() {
            return "Causes the log window and browser windows to be displayed; useful for debugging.";
        }

        @Override
        public String getLabel() {
            return "showUi";
        }

        @Override
        public boolean setFlag(boolean enabled) {
            this.shell.setHeadless(!enabled);
            return true;
        }

        @Override
        public boolean getDefaultValue() {
            return !this.shell.isHeadless();
        }
    }

    private static class ArgHandlerRunCompiledJavascript
    extends ArgHandlerFlag {
        private JUnitShell shell;

        public ArgHandlerRunCompiledJavascript(JUnitShell shell) {
            this.shell = shell;
            this.addTagValue("-web", false);
            this.addTagValue("-prod", false);
        }

        @Override
        public String getPurposeSnippet() {
            return "Runs tests in Development Mode, using the Java virtual machine.";
        }

        @Override
        public String getLabel() {
            return "devMode";
        }

        @Override
        public boolean setFlag(boolean enabled) {
            this.shell.developmentMode = enabled;
            return true;
        }

        @Override
        public boolean getDefaultValue() {
            return this.shell.developmentMode;
        }
    }

    public static interface Strategy {
        public String getSyntheticModuleExtension();

        public void processModule(ModuleDef var1);
    }
}

