/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.junit.JUnitFatalLaunchException;
import com.google.gwt.junit.client.TimeoutException;
import com.google.gwt.junit.client.impl.JUnitHost;
import com.google.gwt.junit.client.impl.JUnitResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class JUnitMessageQueue {
    private final Map<Integer, ClientStatus> clientStatuses = new HashMap<Integer, ClientStatus>();
    private final Object clientStatusesLock = new Object();
    private boolean isLastTestBlockAvailable;
    private int numClients = 1;
    private final List<JUnitHost.TestInfo[]> testBlocks = new ArrayList<JUnitHost.TestInfo[]>();
    private final Map<JUnitHost.TestInfo, Map<ClientStatus, JUnitResult>> testResults = new HashMap<JUnitHost.TestInfo, Map<ClientStatus, JUnitResult>>();

    JUnitMessageQueue(int numClients) {
        this.numClients = numClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JUnitHost.TestBlock getTestBlock(ClientInfoExt clientInfo, int blockIndex, long timeout) throws TimeoutException {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            JUnitHost.TestInfo[] tests;
            ClientStatus clientStatus = this.ensureClientStatus(clientInfo);
            clientStatus.blockIndex = blockIndex;
            if (this.isLastTestBlockAvailable && blockIndex >= this.testBlocks.size()) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            long stopTime = startTime + timeout;
            while (blockIndex >= this.testBlocks.size()) {
                long timeToWait = stopTime - System.currentTimeMillis();
                if (timeToWait < 1L) {
                    double elapsed = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                    throw new TimeoutException("The servlet did not respond to the next query to test within " + timeout + "ms.\n Client description: " + clientInfo.getDesc() + "\n Actual time elapsed: " + elapsed + " seconds.\n");
                }
                try {
                    this.clientStatusesLock.wait(timeToWait);
                }
                catch (InterruptedException e) {
                    System.err.println("Unexpected thread interruption");
                    e.printStackTrace();
                    return null;
                }
            }
            for (JUnitHost.TestInfo testInfo : tests = this.testBlocks.get(blockIndex)) {
                this.ensureResults(testInfo).put(clientStatus, null);
            }
            return new JUnitHost.TestBlock(tests, blockIndex);
        }
    }

    public void reportFatalLaunch(ClientInfoExt clientInfo, JUnitResult result) {
        ClientStatus clientStatus = this.ensureClientStatus(clientInfo);
        HashMap<JUnitHost.TestInfo, JUnitResult> results = new HashMap<JUnitHost.TestInfo, JUnitResult>();
        for (JUnitHost.TestInfo testInfo : this.testBlocks.get(clientStatus.blockIndex)) {
            results.put(testInfo, result);
        }
        this.reportResults(clientInfo, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResults(ClientInfoExt clientInfo, Map<JUnitHost.TestInfo, JUnitResult> results) {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            if (results == null) {
                throw new IllegalArgumentException("results cannot be null");
            }
            ClientStatus clientStatus = this.ensureClientStatus(clientInfo);
            for (Map.Entry<JUnitHost.TestInfo, JUnitResult> entry : results.entrySet()) {
                JUnitHost.TestInfo testInfo = entry.getKey();
                this.ensureResults(testInfo).put(clientStatus, entry.getValue());
            }
            this.clientStatusesLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTestBlocks(List<JUnitHost.TestInfo[]> newTestBlocks, boolean isLastBlock) {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            if (this.isLastTestBlockAvailable) {
                throw new IllegalArgumentException("Cannot add test blocks after the last block is added");
            }
            for (JUnitHost.TestInfo[] testBlock : newTestBlocks) {
                if (testBlock.length != 0) continue;
                throw new IllegalArgumentException("TestBlocks cannot be empty");
            }
            this.testBlocks.addAll(newTestBlocks);
            if (isLastBlock) {
                this.isLastTestBlockAvailable = true;
            }
            this.clientStatusesLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getNewClients() {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            ArrayList<String> results = new ArrayList<String>();
            for (ClientStatus clientStatus : this.clientStatuses.values()) {
                if (!clientStatus.isNew) continue;
                results.add(clientStatus.getDesc());
                clientStatus.isNew = false;
            }
            this.clientStatusesLock.notifyAll();
            return results.toArray(new String[results.size()]);
        }
    }

    int getNumClients() {
        return this.numClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumClientsRetrievedTest(JUnitHost.TestInfo testInfo) {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            int count = 0;
            Map<ClientStatus, JUnitResult> results = this.testResults.get(testInfo);
            if (results != null) {
                count = results.size();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumConnectedClients() {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            return this.clientStatuses.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<ClientStatus, JUnitResult> getResults(JUnitHost.TestInfo testInfo) {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            return this.testResults.get(testInfo);
        }
    }

    List<JUnitHost.TestInfo[]> getTestBlocks() {
        return this.testBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getUnretrievedClients(JUnitHost.TestInfo testInfo) {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            Map<ClientStatus, JUnitResult> results = this.testResults.get(testInfo);
            StringBuilder buf = new StringBuilder();
            int lineCount = 0;
            for (ClientStatus clientStatus : this.clientStatuses.values()) {
                if (lineCount > 0) {
                    buf.append('\n');
                }
                if (results == null || !results.containsKey(clientStatus)) {
                    buf.append(" - NO RESPONSE: ");
                } else {
                    buf.append(" - (ok): ");
                }
                buf.append(clientStatus.getDesc());
                ++lineCount;
            }
            int difference = this.numClients - this.getNumClientsRetrievedTest(testInfo);
            if (difference > 0) {
                if (lineCount > 0) {
                    buf.append('\n');
                }
                buf.append(" - " + difference + " client(s) haven't responded back to JUnitShell since the start of the test.");
            }
            return buf.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getWorkingClients(JUnitHost.TestInfo testInfo) {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            int difference;
            int itemCount = 0;
            StringBuilder buf = new StringBuilder();
            Map<ClientStatus, JUnitResult> results = this.testResults.get(testInfo);
            if (results != null) {
                for (Map.Entry<ClientStatus, JUnitResult> entry : results.entrySet()) {
                    if (entry.getValue() != null) continue;
                    buf.append(entry.getKey().getDesc());
                    buf.append("\n");
                    ++itemCount;
                }
            }
            if ((difference = this.numClients - itemCount) > 0) {
                if (itemCount > 0) {
                    buf.append('\n');
                }
                buf.append(difference + " other client(s) haven't responded back to JUnitShell since the start of the test.");
            }
            return buf.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasResults(JUnitHost.TestInfo testInfo) {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            Map<ClientStatus, JUnitResult> results = this.testResults.get(testInfo);
            if (results == null || results.size() < this.numClients) {
                return false;
            }
            for (JUnitResult result : results.values()) {
                if (result != null) continue;
                return false;
            }
            return true;
        }
    }

    boolean needsRerunning(JUnitHost.TestInfo testInfo) {
        Map<ClientStatus, JUnitResult> results = this.getResults(testInfo);
        if (results == null) {
            return true;
        }
        if (results.size() != this.numClients) {
            return true;
        }
        for (Map.Entry<ClientStatus, JUnitResult> entry : results.entrySet()) {
            JUnitResult result = entry.getValue();
            if (result == null) {
                return true;
            }
            if (!this.isNonFatalFailure(result)) continue;
            return true;
        }
        return false;
    }

    private boolean isNonFatalFailure(JUnitResult result) {
        return result.isAnyException() && !result.isExceptionOf(Error.class) && !result.isExceptionOf(JUnitFatalLaunchException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResults(JUnitHost.TestInfo testInfo) {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            this.testResults.remove(testInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForResults(int millis) {
        Object object = this.clientStatusesLock;
        synchronized (object) {
            try {
                this.clientStatusesLock.wait(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private ClientStatus ensureClientStatus(ClientInfoExt clientInfo) {
        int id = clientInfo.getSessionId();
        ClientStatus clientStatus = this.clientStatuses.get(id);
        if (clientStatus == null) {
            clientStatus = new ClientStatus(clientInfo);
            this.clientStatuses.put(id, clientStatus);
        } else {
            clientStatus.updateClientInfo(clientInfo);
        }
        return clientStatus;
    }

    private Map<ClientStatus, JUnitResult> ensureResults(JUnitHost.TestInfo testInfo) {
        Map<ClientStatus, JUnitResult> results = this.testResults.get(testInfo);
        if (results == null) {
            results = new IdentityHashMap<ClientStatus, JUnitResult>();
            this.testResults.put(testInfo, results);
        }
        return results;
    }

    public static class ClientStatus {
        private int blockIndex = 0;
        private ClientInfoExt clientInfo;
        private boolean isNew = true;

        public ClientStatus(ClientInfoExt clientInfo) {
            this.clientInfo = clientInfo;
        }

        public String getDesc() {
            return this.clientInfo.getDesc();
        }

        public int getId() {
            return this.clientInfo.getSessionId();
        }

        public String toString() {
            return this.clientInfo.getDesc();
        }

        public void updateClientInfo(ClientInfoExt clientInfo) {
            this.clientInfo = clientInfo;
        }
    }

    public static class ClientInfoExt
    extends JUnitHost.ClientInfo {
        private final String desc;

        public ClientInfoExt(int sessionId, String desc) {
            super(sessionId);
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

