/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.DOMImpl;
import com.google.gwt.safehtml.shared.annotations.IsSafeUri;

public class Style
extends JavaScriptObject {
    private static final String BORDER_STYLE_SOLID = "solid";
    private static final String BORDER_STYLE_DASHED = "dashed";
    private static final String BORDER_STYLE_DOTTED = "dotted";
    private static final String BORDER_STYLE_HIDDEN = "hidden";
    private static final String BORDER_STYLE_NONE = "none";
    private static final String CLEAR_BOTH = "both";
    private static final String CLEAR_LEFT = "left";
    private static final String CLEAR_NONE = "none";
    private static final String CLEAR_RIGHT = "right";
    private static final String CURSOR_ROW_RESIZE = "row-resize";
    private static final String CURSOR_COL_RESIZE = "col-resize";
    private static final String CURSOR_HELP = "help";
    private static final String CURSOR_WAIT = "wait";
    private static final String CURSOR_TEXT = "text";
    private static final String CURSOR_W_RESIZE = "w-resize";
    private static final String CURSOR_S_RESIZE = "s-resize";
    private static final String CURSOR_SW_RESIZE = "sw-resize";
    private static final String CURSOR_SE_RESIZE = "se-resize";
    private static final String CURSOR_N_RESIZE = "n-resize";
    private static final String CURSOR_NW_RESIZE = "nw-resize";
    private static final String CURSOR_NE_RESIZE = "ne-resize";
    private static final String CURSOR_E_RESIZE = "e-resize";
    private static final String CURSOR_MOVE = "move";
    private static final String CURSOR_POINTER = "pointer";
    private static final String CURSOR_CROSSHAIR = "crosshair";
    private static final String CURSOR_AUTO = "auto";
    private static final String CURSOR_DEFAULT = "default";
    private static final String DISPLAY_INLINE_BLOCK = "inline-block";
    private static final String DISPLAY_INLINE = "inline";
    private static final String DISPLAY_BLOCK = "block";
    private static final String DISPLAY_NONE = "none";
    private static final String DISPLAY_INLINE_TABLE = "inline-table";
    private static final String DISPLAY_LIST_ITEM = "list-item";
    private static final String DISPLAY_RUN_IN = "run-in";
    private static final String DISPLAY_TABLE = "table";
    private static final String DISPLAY_TABLE_CAPTION = "table-caption";
    private static final String DISPLAY_TABLE_COLUMN_GROUP = "table-column-group";
    private static final String DISPLAY_TABLE_HEADER_GROUP = "table-header-group";
    private static final String DISPLAY_TABLE_FOOTER_GROUP = "table-footer-group";
    private static final String DISPLAY_TABLE_ROW_GROUP = "table-row-group";
    private static final String DISPLAY_TABLE_CELL = "table-cell";
    private static final String DISPLAY_TABLE_COLUMN = "table-column";
    private static final String DISPLAY_TABLE_ROW = "table-row";
    private static final String DISPLAY_INITIAL = "initial";
    private static final String DISPLAY_FLEX = "flex";
    private static final String DISPLAY_INLINE_FLEX = "inline-flex";
    private static final String FLOAT_LEFT = "left";
    private static final String FLOAT_RIGHT = "right";
    private static final String FLOAT_NONE = "none";
    private static final String FONT_STYLE_OBLIQUE = "oblique";
    private static final String FONT_STYLE_ITALIC = "italic";
    private static final String FONT_STYLE_NORMAL = "normal";
    private static final String FONT_WEIGHT_LIGHTER = "lighter";
    private static final String FONT_WEIGHT_BOLDER = "bolder";
    private static final String FONT_WEIGHT_BOLD = "bold";
    private static final String FONT_WEIGHT_NORMAL = "normal";
    private static final String LIST_STYLE_TYPE_UPPER_ROMAN = "upper-roman";
    private static final String LIST_STYLE_TYPE_LOWER_ROMAN = "lower-roman";
    private static final String LIST_STYLE_TYPE_UPPER_ALPHA = "upper-alpha";
    private static final String LIST_STYLE_TYPE_LOWER_ALPHA = "lower-alpha";
    private static final String LIST_STYLE_TYPE_DECIMAL = "decimal";
    private static final String LIST_STYLE_TYPE_SQUARE = "square";
    private static final String LIST_STYLE_TYPE_CIRCLE = "circle";
    private static final String LIST_STYLE_TYPE_DISC = "disc";
    private static final String LIST_STYLE_TYPE_NONE = "none";
    private static final String OUTLINE_STYLE_DASHED = "dashed";
    private static final String OUTLINE_STYLE_DOTTED = "dotted";
    private static final String OUTLINE_STYLE_DOUBLE = "double";
    private static final String OUTLINE_STYLE_GROOVE = "groove";
    private static final String OUTLINE_STYLE_INSET = "inset";
    private static final String OUTLINE_STYLE_NONE = "none";
    private static final String OUTLINE_STYLE_OUTSET = "outset";
    private static final String OUTLINE_STYLE_RIDGE = "ridge";
    private static final String OUTLINE_STYLE_SOLID = "solid";
    private static final String OVERFLOW_AUTO = "auto";
    private static final String OVERFLOW_SCROLL = "scroll";
    private static final String OVERFLOW_HIDDEN = "hidden";
    private static final String OVERFLOW_VISIBLE = "visible";
    private static final String POSITION_FIXED = "fixed";
    private static final String POSITION_ABSOLUTE = "absolute";
    private static final String POSITION_RELATIVE = "relative";
    private static final String POSITION_STATIC = "static";
    private static final String STYLE_Z_INDEX = "zIndex";
    private static final String STYLE_WIDTH = "width";
    private static final String STYLE_VISIBILITY = "visibility";
    private static final String STYLE_TOP = "top";
    private static final String STYLE_TEXT_DECORATION = "textDecoration";
    private static final String STYLE_RIGHT = "right";
    private static final String STYLE_POSITION = "position";
    private static final String STYLE_PADDING_TOP = "paddingTop";
    private static final String STYLE_PADDING_RIGHT = "paddingRight";
    private static final String STYLE_PADDING_LEFT = "paddingLeft";
    private static final String STYLE_PADDING_BOTTOM = "paddingBottom";
    private static final String STYLE_PADDING = "padding";
    private static final String STYLE_OVERFLOW = "overflow";
    private static final String STYLE_OVERFLOW_X = "overflowX";
    private static final String STYLE_OVERFLOW_Y = "overflowY";
    private static final String STYLE_OPACITY = "opacity";
    private static final String STYLE_MARGIN_TOP = "marginTop";
    private static final String STYLE_MARGIN_RIGHT = "marginRight";
    private static final String STYLE_MARGIN_LEFT = "marginLeft";
    private static final String STYLE_MARGIN_BOTTOM = "marginBottom";
    private static final String STYLE_MARGIN = "margin";
    private static final String STYLE_LIST_STYLE_TYPE = "listStyleType";
    private static final String STYLE_LEFT = "left";
    private static final String STYLE_HEIGHT = "height";
    private static final String STYLE_FONT_WEIGHT = "fontWeight";
    private static final String STYLE_FONT_STYLE = "fontStyle";
    private static final String STYLE_FONT_SIZE = "fontSize";
    private static final String STYLE_DISPLAY = "display";
    private static final String STYLE_CURSOR = "cursor";
    private static final String STYLE_COLOR = "color";
    private static final String STYLE_CLEAR = "clear";
    private static final String STYLE_BOTTOM = "bottom";
    private static final String STYLE_BORDER_WIDTH = "borderWidth";
    private static final String STYLE_BORDER_STYLE = "borderStyle";
    private static final String STYLE_BORDER_COLOR = "borderColor";
    private static final String STYLE_BACKGROUND_IMAGE = "backgroundImage";
    private static final String STYLE_BACKGROUND_COLOR = "backgroundColor";
    private static final String STYLE_VERTICAL_ALIGN = "verticalAlign";
    private static final String STYLE_TABLE_LAYOUT = "tableLayout";
    private static final String STYLE_TEXT_ALIGN = "textAlign";
    private static final String STYLE_TEXT_INDENT = "textIndent";
    private static final String STYLE_TEXT_JUSTIFY = "textJustify";
    private static final String STYLE_TEXT_OVERFLOW = "textOverflow";
    private static final String STYLE_TEXT_TRANSFORM = "textTransform";
    private static final String STYLE_OUTLINE_WIDTH = "outlineWidth";
    private static final String STYLE_OUTLINE_STYLE = "outlineStyle";
    private static final String STYLE_OUTLINE_COLOR = "outlineColor";
    private static final String STYLE_LINE_HEIGHT = "lineHeight";
    private static final String STYLE_WHITE_SPACE = "whiteSpace";
    private static final String TABLE_LAYOUT_AUTO = "auto";
    private static final String TABLE_LAYOUT_FIXED = "fixed";
    private static final String TEXT_ALIGN_CENTER = "center";
    private static final String TEXT_ALIGN_JUSTIFY = "justify";
    private static final String TEXT_ALIGN_LEFT = "left";
    private static final String TEXT_ALIGN_RIGHT = "right";
    private static final String TEXT_DECORATION_BLINK = "blink";
    private static final String TEXT_DECORATION_LINE_THROUGH = "line-through";
    private static final String TEXT_DECORATION_NONE = "none";
    private static final String TEXT_DECORATION_OVERLINE = "overline";
    private static final String TEXT_DECORATION_UNDERLINE = "underline";
    private static final String TEXT_JUSTIFY_AUTO = "auto";
    private static final String TEXT_JUSTIFY_DISTRIBUTE = "distribute";
    private static final String TEXT_JUSTIFY_INTER_CLUSTER = "inter-cluster";
    private static final String TEXT_JUSTIFY_INTER_IDEOGRAPH = "inter-ideograph";
    private static final String TEXT_JUSTIFY_INTER_WORD = "inter-word";
    private static final String TEXT_JUSTIFY_KASHIDA = "kashida";
    private static final String TEXT_JUSTIFY_NONE = "none";
    private static final String TEXT_OVERFLOW_CLIP = "clip";
    private static final String TEXT_OVERFLOW_ELLIPSIS = "ellipsis";
    private static final String TEXT_TRANSFORM_CAPITALIZE = "capitalize";
    private static final String TEXT_TRANSFORM_NONE = "none";
    private static final String TEXT_TRANSFORM_LOWERCASE = "lowercase";
    private static final String TEXT_TRANSFORM_UPPERCASE = "uppercase";
    private static final String UNIT_MM = "mm";
    private static final String UNIT_CM = "cm";
    private static final String UNIT_IN = "in";
    private static final String UNIT_PC = "pc";
    private static final String UNIT_PT = "pt";
    private static final String UNIT_EX = "ex";
    private static final String UNIT_EM = "em";
    private static final String UNIT_PCT = "%";
    private static final String UNIT_PX = "px";
    private static final String VERTICAL_ALIGN_BASELINE = "baseline";
    private static final String VERTICAL_ALIGN_SUB = "sub";
    private static final String VERTICAL_ALIGN_SUPER = "super";
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_TEXT_TOP = "text-top";
    private static final String VERTICAL_ALIGN_MIDDLE = "middle";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    private static final String VERTICAL_ALIGN_TEXT_BOTTOM = "text-bottom";
    private static final String VISIBILITY_HIDDEN = "hidden";
    private static final String VISIBILITY_VISIBLE = "visible";
    private static final String WHITE_SPACE_NORMAL = "normal";
    private static final String WHITE_SPACE_NOWRAP = "nowrap";
    private static final String WHITE_SPACE_PRE = "pre";
    private static final String WHITE_SPACE_PRE_LINE = "pre-line";
    private static final String WHITE_SPACE_PRE_WRAP = "pre-wrap";

    protected Style() {
    }

    public final void clearBackgroundColor() {
        this.clearProperty(STYLE_BACKGROUND_COLOR);
    }

    public final void clearBackgroundImage() {
        this.clearProperty(STYLE_BACKGROUND_IMAGE);
    }

    public final void clearBorderColor() {
        this.clearProperty(STYLE_BORDER_COLOR);
    }

    public final void clearBorderStyle() {
        this.clearProperty(STYLE_BORDER_STYLE);
    }

    public final void clearBorderWidth() {
        this.clearProperty(STYLE_BORDER_WIDTH);
    }

    public final void clearBottom() {
        this.clearProperty("bottom");
    }

    public final void clearClear() {
        this.clearProperty(STYLE_CLEAR);
    }

    public final void clearColor() {
        this.clearProperty(STYLE_COLOR);
    }

    public final void clearCursor() {
        this.clearProperty(STYLE_CURSOR);
    }

    public final void clearDisplay() {
        this.clearProperty(STYLE_DISPLAY);
    }

    public final void clearFloat() {
        this.clearProperty(DOMImpl.impl.cssFloatPropertyName());
    }

    public final void clearFontSize() {
        this.clearProperty(STYLE_FONT_SIZE);
    }

    public final void clearFontStyle() {
        this.clearProperty(STYLE_FONT_STYLE);
    }

    public final void clearFontWeight() {
        this.clearProperty(STYLE_FONT_WEIGHT);
    }

    public final void clearHeight() {
        this.clearProperty(STYLE_HEIGHT);
    }

    public final void clearLeft() {
        this.clearProperty("left");
    }

    public final void clearLineHeight() {
        this.clearProperty(STYLE_LINE_HEIGHT);
    }

    public final void clearListStyleType() {
        this.clearProperty(STYLE_LIST_STYLE_TYPE);
    }

    public final void clearMargin() {
        this.clearProperty(STYLE_MARGIN);
    }

    public final void clearMarginBottom() {
        this.clearProperty(STYLE_MARGIN_BOTTOM);
    }

    public final void clearMarginLeft() {
        this.clearProperty(STYLE_MARGIN_LEFT);
    }

    public final void clearMarginRight() {
        this.clearProperty(STYLE_MARGIN_RIGHT);
    }

    public final void clearMarginTop() {
        this.clearProperty(STYLE_MARGIN_TOP);
    }

    public final void clearOpacity() {
        DOMImpl.impl.cssClearOpacity(this);
    }

    public final void clearOutlineColor() {
        this.clearProperty(STYLE_OUTLINE_COLOR);
    }

    public final void clearOutlineStyle() {
        this.clearProperty(STYLE_OUTLINE_STYLE);
    }

    public final void clearOutlineWidth() {
        this.clearProperty(STYLE_OUTLINE_WIDTH);
    }

    public final void clearOverflow() {
        this.clearProperty(STYLE_OVERFLOW);
    }

    public final void clearOverflowX() {
        this.clearProperty(STYLE_OVERFLOW_X);
    }

    public final void clearOverflowY() {
        this.clearProperty(STYLE_OVERFLOW_Y);
    }

    public final void clearPadding() {
        this.clearProperty(STYLE_PADDING);
    }

    public final void clearPaddingBottom() {
        this.clearProperty(STYLE_PADDING_BOTTOM);
    }

    public final void clearPaddingLeft() {
        this.clearProperty(STYLE_PADDING_LEFT);
    }

    public final void clearPaddingRight() {
        this.clearProperty(STYLE_PADDING_RIGHT);
    }

    public final void clearPaddingTop() {
        this.clearProperty(STYLE_PADDING_TOP);
    }

    public final void clearPosition() {
        this.clearProperty(STYLE_POSITION);
    }

    public final void clearProperty(String name) {
        this.setProperty(name, "");
    }

    public final void clearRight() {
        this.clearProperty("right");
    }

    public final void clearTableLayout() {
        this.clearProperty(STYLE_TABLE_LAYOUT);
    }

    public final void clearTextAlign() {
        this.clearProperty(STYLE_TEXT_ALIGN);
    }

    public final void clearTextDecoration() {
        this.clearProperty(STYLE_TEXT_DECORATION);
    }

    public final void clearTextIndent() {
        this.clearProperty(STYLE_TEXT_INDENT);
    }

    public final void clearTextJustify() {
        this.clearProperty(STYLE_TEXT_JUSTIFY);
    }

    public final void clearTextOverflow() {
        this.clearProperty(STYLE_TEXT_OVERFLOW);
    }

    public final void clearTextTransform() {
        this.clearProperty(STYLE_TEXT_TRANSFORM);
    }

    public final void clearTop() {
        this.clearProperty("top");
    }

    public final void clearVisibility() {
        this.clearProperty(STYLE_VISIBILITY);
    }

    public final void clearWhiteSpace() {
        this.clearProperty(STYLE_WHITE_SPACE);
    }

    public final void clearWidth() {
        this.clearProperty(STYLE_WIDTH);
    }

    public final void clearZIndex() {
        this.clearProperty(STYLE_Z_INDEX);
    }

    public final String getBackgroundColor() {
        return this.getProperty(STYLE_BACKGROUND_COLOR);
    }

    public final String getBackgroundImage() {
        return this.getProperty(STYLE_BACKGROUND_IMAGE);
    }

    public final String getBorderColor() {
        return this.getProperty(STYLE_BORDER_COLOR);
    }

    public final String getBorderStyle() {
        return this.getProperty(STYLE_BORDER_STYLE);
    }

    public final String getBorderWidth() {
        return this.getProperty(STYLE_BORDER_WIDTH);
    }

    public final String getBottom() {
        return this.getProperty("bottom");
    }

    public final String getClear() {
        return this.getProperty(STYLE_CLEAR);
    }

    public final String getColor() {
        return this.getProperty(STYLE_COLOR);
    }

    public final String getCursor() {
        return this.getProperty(STYLE_CURSOR);
    }

    public final String getDisplay() {
        return this.getProperty(STYLE_DISPLAY);
    }

    public final String getFontSize() {
        return this.getProperty(STYLE_FONT_SIZE);
    }

    public final String getFontStyle() {
        return this.getProperty(STYLE_FONT_STYLE);
    }

    public final String getFontWeight() {
        return this.getProperty(STYLE_FONT_WEIGHT);
    }

    public final String getHeight() {
        return this.getProperty(STYLE_HEIGHT);
    }

    public final String getLeft() {
        return this.getProperty("left");
    }

    public final String getLineHeight() {
        return this.getProperty(STYLE_LINE_HEIGHT);
    }

    public final String getListStyleType() {
        return this.getProperty(STYLE_LIST_STYLE_TYPE);
    }

    public final String getMargin() {
        return this.getProperty(STYLE_MARGIN);
    }

    public final String getMarginBottom() {
        return this.getProperty(STYLE_MARGIN_BOTTOM);
    }

    public final String getMarginLeft() {
        return this.getProperty(STYLE_MARGIN_LEFT);
    }

    public final String getMarginRight() {
        return this.getProperty(STYLE_MARGIN_RIGHT);
    }

    public final String getMarginTop() {
        return this.getProperty(STYLE_MARGIN_TOP);
    }

    public final String getOpacity() {
        return this.getProperty(STYLE_OPACITY);
    }

    public final String getOverflow() {
        return this.getProperty(STYLE_OVERFLOW);
    }

    public final String getOverflowX() {
        return this.getProperty(STYLE_OVERFLOW_X);
    }

    public final String getOverflowY() {
        return this.getProperty(STYLE_OVERFLOW_Y);
    }

    public final String getPadding() {
        return this.getProperty(STYLE_PADDING);
    }

    public final String getPaddingBottom() {
        return this.getProperty(STYLE_PADDING_BOTTOM);
    }

    public final String getPaddingLeft() {
        return this.getProperty(STYLE_PADDING_LEFT);
    }

    public final String getPaddingRight() {
        return this.getProperty(STYLE_PADDING_RIGHT);
    }

    public final String getPaddingTop() {
        return this.getProperty(STYLE_PADDING_TOP);
    }

    public final String getPosition() {
        return this.getProperty(STYLE_POSITION);
    }

    public final String getProperty(String name) {
        this.assertCamelCase(name);
        return this.getPropertyImpl(name);
    }

    public final String getRight() {
        return this.getProperty("right");
    }

    public final String getTableLayout() {
        return this.getProperty(STYLE_TABLE_LAYOUT);
    }

    public final String getTextAlign() {
        return this.getProperty(STYLE_TEXT_ALIGN);
    }

    public final String getTextDecoration() {
        return this.getProperty(STYLE_TEXT_DECORATION);
    }

    public final String getTextIndent() {
        return this.getProperty(STYLE_TEXT_INDENT);
    }

    public final String getTextJustify() {
        return this.getProperty(STYLE_TEXT_JUSTIFY);
    }

    public final String getTextOverflow() {
        return this.getProperty(STYLE_TEXT_OVERFLOW);
    }

    public final String getTextTransform() {
        return this.getProperty(STYLE_TEXT_TRANSFORM);
    }

    public final String getTop() {
        return this.getProperty("top");
    }

    public final String getVerticalAlign() {
        return this.getProperty(STYLE_VERTICAL_ALIGN);
    }

    public final String getVisibility() {
        return this.getProperty(STYLE_VISIBILITY);
    }

    public final String getWhiteSpace() {
        return this.getProperty(STYLE_WHITE_SPACE);
    }

    public final String getWidth() {
        return this.getProperty(STYLE_WIDTH);
    }

    public final String getZIndex() {
        return DOMImpl.impl.getNumericStyleProperty(this, STYLE_Z_INDEX);
    }

    public final void setBackgroundColor(String value) {
        this.setProperty(STYLE_BACKGROUND_COLOR, value);
    }

    public final void setBackgroundImage(@IsSafeUri String value) {
        this.setProperty(STYLE_BACKGROUND_IMAGE, value);
    }

    public final void setBorderColor(String value) {
        this.setProperty(STYLE_BORDER_COLOR, value);
    }

    public final void setBorderStyle(BorderStyle value) {
        this.setProperty(STYLE_BORDER_STYLE, value.getCssName());
    }

    public final void setBorderWidth(double value, Unit unit) {
        this.setProperty(STYLE_BORDER_WIDTH, value, unit);
    }

    public final void setBottom(double value, Unit unit) {
        this.setProperty("bottom", value, unit);
    }

    public final void setClear(Clear value) {
        this.setProperty(STYLE_CLEAR, value.getCssName());
    }

    public final void setColor(String value) {
        this.setProperty(STYLE_COLOR, value);
    }

    public final void setCursor(Cursor value) {
        this.setProperty(STYLE_CURSOR, value.getCssName());
    }

    public final void setDisplay(Display value) {
        this.setProperty(STYLE_DISPLAY, value.getCssName());
    }

    public final void setFloat(Float value) {
        this.setProperty(DOMImpl.impl.cssFloatPropertyName(), value.getCssName());
    }

    public final void setFontSize(double value, Unit unit) {
        this.setProperty(STYLE_FONT_SIZE, value, unit);
    }

    public final void setFontStyle(FontStyle value) {
        this.setProperty(STYLE_FONT_STYLE, value.getCssName());
    }

    public final void setFontWeight(FontWeight value) {
        this.setProperty(STYLE_FONT_WEIGHT, value.getCssName());
    }

    public final void setHeight(double value, Unit unit) {
        this.setProperty(STYLE_HEIGHT, value, unit);
    }

    public final void setLeft(double value, Unit unit) {
        this.setProperty("left", value, unit);
    }

    public final void setLineHeight(double value, Unit unit) {
        this.setProperty(STYLE_LINE_HEIGHT, value, unit);
    }

    public final void setListStyleType(ListStyleType value) {
        this.setProperty(STYLE_LIST_STYLE_TYPE, value.getCssName());
    }

    public final void setMargin(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN, value, unit);
    }

    public final void setMarginBottom(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN_BOTTOM, value, unit);
    }

    public final void setMarginLeft(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN_LEFT, value, unit);
    }

    public final void setMarginRight(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN_RIGHT, value, unit);
    }

    public final void setMarginTop(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN_TOP, value, unit);
    }

    public final void setOpacity(double value) {
        DOMImpl.impl.cssSetOpacity(this, value);
    }

    public final void setOutlineColor(String value) {
        this.setProperty(STYLE_OUTLINE_COLOR, value);
    }

    public final void setOutlineStyle(OutlineStyle value) {
        this.setProperty(STYLE_OUTLINE_STYLE, value.getCssName());
    }

    public final void setOutlineWidth(double value, Unit unit) {
        this.setProperty(STYLE_OUTLINE_WIDTH, value, unit);
    }

    public final void setOverflow(Overflow value) {
        this.setProperty(STYLE_OVERFLOW, value.getCssName());
    }

    public final void setOverflowX(Overflow value) {
        this.setProperty(STYLE_OVERFLOW_X, value.getCssName());
    }

    public final void setOverflowY(Overflow value) {
        this.setProperty(STYLE_OVERFLOW_Y, value.getCssName());
    }

    public final void setPadding(double value, Unit unit) {
        this.setProperty(STYLE_PADDING, value, unit);
    }

    public final void setPaddingBottom(double value, Unit unit) {
        this.setProperty(STYLE_PADDING_BOTTOM, value, unit);
    }

    public final void setPaddingLeft(double value, Unit unit) {
        this.setProperty(STYLE_PADDING_LEFT, value, unit);
    }

    public final void setPaddingRight(double value, Unit unit) {
        this.setProperty(STYLE_PADDING_RIGHT, value, unit);
    }

    public final void setPaddingTop(double value, Unit unit) {
        this.setProperty(STYLE_PADDING_TOP, value, unit);
    }

    public final void setPosition(Position value) {
        this.setProperty(STYLE_POSITION, value.getCssName());
    }

    public final void setProperty(String name, String value) {
        this.assertCamelCase(name);
        this.setPropertyImpl(name, value);
    }

    public final void setProperty(String name, double value, Unit unit) {
        this.assertCamelCase(name);
        this.setPropertyImpl(name, value + unit.getType());
    }

    public final void setPropertyPx(String name, int value) {
        this.setProperty(name, value, Unit.PX);
    }

    public final void setRight(double value, Unit unit) {
        this.setProperty("right", value, unit);
    }

    public final void setTableLayout(TableLayout value) {
        this.setProperty(STYLE_TABLE_LAYOUT, value.getCssName());
    }

    public final void setTextAlign(TextAlign value) {
        this.setProperty(STYLE_TEXT_ALIGN, value.getCssName());
    }

    public final void setTextDecoration(TextDecoration value) {
        this.setProperty(STYLE_TEXT_DECORATION, value.getCssName());
    }

    public final void setTextIndent(double value, Unit unit) {
        this.setProperty(STYLE_TEXT_INDENT, value, unit);
    }

    public final void setTextJustify(TextJustify value) {
        this.setProperty(STYLE_TEXT_JUSTIFY, value.getCssName());
    }

    public final void setTextOverflow(TextOverflow value) {
        this.setProperty(STYLE_TEXT_OVERFLOW, value.getCssName());
    }

    public final void setTextTransform(TextTransform value) {
        this.setProperty(STYLE_TEXT_TRANSFORM, value.getCssName());
    }

    public final void setTop(double value, Unit unit) {
        this.setProperty("top", value, unit);
    }

    public final void setVerticalAlign(VerticalAlign value) {
        this.setProperty(STYLE_VERTICAL_ALIGN, value.getCssName());
    }

    public final void setVerticalAlign(double value, Unit unit) {
        this.setProperty(STYLE_VERTICAL_ALIGN, value, unit);
    }

    public final void setVisibility(Visibility value) {
        this.setProperty(STYLE_VISIBILITY, value.getCssName());
    }

    public final void setWhiteSpace(WhiteSpace value) {
        this.setProperty(STYLE_WHITE_SPACE, value.getCssName());
    }

    public final void setWidth(double value, Unit unit) {
        this.setProperty(STYLE_WIDTH, value, unit);
    }

    public final void setZIndex(int value) {
        this.setProperty(STYLE_Z_INDEX, value + "");
    }

    private void assertCamelCase(String name) {
        assert (!name.contains("-")) : "The style name '" + name + "' should be in camelCase format";
    }

    private String getPropertyImpl(String name) {
        return DOMImpl.impl.getStyleProperty(this, name);
    }

    private void setPropertyImpl(String string, String string2) {
        throw new RuntimeException("Cannot call native method");
    }

    public static enum WhiteSpace implements HasCssName
    {
        NORMAL{

            @Override
            public String getCssName() {
                return "normal";
            }
        }
        ,
        NOWRAP{

            @Override
            public String getCssName() {
                return Style.WHITE_SPACE_NOWRAP;
            }
        }
        ,
        PRE{

            @Override
            public String getCssName() {
                return Style.WHITE_SPACE_PRE;
            }
        }
        ,
        PRE_LINE{

            @Override
            public String getCssName() {
                return Style.WHITE_SPACE_PRE_LINE;
            }
        }
        ,
        PRE_WRAP{

            @Override
            public String getCssName() {
                return Style.WHITE_SPACE_PRE_WRAP;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum Visibility implements HasCssName
    {
        VISIBLE{

            @Override
            public String getCssName() {
                return "visible";
            }
        }
        ,
        HIDDEN{

            @Override
            public String getCssName() {
                return "hidden";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum VerticalAlign implements HasCssName
    {
        BASELINE{

            @Override
            public String getCssName() {
                return Style.VERTICAL_ALIGN_BASELINE;
            }
        }
        ,
        SUB{

            @Override
            public String getCssName() {
                return Style.VERTICAL_ALIGN_SUB;
            }
        }
        ,
        SUPER{

            @Override
            public String getCssName() {
                return Style.VERTICAL_ALIGN_SUPER;
            }
        }
        ,
        TOP{

            @Override
            public String getCssName() {
                return "top";
            }
        }
        ,
        TEXT_TOP{

            @Override
            public String getCssName() {
                return Style.VERTICAL_ALIGN_TEXT_TOP;
            }
        }
        ,
        MIDDLE{

            @Override
            public String getCssName() {
                return Style.VERTICAL_ALIGN_MIDDLE;
            }
        }
        ,
        BOTTOM{

            @Override
            public String getCssName() {
                return "bottom";
            }
        }
        ,
        TEXT_BOTTOM{

            @Override
            public String getCssName() {
                return Style.VERTICAL_ALIGN_TEXT_BOTTOM;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum TextTransform implements HasCssName
    {
        CAPITALIZE{

            @Override
            public String getCssName() {
                return Style.TEXT_TRANSFORM_CAPITALIZE;
            }
        }
        ,
        NONE{

            @Override
            public String getCssName() {
                return "none";
            }
        }
        ,
        LOWERCASE{

            @Override
            public String getCssName() {
                return Style.TEXT_TRANSFORM_LOWERCASE;
            }
        }
        ,
        UPPERCASE{

            @Override
            public String getCssName() {
                return Style.TEXT_TRANSFORM_UPPERCASE;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum TextOverflow implements HasCssName
    {
        CLIP{

            @Override
            public String getCssName() {
                return Style.TEXT_OVERFLOW_CLIP;
            }
        }
        ,
        ELLIPSIS{

            @Override
            public String getCssName() {
                return Style.TEXT_OVERFLOW_ELLIPSIS;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum TextJustify implements HasCssName
    {
        AUTO{

            @Override
            public String getCssName() {
                return "auto";
            }
        }
        ,
        DISTRIBUTE{

            @Override
            public String getCssName() {
                return Style.TEXT_JUSTIFY_DISTRIBUTE;
            }
        }
        ,
        INTER_CLUSTER{

            @Override
            public String getCssName() {
                return Style.TEXT_JUSTIFY_INTER_CLUSTER;
            }
        }
        ,
        INTER_IDEOGRAPH{

            @Override
            public String getCssName() {
                return Style.TEXT_JUSTIFY_INTER_IDEOGRAPH;
            }
        }
        ,
        INTER_WORD{

            @Override
            public String getCssName() {
                return Style.TEXT_JUSTIFY_INTER_WORD;
            }
        }
        ,
        KASHIDA{

            @Override
            public String getCssName() {
                return Style.TEXT_JUSTIFY_KASHIDA;
            }
        }
        ,
        NONE{

            @Override
            public String getCssName() {
                return "none";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum TextDecoration implements HasCssName
    {
        BLINK{

            @Override
            public String getCssName() {
                return Style.TEXT_DECORATION_BLINK;
            }
        }
        ,
        LINE_THROUGH{

            @Override
            public String getCssName() {
                return Style.TEXT_DECORATION_LINE_THROUGH;
            }
        }
        ,
        NONE{

            @Override
            public String getCssName() {
                return "none";
            }
        }
        ,
        OVERLINE{

            @Override
            public String getCssName() {
                return Style.TEXT_DECORATION_OVERLINE;
            }
        }
        ,
        UNDERLINE{

            @Override
            public String getCssName() {
                return Style.TEXT_DECORATION_UNDERLINE;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum TextAlign implements HasCssName
    {
        CENTER{

            @Override
            public String getCssName() {
                return Style.TEXT_ALIGN_CENTER;
            }
        }
        ,
        JUSTIFY{

            @Override
            public String getCssName() {
                return Style.TEXT_ALIGN_JUSTIFY;
            }
        }
        ,
        LEFT{

            @Override
            public String getCssName() {
                return "left";
            }
        }
        ,
        RIGHT{

            @Override
            public String getCssName() {
                return "right";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum TableLayout implements HasCssName
    {
        AUTO{

            @Override
            public String getCssName() {
                return "auto";
            }
        }
        ,
        FIXED{

            @Override
            public String getCssName() {
                return "fixed";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum Position implements HasCssName
    {
        STATIC{

            @Override
            public String getCssName() {
                return Style.POSITION_STATIC;
            }
        }
        ,
        RELATIVE{

            @Override
            public String getCssName() {
                return Style.POSITION_RELATIVE;
            }
        }
        ,
        ABSOLUTE{

            @Override
            public String getCssName() {
                return Style.POSITION_ABSOLUTE;
            }
        }
        ,
        FIXED{

            @Override
            public String getCssName() {
                return "fixed";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum Overflow implements HasCssName
    {
        VISIBLE{

            @Override
            public String getCssName() {
                return "visible";
            }
        }
        ,
        HIDDEN{

            @Override
            public String getCssName() {
                return "hidden";
            }
        }
        ,
        SCROLL{

            @Override
            public String getCssName() {
                return Style.OVERFLOW_SCROLL;
            }
        }
        ,
        AUTO{

            @Override
            public String getCssName() {
                return "auto";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum OutlineStyle implements HasCssName
    {
        NONE{

            @Override
            public String getCssName() {
                return "none";
            }
        }
        ,
        DASHED{

            @Override
            public String getCssName() {
                return "dashed";
            }
        }
        ,
        DOTTED{

            @Override
            public String getCssName() {
                return "dotted";
            }
        }
        ,
        DOUBLE{

            @Override
            public String getCssName() {
                return Style.OUTLINE_STYLE_DOUBLE;
            }
        }
        ,
        GROOVE{

            @Override
            public String getCssName() {
                return Style.OUTLINE_STYLE_GROOVE;
            }
        }
        ,
        INSET{

            @Override
            public String getCssName() {
                return Style.OUTLINE_STYLE_INSET;
            }
        }
        ,
        OUTSET{

            @Override
            public String getCssName() {
                return Style.OUTLINE_STYLE_OUTSET;
            }
        }
        ,
        RIDGE{

            @Override
            public String getCssName() {
                return Style.OUTLINE_STYLE_RIDGE;
            }
        }
        ,
        SOLID{

            @Override
            public String getCssName() {
                return "solid";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum ListStyleType implements HasCssName
    {
        NONE{

            @Override
            public String getCssName() {
                return "none";
            }
        }
        ,
        DISC{

            @Override
            public String getCssName() {
                return Style.LIST_STYLE_TYPE_DISC;
            }
        }
        ,
        CIRCLE{

            @Override
            public String getCssName() {
                return Style.LIST_STYLE_TYPE_CIRCLE;
            }
        }
        ,
        SQUARE{

            @Override
            public String getCssName() {
                return Style.LIST_STYLE_TYPE_SQUARE;
            }
        }
        ,
        DECIMAL{

            @Override
            public String getCssName() {
                return Style.LIST_STYLE_TYPE_DECIMAL;
            }
        }
        ,
        LOWER_ALPHA{

            @Override
            public String getCssName() {
                return Style.LIST_STYLE_TYPE_LOWER_ALPHA;
            }
        }
        ,
        UPPER_ALPHA{

            @Override
            public String getCssName() {
                return Style.LIST_STYLE_TYPE_UPPER_ALPHA;
            }
        }
        ,
        LOWER_ROMAN{

            @Override
            public String getCssName() {
                return Style.LIST_STYLE_TYPE_LOWER_ROMAN;
            }
        }
        ,
        UPPER_ROMAN{

            @Override
            public String getCssName() {
                return Style.LIST_STYLE_TYPE_UPPER_ROMAN;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum FontWeight implements HasCssName
    {
        NORMAL{

            @Override
            public String getCssName() {
                return "normal";
            }
        }
        ,
        BOLD{

            @Override
            public String getCssName() {
                return Style.FONT_WEIGHT_BOLD;
            }
        }
        ,
        BOLDER{

            @Override
            public String getCssName() {
                return Style.FONT_WEIGHT_BOLDER;
            }
        }
        ,
        LIGHTER{

            @Override
            public String getCssName() {
                return Style.FONT_WEIGHT_LIGHTER;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum FontStyle implements HasCssName
    {
        NORMAL{

            @Override
            public String getCssName() {
                return "normal";
            }
        }
        ,
        ITALIC{

            @Override
            public String getCssName() {
                return Style.FONT_STYLE_ITALIC;
            }
        }
        ,
        OBLIQUE{

            @Override
            public String getCssName() {
                return Style.FONT_STYLE_OBLIQUE;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum Float implements HasCssName
    {
        LEFT{

            @Override
            public String getCssName() {
                return "left";
            }
        }
        ,
        RIGHT{

            @Override
            public String getCssName() {
                return "right";
            }
        }
        ,
        NONE{

            @Override
            public String getCssName() {
                return "none";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum Display implements HasCssName
    {
        NONE{

            @Override
            public String getCssName() {
                return "none";
            }
        }
        ,
        BLOCK{

            @Override
            public String getCssName() {
                return Style.DISPLAY_BLOCK;
            }
        }
        ,
        INLINE{

            @Override
            public String getCssName() {
                return Style.DISPLAY_INLINE;
            }
        }
        ,
        INLINE_BLOCK{

            @Override
            public String getCssName() {
                return Style.DISPLAY_INLINE_BLOCK;
            }
        }
        ,
        INLINE_TABLE{

            @Override
            public String getCssName() {
                return Style.DISPLAY_INLINE_TABLE;
            }
        }
        ,
        LIST_ITEM{

            @Override
            public String getCssName() {
                return Style.DISPLAY_LIST_ITEM;
            }
        }
        ,
        RUN_IN{

            @Override
            public String getCssName() {
                return Style.DISPLAY_RUN_IN;
            }
        }
        ,
        TABLE{

            @Override
            public String getCssName() {
                return Style.DISPLAY_TABLE;
            }
        }
        ,
        TABLE_CAPTION{

            @Override
            public String getCssName() {
                return Style.DISPLAY_TABLE_CAPTION;
            }
        }
        ,
        TABLE_COLUMN_GROUP{

            @Override
            public String getCssName() {
                return Style.DISPLAY_TABLE_COLUMN_GROUP;
            }
        }
        ,
        TABLE_HEADER_GROUP{

            @Override
            public String getCssName() {
                return Style.DISPLAY_TABLE_HEADER_GROUP;
            }
        }
        ,
        TABLE_FOOTER_GROUP{

            @Override
            public String getCssName() {
                return Style.DISPLAY_TABLE_FOOTER_GROUP;
            }
        }
        ,
        TABLE_ROW_GROUP{

            @Override
            public String getCssName() {
                return Style.DISPLAY_TABLE_ROW_GROUP;
            }
        }
        ,
        TABLE_CELL{

            @Override
            public String getCssName() {
                return Style.DISPLAY_TABLE_CELL;
            }
        }
        ,
        TABLE_COLUMN{

            @Override
            public String getCssName() {
                return Style.DISPLAY_TABLE_COLUMN;
            }
        }
        ,
        TABLE_ROW{

            @Override
            public String getCssName() {
                return Style.DISPLAY_TABLE_ROW;
            }
        }
        ,
        INITIAL{

            @Override
            public String getCssName() {
                return Style.DISPLAY_INITIAL;
            }
        }
        ,
        FLEX{

            @Override
            public String getCssName() {
                return Style.DISPLAY_FLEX;
            }
        }
        ,
        INLINE_FLEX{

            @Override
            public String getCssName() {
                return Style.DISPLAY_INLINE_FLEX;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum Cursor implements HasCssName
    {
        DEFAULT{

            @Override
            public String getCssName() {
                return Style.CURSOR_DEFAULT;
            }
        }
        ,
        AUTO{

            @Override
            public String getCssName() {
                return "auto";
            }
        }
        ,
        CROSSHAIR{

            @Override
            public String getCssName() {
                return Style.CURSOR_CROSSHAIR;
            }
        }
        ,
        POINTER{

            @Override
            public String getCssName() {
                return Style.CURSOR_POINTER;
            }
        }
        ,
        MOVE{

            @Override
            public String getCssName() {
                return Style.CURSOR_MOVE;
            }
        }
        ,
        E_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_E_RESIZE;
            }
        }
        ,
        NE_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_NE_RESIZE;
            }
        }
        ,
        NW_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_NW_RESIZE;
            }
        }
        ,
        N_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_N_RESIZE;
            }
        }
        ,
        SE_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_SE_RESIZE;
            }
        }
        ,
        SW_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_SW_RESIZE;
            }
        }
        ,
        S_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_S_RESIZE;
            }
        }
        ,
        W_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_W_RESIZE;
            }
        }
        ,
        TEXT{

            @Override
            public String getCssName() {
                return Style.CURSOR_TEXT;
            }
        }
        ,
        WAIT{

            @Override
            public String getCssName() {
                return Style.CURSOR_WAIT;
            }
        }
        ,
        HELP{

            @Override
            public String getCssName() {
                return Style.CURSOR_HELP;
            }
        }
        ,
        COL_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_COL_RESIZE;
            }
        }
        ,
        ROW_RESIZE{

            @Override
            public String getCssName() {
                return Style.CURSOR_ROW_RESIZE;
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum Clear implements HasCssName
    {
        BOTH{

            @Override
            public String getCssName() {
                return Style.CLEAR_BOTH;
            }
        }
        ,
        LEFT{

            @Override
            public String getCssName() {
                return "left";
            }
        }
        ,
        NONE{

            @Override
            public String getCssName() {
                return "none";
            }
        }
        ,
        RIGHT{

            @Override
            public String getCssName() {
                return "right";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum BorderStyle implements HasCssName
    {
        NONE{

            @Override
            public String getCssName() {
                return "none";
            }
        }
        ,
        DOTTED{

            @Override
            public String getCssName() {
                return "dotted";
            }
        }
        ,
        DASHED{

            @Override
            public String getCssName() {
                return "dashed";
            }
        }
        ,
        HIDDEN{

            @Override
            public String getCssName() {
                return "hidden";
            }
        }
        ,
        SOLID{

            @Override
            public String getCssName() {
                return "solid";
            }
        };


        @Override
        public abstract String getCssName();
    }

    public static enum Unit {
        PX{

            @Override
            public String getType() {
                return Style.UNIT_PX;
            }
        }
        ,
        PCT{

            @Override
            public String getType() {
                return Style.UNIT_PCT;
            }
        }
        ,
        EM{

            @Override
            public String getType() {
                return Style.UNIT_EM;
            }
        }
        ,
        EX{

            @Override
            public String getType() {
                return Style.UNIT_EX;
            }
        }
        ,
        PT{

            @Override
            public String getType() {
                return Style.UNIT_PT;
            }
        }
        ,
        PC{

            @Override
            public String getType() {
                return Style.UNIT_PC;
            }
        }
        ,
        IN{

            @Override
            public String getType() {
                return Style.UNIT_IN;
            }
        }
        ,
        CM{

            @Override
            public String getType() {
                return Style.UNIT_CM;
            }
        }
        ,
        MM{

            @Override
            public String getType() {
                return Style.UNIT_MM;
            }
        };


        public abstract String getType();
    }

    public static interface HasCssName {
        public String getCssName();
    }
}

