/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.DOMImpl;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtml;

public class Element
extends Node {
    public static final String DRAGGABLE_AUTO = "auto";
    public static final String DRAGGABLE_FALSE = "false";
    public static final String DRAGGABLE_TRUE = "true";

    private static int toInt32(double d) {
        throw new RuntimeException("Cannot call native method");
    }

    public static Element as(JavaScriptObject o) {
        assert (Element.is(o));
        return (Element)o;
    }

    public static Element as(Node node) {
        assert (Element.is(node));
        return (Element)node;
    }

    public static boolean is(JavaScriptObject o) {
        if (Node.is(o)) {
            return Element.is((Node)o);
        }
        return false;
    }

    public static boolean is(Node node) {
        return node != null && node.getNodeType() == 1;
    }

    protected Element() {
    }

    public final boolean addClassName(String className) {
        className = Element.trimClassName(className);
        String oldClassName = this.getClassName();
        int idx = Element.indexOfName(oldClassName, className);
        if (idx == -1) {
            if (oldClassName.length() > 0) {
                this.setClassName(oldClassName + " " + className);
            } else {
                this.setClassName(className);
            }
            return true;
        }
        return false;
    }

    public final void blur() {
        throw new RuntimeException("Cannot call native method");
    }

    public final void dispatchEvent(NativeEvent evt) {
        DOMImpl.impl.dispatchEvent(this, evt);
    }

    public final void focus() {
        throw new RuntimeException("Cannot call native method");
    }

    public final int getAbsoluteBottom() {
        return this.getAbsoluteTop() + this.getOffsetHeight();
    }

    public final int getAbsoluteLeft() {
        return DOMImpl.impl.getAbsoluteLeft(this);
    }

    public final int getAbsoluteRight() {
        return this.getAbsoluteLeft() + this.getOffsetWidth();
    }

    public final int getAbsoluteTop() {
        return DOMImpl.impl.getAbsoluteTop(this);
    }

    public final String getAttribute(String name) {
        return DOMImpl.impl.getAttribute(this, name);
    }

    public final String getClassName() {
        throw new RuntimeException("Cannot call native method");
    }

    public final int getClientHeight() {
        return Element.toInt32(this.getSubPixelClientHeight());
    }

    public final int getClientWidth() {
        return Element.toInt32(this.getSubPixelClientWidth());
    }

    public final String getDir() {
        throw new RuntimeException("Cannot call native method");
    }

    public final String getDraggable() {
        throw new RuntimeException("Cannot call native method");
    }

    public final NodeList<Element> getElementsByTagName(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final Element getFirstChildElement() {
        return DOMImpl.impl.getFirstChildElement(this);
    }

    public final String getId() {
        throw new RuntimeException("Cannot call native method");
    }

    public final String getInnerHTML() {
        return DOMImpl.impl.getInnerHTML(this);
    }

    public final String getInnerText() {
        return DOMImpl.impl.getInnerText(this);
    }

    public final String getLang() {
        throw new RuntimeException("Cannot call native method");
    }

    public final Element getNextSiblingElement() {
        return DOMImpl.impl.getNextSiblingElement(this);
    }

    public final int getOffsetHeight() {
        return Element.toInt32(this.getSubPixelOffsetHeight());
    }

    public final int getOffsetLeft() {
        return Element.toInt32(this.getSubPixelOffsetLeft());
    }

    public final Element getOffsetParent() {
        throw new RuntimeException("Cannot call native method");
    }

    public final int getOffsetTop() {
        return Element.toInt32(this.getSubPixelOffsetTop());
    }

    public final int getOffsetWidth() {
        return Element.toInt32(this.getSubPixelOffsetWidth());
    }

    public final Element getPreviousSiblingElement() {
        return DOMImpl.impl.getPreviousSiblingElement(this);
    }

    public final boolean getPropertyBoolean(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final double getPropertyDouble(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final int getPropertyInt(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final JavaScriptObject getPropertyJSO(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final Object getPropertyObject(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final String getPropertyString(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final int getScrollHeight() {
        return Element.toInt32(this.getSubPixelScrollHeight());
    }

    public final int getScrollLeft() {
        return DOMImpl.impl.getScrollLeft(this);
    }

    public final int getScrollTop() {
        return Element.toInt32(this.getSubPixelScrollTop());
    }

    public final int getScrollWidth() {
        return Element.toInt32(this.getSubPixelScrollWidth());
    }

    public final String getString() {
        return DOMImpl.impl.toString(this);
    }

    public final Style getStyle() {
        throw new RuntimeException("Cannot call native method");
    }

    public final int getTabIndex() {
        return DOMImpl.impl.getTabIndex(this);
    }

    public final String getTagName() {
        return DOMImpl.impl.getTagName(this);
    }

    public final String getTitle() {
        throw new RuntimeException("Cannot call native method");
    }

    public final boolean hasAttribute(String name) {
        return DOMImpl.impl.hasAttribute(this, name);
    }

    public final boolean hasClassName(String className) {
        className = Element.trimClassName(className);
        int idx = Element.indexOfName(this.getClassName(), className);
        return idx != -1;
    }

    public final boolean hasTagName(String tagName) {
        assert (tagName != null) : "tagName must not be null";
        return tagName.equalsIgnoreCase(this.getTagName());
    }

    public final void removeAttribute(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final boolean removeClassName(String className) {
        className = Element.trimClassName(className);
        String oldStyle = this.getClassName();
        int idx = Element.indexOfName(oldStyle, className);
        if (idx != -1) {
            String begin = oldStyle.substring(0, idx).trim();
            String end = oldStyle.substring(idx + className.length()).trim();
            String newClassName = begin.length() == 0 ? end : (end.length() == 0 ? begin : begin + " " + end);
            this.setClassName(newClassName);
            return true;
        }
        return false;
    }

    static int indexOfName(String nameList, String name) {
        int lastPos;
        int last;
        int idx = nameList.indexOf(name);
        while (idx != -1 && (idx != 0 && nameList.charAt(idx - 1) != ' ' || (last = idx + name.length()) != (lastPos = nameList.length()) && (last >= lastPos || nameList.charAt(last) != ' '))) {
            idx = nameList.indexOf(name, idx + 1);
        }
        return idx;
    }

    private static String trimClassName(String className) {
        assert (className != null) : "Unexpectedly null class name";
        className = className.trim();
        assert (!className.isEmpty()) : "Unexpectedly empty class name";
        return className;
    }

    public final void toggleClassName(String className) {
        boolean added = this.addClassName(className);
        if (!added) {
            this.removeClassName(className);
        }
    }

    public final void replaceClassName(String oldClassName, String newClassName) {
        this.removeClassName(oldClassName);
        this.addClassName(newClassName);
    }

    public final void scrollIntoView() {
        DOMImpl.impl.scrollIntoView(this);
    }

    public final void setAttribute(String string, String string2) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setClassName(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setDir(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setDraggable(String draggable) {
        DOMImpl.impl.setDraggable(this, draggable);
    }

    public final void setId(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setInnerHTML(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setInnerSafeHtml(SafeHtml html) {
        this.setInnerHTML(html.asString());
    }

    public final void setInnerText(String text) {
        DOMImpl.impl.setInnerText(this, text);
    }

    public final void setLang(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setPropertyBoolean(String string, boolean bl) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setPropertyDouble(String string, double d) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setPropertyInt(String string, int n) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setPropertyJSO(String string, JavaScriptObject javaScriptObject) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setPropertyObject(String string, Object object) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setPropertyString(String string, String string2) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setScrollLeft(int scrollLeft) {
        DOMImpl.impl.setScrollLeft(this, scrollLeft);
    }

    public final void setScrollTop(int n) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setTabIndex(int n) {
        throw new RuntimeException("Cannot call native method");
    }

    public final void setTitle(String string) {
        throw new RuntimeException("Cannot call native method");
    }

    private final double getSubPixelClientHeight() {
        throw new RuntimeException("Cannot call native method");
    }

    private final double getSubPixelClientWidth() {
        throw new RuntimeException("Cannot call native method");
    }

    private final double getSubPixelOffsetHeight() {
        throw new RuntimeException("Cannot call native method");
    }

    private final double getSubPixelOffsetLeft() {
        throw new RuntimeException("Cannot call native method");
    }

    private final double getSubPixelOffsetTop() {
        throw new RuntimeException("Cannot call native method");
    }

    private final double getSubPixelOffsetWidth() {
        throw new RuntimeException("Cannot call native method");
    }

    private final double getSubPixelScrollHeight() {
        throw new RuntimeException("Cannot call native method");
    }

    private final double getSubPixelScrollTop() {
        throw new RuntimeException("Cannot call native method");
    }

    private final double getSubPixelScrollWidth() {
        throw new RuntimeException("Cannot call native method");
    }
}

