/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.xml;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.xml.AttributeConverter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class Schema {
    private final Map<Class<?>, AttributeConverter> convertersByType = new HashMap();
    private Schema parent;
    private int lineNumber;

    public AttributeConverter getAttributeConverter(Class<?> type) {
        AttributeConverter converter = this.convertersByType.get(type);
        if (converter != null) {
            return converter;
        }
        if (this.parent != null) {
            return this.parent.getAttributeConverter(type);
        }
        throw new IllegalStateException("Unable to find an attribute converter for type " + type.getName());
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void onBadAttributeValue(int line, String elem, String attr, String value, Class<?> paramType) throws UnableToCompleteException {
        if (this.parent != null) {
            this.parent.onBadAttributeValue(line, elem, attr, value, paramType);
        }
    }

    public void onHandlerException(int line, String elem, Method method, Throwable e) throws UnableToCompleteException {
        if (this.parent != null) {
            this.parent.onHandlerException(line, elem, method, e);
        }
    }

    public void onMissingAttribute(int line, String elem, String attr) throws UnableToCompleteException {
        if (this.parent != null) {
            this.parent.onMissingAttribute(line, elem, attr);
        }
    }

    public void onUnexpectedAttribute(int line, String elem, String attr, String value) throws UnableToCompleteException {
        if (this.parent != null) {
            this.parent.onUnexpectedAttribute(line, elem, attr, value);
        }
    }

    public void onUnexpectedChild(int line, String elem) throws UnableToCompleteException {
        if (this.parent != null) {
            this.parent.onUnexpectedChild(line, elem);
        }
    }

    public void onUnexpectedElement(int line, String elem) throws UnableToCompleteException {
        if (this.parent != null) {
            this.parent.onUnexpectedElement(line, elem);
        }
    }

    public void registerAttributeConverter(Class<?> type, AttributeConverter converter) {
        this.convertersByType.put(type, converter);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setParent(Schema parent) {
        this.parent = parent;
    }
}

