/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.xml;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.xml.DefaultSchema;
import com.google.gwt.dev.util.xml.HandlerArgs;
import com.google.gwt.dev.util.xml.HandlerClassInfo;
import com.google.gwt.dev.util.xml.HandlerMethod;
import com.google.gwt.dev.util.xml.Messages;
import com.google.gwt.dev.util.xml.Schema;
import com.google.gwt.util.tools.Utility;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ReflectiveParser {
    private static SAXParserFactory saxParserFactory;

    private static synchronized SAXParser createNewSaxParser() throws ParserConfigurationException, SAXException {
        if (saxParserFactory == null) {
            Thread currentThread = Thread.currentThread();
            ClassLoader oldClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                saxParserFactory = SAXParserFactory.newInstance();
                saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            finally {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }
        return saxParserFactory.newSAXParser();
    }

    public static void parse(TreeLogger logger, Schema schema, Reader reader) throws UnableToCompleteException {
        ReflectiveParser.registerSchemaLevel(schema.getClass());
        Impl impl = new Impl();
        impl.parse(logger, schema, reader);
    }

    public static void registerSchemaLevel(Class<? extends Schema> schemaLevelClass) {
        HandlerClassInfo.registerClass(schemaLevelClass);
        for (Class<?> nestedClass : schemaLevelClass.getDeclaredClasses()) {
            if (!Schema.class.isAssignableFrom(nestedClass)) continue;
            ReflectiveParser.registerSchemaLevel(nestedClass.asSubclass(Schema.class));
        }
    }

    private static final class Impl
    extends DefaultHandler {
        private Locator locator;
        private Reader reader;
        private Stack<Schema> schemaLevels = new Stack();
        private Stack<Object[]> argStack = new Stack();
        private Schema defaultSchema;

        private Impl() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            int lineNumber = this.locator.getLineNumber();
            Schema schemaLevel = this.getTopSchemaLevel();
            if (schemaLevel == null) {
                for (int i = 0; i < length; ++i) {
                    if (Character.isWhitespace(ch[i + start])) continue;
                    throw new SAXException("Unexpected XML data found: " + String.valueOf(ch, start, length));
                }
                return;
            }
            Class<?> slc = schemaLevel.getClass();
            HandlerClassInfo classInfo = HandlerClassInfo.getClassInfo(slc);
            assert (classInfo != null);
            HandlerMethod method = classInfo.getTextMethod();
            if (method == null) {
                return;
            }
            try {
                int e = start + length;
                int l = e - 1;
                block7: for (int i = start; i < e; ++i) {
                    switch (ch[i]) {
                        case '\r': {
                            if (i < l && ch[i + 1] == '\n') continue block7;
                        }
                        case '\n': {
                            --lineNumber;
                        }
                    }
                }
                String text = String.valueOf(ch, start, length);
                method.invokeText(lineNumber, text, schemaLevel);
            }
            catch (UnableToCompleteException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String elem) throws SAXException {
            int lineNumber = this.locator.getLineNumber();
            Schema schemaLevel = this.popLevel();
            if (schemaLevel == null) {
                return;
            }
            Class<?> slc = schemaLevel.getClass();
            HandlerClassInfo classInfo = HandlerClassInfo.getClassInfo(slc);
            assert (classInfo != null);
            HandlerMethod method = classInfo.getEndMethod(elem);
            if (method == null) {
                return;
            }
            Object[] args = this.getCurrentArgs();
            if (args != null) {
                try {
                    method.invokeEnd(lineNumber, elem, schemaLevel, args);
                }
                catch (UnableToCompleteException e) {
                    throw new SAXException(e);
                }
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String elemName, Attributes atts) throws SAXException {
            Schema childSchemaLevel;
            int lineNumber = this.locator.getLineNumber();
            Schema schemaLevel = this.getTopSchemaLevel();
            if (schemaLevel == null) {
                Schema nextToTop = this.getNextToTopSchemaLevel();
                this.setArgsAndPushLevel(null, null);
                try {
                    nextToTop.onUnexpectedChild(lineNumber, elemName);
                }
                catch (UnableToCompleteException e) {
                    throw new SAXException(e);
                }
                return;
            }
            Class<?> slc = schemaLevel.getClass();
            HandlerClassInfo classInfo = HandlerClassInfo.getClassInfo(slc);
            HandlerMethod method = classInfo.getStartMethod(elemName);
            if (method == null) {
                try {
                    schemaLevel.onUnexpectedElement(lineNumber, elemName);
                }
                catch (UnableToCompleteException e) {
                    throw new SAXException(e);
                }
                this.setArgsAndPushLevel(null, null);
                return;
            }
            HandlerArgs args = method.createArgs(schemaLevel, lineNumber, elemName);
            int n = atts.getLength();
            for (int i = 0; i < n; ++i) {
                String attrValue;
                String attrName = atts.getQName(i);
                if (args.setArg(attrName, attrValue = atts.getValue(i))) continue;
                try {
                    schemaLevel.onUnexpectedAttribute(lineNumber, elemName, attrName, attrValue);
                    continue;
                }
                catch (UnableToCompleteException e) {
                    throw new SAXException(e);
                }
            }
            int missingCount = 0;
            int n2 = args.getArgCount();
            for (int i = 0; i < n2; ++i) {
                if (args.isArgSet(i)) continue;
                try {
                    schemaLevel.onMissingAttribute(lineNumber, elemName, args.getArgName(i));
                }
                catch (UnableToCompleteException e) {
                    throw new SAXException(e);
                }
                ++missingCount;
            }
            if (missingCount > 0) {
                this.setArgsAndPushLevel(null, null);
                return;
            }
            Object[] invokeArgs = new Object[method.getParamCount()];
            try {
                childSchemaLevel = method.invokeBegin(lineNumber, elemName, schemaLevel, args, invokeArgs);
            }
            catch (UnableToCompleteException e) {
                throw new SAXException(e);
            }
            this.setArgsAndPushLevel(invokeArgs, childSchemaLevel);
        }

        private Object[] getCurrentArgs() {
            return this.argStack.peek();
        }

        private Schema getNextToTopSchemaLevel() {
            return (Schema)this.schemaLevels.get(this.schemaLevels.size() - 2);
        }

        private Schema getTopSchemaLevel() {
            return this.schemaLevels.peek();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parse(TreeLogger logger, Schema topSchema, Reader reader) throws UnableToCompleteException {
            this.defaultSchema = new DefaultSchema(logger);
            topSchema.setParent(this.defaultSchema);
            this.argStack.push(null);
            this.setArgsAndPushLevel(null, topSchema);
            Exception caught = null;
            try {
                this.reader = reader;
                SAXParser parser = ReflectiveParser.createNewSaxParser();
                InputSource inputSource = new InputSource(this.reader);
                XMLReader xmlReader = parser.getXMLReader();
                xmlReader.setContentHandler(this);
                xmlReader.parse(inputSource);
            }
            catch (SAXException e) {
                caught = e;
                Exception inner = e.getException();
                if (inner instanceof RuntimeException) {
                    throw (RuntimeException)inner;
                }
                if (inner != null) {
                    caught = inner;
                }
            }
            catch (ParserConfigurationException e) {
                caught = e;
            }
            catch (IOException e) {
                caught = e;
            }
            finally {
                Utility.close(reader);
            }
            if (caught instanceof UnableToCompleteException) {
                throw (UnableToCompleteException)caught;
            }
            if (caught instanceof SAXParseException) {
                SAXParseException parseException = (SAXParseException)caught;
                logger.log(TreeLogger.Type.ERROR, "Line " + parseException.getLineNumber() + ", column " + parseException.getColumnNumber() + " : " + parseException.getMessage());
            } else if (caught != null) {
                Messages.XML_PARSE_FAILED.log(logger, caught);
            }
            if (caught != null) {
                throw new UnableToCompleteException();
            }
        }

        private Schema popLevel() {
            this.argStack.pop();
            this.schemaLevels.pop();
            return this.getTopSchemaLevel();
        }

        private void setArgsAndPushLevel(Object[] handlerArgs, Schema schemaLevel) {
            this.argStack.set(this.argStack.size() - 1, handlerArgs);
            this.argStack.push(null);
            if (!this.schemaLevels.isEmpty()) {
                Schema maybeParent = null;
                for (int i = this.schemaLevels.size() - 1; i >= 0 && (maybeParent = (Schema)this.schemaLevels.get(i)) == null; --i) {
                }
                if (maybeParent == null) {
                    throw new IllegalStateException("Cannot find any parent schema");
                }
                if (schemaLevel != null) {
                    schemaLevel.setParent(maybeParent);
                }
            }
            this.schemaLevels.push(schemaLevel);
        }
    }
}

