/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.xml;

import com.google.gwt.dev.util.xml.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class HandlerParam {
    private final Class<?> paramType;
    private final Field metaField;
    private final boolean isOptional;
    private final String normalizedAttrName;

    public static HandlerParam create(Method method, String normalizedTagName, int paramIndex) {
        Class<?> paramType = method.getParameterTypes()[paramIndex];
        Field[] fields = method.getDeclaringClass().getDeclaredFields();
        String fieldNamePrefix = normalizedTagName + "_" + (paramIndex + 1);
        Field matchingField = null;
        String fieldName = null;
        for (Field testField : fields) {
            fieldName = testField.getName();
            if (!fieldName.startsWith(fieldNamePrefix)) continue;
            matchingField = testField;
            break;
        }
        if (matchingField == null) {
            throw new IllegalArgumentException("Expecting a meta field with prefix '" + fieldNamePrefix + "'");
        }
        int under = fieldName.indexOf("_", fieldNamePrefix.length());
        if (under == -1) {
            throw new IllegalArgumentException("Expecting a normalized attribute name suffix (e.g. \"_attr_name\") on field '" + fieldName + "'");
        }
        String normalizedAttrName = fieldName.substring(under + 1);
        if (!String.class.equals(matchingField.getType())) {
            throw new IllegalArgumentException("GWT field '" + fieldName + "' must be of type String");
        }
        matchingField.setAccessible(true);
        HandlerParam handlerParam = new HandlerParam(paramType, matchingField, normalizedAttrName);
        return handlerParam;
    }

    private HandlerParam(Class<?> paramType, Field metaField, String normalizedAttrName) {
        this.isOptional = normalizedAttrName.endsWith("$");
        if (this.isOptional) {
            normalizedAttrName = normalizedAttrName.substring(0, normalizedAttrName.length() - 1);
        }
        this.paramType = paramType;
        this.metaField = metaField;
        this.normalizedAttrName = normalizedAttrName;
    }

    public String getDefaultValue(Schema schema) {
        Exception caught = null;
        try {
            return (String)this.metaField.get(schema);
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        throw new IllegalStateException("Unable to get attribute default value from meta field '" + this.metaField.getName() + "'", caught);
    }

    public String getNormalizedName() {
        return this.normalizedAttrName;
    }

    public Class<?> getParamType() {
        return this.paramType;
    }

    public boolean isOptional() {
        return this.isOptional;
    }
}

