/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.xml;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.xml.HandlerArgs;
import com.google.gwt.dev.util.xml.HandlerParam;
import com.google.gwt.dev.util.xml.ReflectiveParser;
import com.google.gwt.dev.util.xml.Schema;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class HandlerMethod {
    private static final HandlerParam[] EMPTY_HANDLERPARAMS = new HandlerParam[0];
    private static final Schema sArbitraryChildHandler = new Schema(){

        @Override
        public void onBadAttributeValue(int lineNumber, String elemName, String attrName, String attrValue, Class<?> paramType) {
        }

        @Override
        public void onHandlerException(int lineNumber, String elemLocalName, Method method, Throwable e) {
        }

        @Override
        public void onMissingAttribute(int lineNumber, String elemName, String argName) {
        }

        @Override
        public void onUnexpectedAttribute(int lineNumber, String elemName, String attrName, String attrValue) {
        }

        @Override
        public void onUnexpectedChild(int lineNumber, String elemName) {
        }

        @Override
        public void onUnexpectedElement(int lineNumber, String elemName) {
        }
    };
    private static final int TYPE_NONE = 0;
    private static final int TYPE_BEGIN = 1;
    private static final int TYPE_END = 2;
    private static final int TYPE_TEXT = 3;
    private final boolean arbitraryChildren;
    private final HandlerParam[] handlerParams;
    private final Method method;
    private final int methodType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HandlerMethod tryCreate(Method method) {
        String methodName = method.getName();
        String normalizedTagName = null;
        try {
            int type = 0;
            if (methodName.startsWith("__")) {
                if (methodName.endsWith("_begin")) {
                    type = 1;
                    normalizedTagName = methodName.substring(0, methodName.length() - "_begin".length());
                } else if (methodName.endsWith("_end")) {
                    type = 2;
                    normalizedTagName = methodName.substring(0, methodName.length() - "_end".length());
                } else if (methodName.equals("__text")) {
                    type = 3;
                }
            }
            if (type == 0) {
                return null;
            }
            assert (type == 1 || type == 2 || type == 3);
            Class<?> returnType = method.getReturnType();
            boolean arbitraryChildren = false;
            if (type == 1) {
                if (Schema.class.isAssignableFrom(returnType)) {
                    arbitraryChildren = false;
                    ReflectiveParser.registerSchemaLevel(returnType);
                } else {
                    if (!returnType.equals(Void.TYPE)) throw new IllegalArgumentException("The return type of begin handlers must be 'void' or assignable to 'SchemaLevel'");
                    arbitraryChildren = true;
                }
            } else if (!Void.TYPE.equals(returnType)) {
                throw new IllegalArgumentException("Only 'void' may be specified as a return type for 'end' and 'text' handlers");
            }
            if (type == 3) {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length == 1 && String.class.equals(paramTypes[0])) return new HandlerMethod(method, type, false, EMPTY_HANDLERPARAMS);
                throw new IllegalArgumentException("__text handlers must have exactly one String parameter");
            }
            Class<?>[] paramTypes = method.getParameterTypes();
            ArrayList<HandlerParam> handlerParams = new ArrayList<HandlerParam>();
            int n = paramTypes.length;
            for (int i = 0; i < n; ++i) {
                HandlerParam handlerParam = HandlerParam.create(method, normalizedTagName, i);
                if (handlerParam == null) {
                    throw new IllegalArgumentException("In method '" + method.getName() + "', parameter " + (i + 1) + " is an unsupported type");
                }
                handlerParams.add(handlerParam);
            }
            HandlerParam[] hpa = handlerParams.toArray(EMPTY_HANDLERPARAMS);
            return new HandlerMethod(method, type, arbitraryChildren, hpa);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to use method '" + methodName + "' as a handler", e);
        }
    }

    private HandlerMethod(Method method, int type, boolean arbitraryChildren, HandlerParam[] hpa) {
        this.method = method;
        this.methodType = type;
        this.arbitraryChildren = arbitraryChildren;
        this.handlerParams = (HandlerParam[])hpa.clone();
        this.method.setAccessible(true);
    }

    public HandlerArgs createArgs(Schema schema, int lineNumber, String elemName) {
        return new HandlerArgs(schema, lineNumber, elemName, this.handlerParams);
    }

    public String getNormalizedName() {
        String name = this.method.getName();
        if (this.isStartMethod()) {
            return name.substring(2, name.length() - "_begin".length());
        }
        if (this.isEndMethod()) {
            return name.substring(2, name.length() - "_end".length());
        }
        throw new IllegalStateException("Unexpected method name");
    }

    public HandlerParam getParam(int i) {
        return this.handlerParams[i];
    }

    public int getParamCount() {
        return this.handlerParams.length;
    }

    public Schema invokeBegin(int lineNumber, String elemLocalName, Schema target, HandlerArgs args, Object[] outInvokeArgs) throws UnableToCompleteException {
        assert (outInvokeArgs.length == args.getArgCount());
        int n = args.getArgCount();
        for (int i = 0; i < n; ++i) {
            Object invokeArg;
            outInvokeArgs[i] = invokeArg = args.convertToArg(i);
        }
        Schema nextSchemaLevel = null;
        Throwable caught = null;
        try {
            target.setLineNumber(lineNumber);
            nextSchemaLevel = (Schema)this.method.invoke((Object)target, outInvokeArgs);
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e.getTargetException();
        }
        if (caught != null) {
            target.onHandlerException(lineNumber, elemLocalName, this.method, caught);
        }
        if (nextSchemaLevel != null) {
            return nextSchemaLevel;
        }
        if (this.arbitraryChildren) {
            return sArbitraryChildHandler;
        }
        return null;
    }

    public void invokeEnd(int lineNumber, String elem, Schema target, Object[] args) throws UnableToCompleteException {
        Throwable caught = null;
        try {
            target.setLineNumber(lineNumber);
            this.method.invoke((Object)target, args);
            return;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e.getTargetException();
        }
        target.onHandlerException(lineNumber, elem, this.method, caught);
    }

    public void invokeText(int lineNumber, String text, Schema target) throws UnableToCompleteException {
        Throwable caught = null;
        try {
            target.setLineNumber(lineNumber);
            this.method.invoke((Object)target, text);
            return;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e.getTargetException();
        }
        target.onHandlerException(lineNumber, "#text", this.method, caught);
    }

    public boolean isEndMethod() {
        return this.methodType == 2;
    }

    public boolean isStartMethod() {
        return this.methodType == 1;
    }

    static {
        ReflectiveParser.registerSchemaLevel(sArbitraryChildHandler.getClass());
    }
}

