/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.xml;

import com.google.gwt.dev.util.xml.HandlerMethod;
import com.google.gwt.dev.util.xml.Schema;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class HandlerClassInfo {
    private static final HandlerMethod[] EMPTY_ARRAY_HANDLERMETHOD = new HandlerMethod[0];
    private static Map<Class<?>, HandlerClassInfo> sClassInfoMap = new HashMap();
    private final Map<String, HandlerMethod> namedHandlerMethods;

    public static synchronized HandlerClassInfo getClassInfo(Class<?> c) {
        if (sClassInfoMap.containsKey(c)) {
            return sClassInfoMap.get(c);
        }
        throw new RuntimeException("The schema class '" + c.getName() + "' should have been registered prior to parsing");
    }

    public static synchronized void registerClass(Class<?> c) {
        if (sClassInfoMap.containsKey(c)) {
            return;
        }
        sClassInfoMap.put(c, null);
        HandlerClassInfo classInfo = HandlerClassInfo.createClassInfo(c);
        sClassInfoMap.put(c, classInfo);
    }

    private static HandlerClassInfo createClassInfo(Class<?> c) {
        HashMap<String, HandlerMethod> namedHandlerMethods = new HashMap<String, HandlerMethod>();
        try {
            HandlerClassInfo.loadClassInfoRecursive(namedHandlerMethods, c);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to use class '" + c.getName() + "' as a handler", e);
        }
        HandlerClassInfo classInfo = new HandlerClassInfo(namedHandlerMethods);
        return classInfo;
    }

    private static void loadClassInfoRecursive(Map<String, HandlerMethod> namedHandlerMethods, Class<?> c) {
        if (!Schema.class.isAssignableFrom(c)) {
            return;
        }
        for (Method method : c.getDeclaredMethods()) {
            String name;
            HandlerMethod handlerMethod = HandlerMethod.tryCreate(method);
            if (handlerMethod == null || namedHandlerMethods.containsKey(name = method.getName())) continue;
            namedHandlerMethods.put(name, handlerMethod);
        }
        Class<?> superclass = c.getSuperclass();
        if (superclass != null) {
            HandlerClassInfo.loadClassInfoRecursive(namedHandlerMethods, superclass);
        }
    }

    private HandlerClassInfo(Map<String, HandlerMethod> namedHandlerMethods) {
        this.namedHandlerMethods = namedHandlerMethods;
    }

    public HandlerMethod getEndMethod(String localName) {
        String methodName = "__" + localName.replace('-', '_');
        return this.namedHandlerMethods.get(methodName + "_end");
    }

    public HandlerMethod[] getHandlerMethods() {
        return this.namedHandlerMethods.values().toArray(EMPTY_ARRAY_HANDLERMETHOD);
    }

    public HandlerMethod getStartMethod(String localName) {
        String methodName = "__" + localName.replace('-', '_');
        return this.namedHandlerMethods.get(methodName + "_begin");
    }

    public HandlerMethod getTextMethod() {
        return this.namedHandlerMethods.get("__text");
    }
}

