/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.xml;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.xml.AttributeConverter;
import com.google.gwt.dev.util.xml.HandlerParam;
import com.google.gwt.dev.util.xml.Schema;

public class HandlerArgs {
    private final String[] attrNames;
    private final String[] argValues;
    private final HandlerParam[] handlerParams;
    private final int lineNumber;
    private final Schema schema;
    private final String elemName;

    public HandlerArgs(Schema schema, int lineNumber, String elemName, HandlerParam[] handlerParams) {
        this.schema = schema;
        this.lineNumber = lineNumber;
        this.elemName = elemName;
        this.handlerParams = handlerParams;
        this.attrNames = new String[handlerParams.length];
        this.argValues = new String[handlerParams.length];
        int n = handlerParams.length;
        for (int i = 0; i < n; ++i) {
            this.argValues[i] = this.handlerParams[i].getDefaultValue(schema);
        }
    }

    public Object convertToArg(int i) throws UnableToCompleteException {
        String value = this.argValues[i];
        if (value != null) {
            AttributeConverter converter = this.schema.getAttributeConverter(this.handlerParams[i].getParamType());
            return converter.convertToArg(this.schema, this.lineNumber, this.elemName, this.attrNames[i], value);
        }
        if (this.handlerParams[i].isOptional()) {
            return null;
        }
        return new NullPointerException("Argument " + i + " was null");
    }

    public int getArgCount() {
        return this.handlerParams.length;
    }

    public String getArgName(int i) {
        return this.handlerParams[i].getNormalizedName();
    }

    public boolean isArgSet(int i) {
        return this.argValues[i] != null || this.handlerParams[i].isOptional();
    }

    public boolean setArg(String attrName, String attrValue) {
        String normalizedAttrName = this.normalizeAttrName(attrName);
        int n = this.handlerParams.length;
        for (int i = 0; i < n; ++i) {
            String testParamName = this.handlerParams[i].getNormalizedName();
            if (!testParamName.equals(normalizedAttrName)) continue;
            this.attrNames[i] = attrName;
            this.argValues[i] = attrValue;
            return true;
        }
        return false;
    }

    private String normalizeAttrName(String attrName) {
        return attrName.replace('-', '_');
    }
}

