/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.xml;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.xml.AttributeConverterForBoolean;
import com.google.gwt.dev.util.xml.AttributeConverterForInteger;
import com.google.gwt.dev.util.xml.AttributeConverterForString;
import com.google.gwt.dev.util.xml.Messages;
import com.google.gwt.dev.util.xml.Schema;
import java.lang.reflect.Method;

public class DefaultSchema
extends Schema {
    private final TreeLogger logger;

    public DefaultSchema(TreeLogger logger) {
        this.logger = logger;
        this.registerAttributeConverter(Integer.TYPE, new AttributeConverterForInteger());
        this.registerAttributeConverter(Integer.class, new AttributeConverterForInteger());
        this.registerAttributeConverter(String.class, new AttributeConverterForString());
        this.registerAttributeConverter(Boolean.TYPE, new AttributeConverterForBoolean());
        this.registerAttributeConverter(Boolean.class, new AttributeConverterForBoolean());
    }

    @Override
    public void onBadAttributeValue(int line, String elem, String attr, String value, Class<?> paramType) throws UnableToCompleteException {
        Messages.XML_ATTRIBUTE_CONVERSION_ERROR.log(this.logger, line, attr, paramType, null);
        throw new UnableToCompleteException();
    }

    @Override
    public void onHandlerException(int line, String elem, Method method, Throwable e) throws UnableToCompleteException {
        if (e instanceof UnableToCompleteException) {
            throw (UnableToCompleteException)e;
        }
        Messages.XML_ELEMENT_HANDLER_EXCEPTION.log(this.logger, line, elem, e);
        throw new UnableToCompleteException();
    }

    @Override
    public void onMissingAttribute(int line, String elem, String attr) throws UnableToCompleteException {
        Messages.XML_REQUIRED_ATTRIBUTE_MISSING.log(this.logger, elem, line, attr, null);
        throw new UnableToCompleteException();
    }

    @Override
    public void onUnexpectedAttribute(int line, String elem, String attr, String value) throws UnableToCompleteException {
        Messages.XML_ATTRIBUTE_UNEXPECTED.log(this.logger, elem, line, attr, null);
        throw new UnableToCompleteException();
    }

    @Override
    public void onUnexpectedChild(int line, String childElem) throws UnableToCompleteException {
        Messages.XML_CHILDREN_NOT_ALLOWED.log(this.logger, childElem, line, null);
        throw new UnableToCompleteException();
    }

    @Override
    public void onUnexpectedElement(int line, String elem) throws UnableToCompleteException {
        Messages.XML_ELEMENT_UNEXPECTED.log(this.logger, line, elem, null);
        throw new UnableToCompleteException();
    }
}

