/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.msg;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.util.msg.Formatter;
import com.google.gwt.dev.util.msg.FormatterForClass;
import com.google.gwt.dev.util.msg.FormatterForInteger;
import com.google.gwt.dev.util.msg.FormatterForString;
import com.google.gwt.dev.util.msg.FormatterToString;

public abstract class Message {
    private static final Formatter FMT_TOSTRING = new FormatterToString();
    private static final Formatter FMT_CLASS = new FormatterForClass();
    private static final Formatter FMT_INTEGER = new FormatterForInteger();
    private static final Formatter FMT_STRING = new FormatterForString();
    protected final TreeLogger.Type type;
    protected final char[][] fmtParts;
    protected final int[] argIndices;

    protected Message(TreeLogger.Type type, String fmt, int args) {
        assert (type != null);
        assert (fmt != null);
        assert (args >= 0);
        this.type = type;
        this.fmtParts = new char[args + 1][];
        this.argIndices = new int[args];
        int from = 0;
        for (int i = 0; i < args; ++i) {
            char charDigit;
            int to = fmt.indexOf(36, from);
            if (to == -1 || to >= fmt.length() - 1 || !Character.isDigit(charDigit = fmt.charAt(to + 1))) {
                throw new IllegalArgumentException("Expected arg $" + i);
            }
            int digit = Character.digit(charDigit, 10);
            this.fmtParts[i] = fmt.substring(from, to).toCharArray();
            this.argIndices[i] = digit;
            from = to + 2;
        }
        this.fmtParts[args] = fmt.substring(from).toCharArray();
    }

    protected final Formatter getFormatter(Class<?> c) {
        return FMT_CLASS;
    }

    protected final Formatter getFormatter(Integer i) {
        return FMT_INTEGER;
    }

    protected final Formatter getFormatter(String s) {
        return FMT_STRING;
    }

    protected final Formatter getToStringFormatter() {
        return FMT_TOSTRING;
    }

    protected TreeLogger branch(TreeLogger logger, Throwable caught) {
        return this.branch(logger, this.toArray(new Object[0]), new Formatter[0], caught);
    }

    protected TreeLogger branch(TreeLogger logger, Object arg, Formatter fmt, Throwable caught) {
        return this.branch(logger, this.toArray(arg), this.toArray(fmt), caught);
    }

    protected TreeLogger branch(TreeLogger logger, Object[] args, Object[] fmts, Throwable caught) {
        return logger.branch(this.type, this.compose(args, fmts), caught);
    }

    protected String compose(Object[] args, Object[] fmts) {
        assert (args.length == fmts.length);
        String[] formattedArgs = new String[args.length];
        for (int i = 0; i < this.argIndices.length; ++i) {
            int referredIndex = this.argIndices[i];
            Object referredArg = args[referredIndex];
            Formatter formatter = (Formatter)fmts[referredIndex];
            formattedArgs[i] = referredArg != null ? formatter.format(referredArg) : "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < formattedArgs.length; ++i) {
            stringBuilder.append(this.fmtParts[i]);
            stringBuilder.append(formattedArgs[i]);
        }
        stringBuilder.append(this.fmtParts[this.fmtParts.length - 1]);
        return stringBuilder.toString();
    }

    protected void log(TreeLogger logger, Throwable caught) {
        this.log(logger, this.toArray(new Object[0]), this.toArray(new Object[0]), caught);
    }

    protected void log(TreeLogger logger, Object arg, Formatter fmt, Throwable caught) {
        this.log(logger, this.toArray(arg), this.toArray(fmt), caught);
    }

    protected void log(TreeLogger logger, Object arg1, Object arg2, Formatter fmt1, Formatter fmt2, Throwable caught) {
        this.log(logger, this.toArray(arg1, arg2), this.toArray(fmt1, fmt2), caught);
    }

    protected void log(TreeLogger logger, Object arg1, Object arg2, Object arg3, Formatter fmt1, Formatter fmt2, Formatter fmt3, Throwable caught) {
        this.log(logger, this.toArray(arg1, arg2, arg3), this.toArray(fmt1, fmt2, fmt3), caught);
    }

    protected void log(TreeLogger logger, Object arg1, Object arg2, Object arg3, Object arg4, Formatter fmt1, Formatter fmt2, Formatter fmt3, Formatter fmt4, Throwable caught) {
        this.log(logger, this.toArray(arg1, arg2, arg3, arg4), this.toArray(fmt1, fmt2, fmt3, fmt4), caught);
    }

    protected void log(TreeLogger logger, Object[] args, Object[] fmts, Throwable caught) {
        if (logger.isLoggable(this.type)) {
            logger.log(this.type, this.compose(args, fmts), caught);
        }
    }

    private Object[] toArray(Object ... pars) {
        return pars;
    }
}

