/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.log.speedtracer;

import com.google.gwt.dev.json.JsonArray;
import com.google.gwt.dev.json.JsonObject;
import com.google.gwt.dev.shell.DevModeSession;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.log.dashboard.DashboardNotifierFactory;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerEventType;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public final class SpeedTracerLogger {
    private static final Logger log = Logger.getLogger(SpeedTracerLogger.class.getName());
    private static final String logFile = System.getProperty("gwt.speedtracerlog");
    private static final String defaultFormatString = System.getProperty("gwt.speedtracerformat");
    private static final boolean logProcessCpuTime = SpeedTracerLogger.getBooleanProperty("gwt.speedtracer.logProcessCpuTime");
    private static final boolean logThreadCpuTime = SpeedTracerLogger.getBooleanProperty("gwt.speedtracer.logThreadCpuTime");
    private static final boolean logGcTime = SpeedTracerLogger.getBooleanProperty("gwt.speedtracer.logGcTime");
    private static final boolean logOverheadTime = SpeedTracerLogger.getBooleanProperty("gwt.speedtracer.logOverheadTime");
    private static final boolean jsniCallLoggingEnabled;
    private final boolean enabled;
    private final DummyEvent dummyEvent = new DummyEvent();
    private BlockingQueue<Event> eventsToWrite;
    private final boolean fileLoggingEnabled;
    private CountDownLatch flushLatch;
    private Event flushSentinel;
    private Format outputFormat;
    private ThreadLocal<Stack<Event>> pendingEvents;
    private CountDownLatch shutDownLatch;
    private Event shutDownSentinel;
    private List<GarbageCollectorMXBean> gcMXBeans;
    private Map<String, Long> lastGcTimes;
    private final ElapsedNormalizedTimeKeeper elapsedTimeKeeper = new ElapsedNormalizedTimeKeeper();
    private final ProcessNormalizedTimeKeeper processCpuTimeKeeper = logProcessCpuTime ? new ProcessNormalizedTimeKeeper() : null;
    private final ThreadNormalizedTimeKeeper threadCpuTimeKeeper = logThreadCpuTime ? new ThreadNormalizedTimeKeeper() : null;
    private final long baseTimeMillis = System.currentTimeMillis();

    public static void init() {
        SpeedTracerLogger.get();
    }

    public static boolean jsniCallLoggingEnabled() {
        return jsniCallLoggingEnabled;
    }

    public static Event start(EventType type, String ... data) {
        return SpeedTracerLogger.get().startImpl(DevModeSession.getSessionForCurrentThread(), type, data);
    }

    public static Event start(DevModeSession session, EventType type, String ... data) {
        return SpeedTracerLogger.get().startImpl(session, type, data);
    }

    private static double convertToMilliseconds(long nanos) {
        return (double)nanos / 1000000.0;
    }

    private static SpeedTracerLogger get() {
        return LazySpeedTracerLoggerHolder.singleton;
    }

    private static boolean getBooleanProperty(String propName) {
        try {
            return System.getProperty(propName) != null;
        }
        catch (RuntimeException ruEx) {
            return false;
        }
    }

    SpeedTracerLogger(Writer writer, Format format) {
        this.enabled = true;
        this.fileLoggingEnabled = true;
        this.outputFormat = format;
        this.eventsToWrite = this.openLogWriter(writer, "");
        this.pendingEvents = this.initPendingEvents();
        this.shutDownSentinel = new DummyEvent();
        this.flushSentinel = new DummyEvent();
        this.shutDownLatch = new CountDownLatch(1);
    }

    private SpeedTracerLogger() {
        this.fileLoggingEnabled = logFile != null;
        boolean bl = this.enabled = this.fileLoggingEnabled || DashboardNotifierFactory.areNotificationsEnabled();
        if (this.enabled) {
            System.err.println("SpeedTracerLogging is deprecated, and may be removed in a future release. Please see https://github.com/gwtproject/gwt/issues/10007 for more information.");
            if (this.fileLoggingEnabled) {
                Format format = Format.HTML;
                if (defaultFormatString != null) {
                    for (Format value : Format.values()) {
                        if (!value.name().equalsIgnoreCase(defaultFormatString)) continue;
                        format = value;
                        break;
                    }
                }
                this.outputFormat = format;
                this.eventsToWrite = this.openDefaultLogWriter();
                this.shutDownSentinel = new DummyEvent();
                this.flushSentinel = new DummyEvent();
                this.shutDownLatch = new CountDownLatch(1);
            }
            if (logGcTime) {
                this.gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
                this.lastGcTimes = new ConcurrentHashMap<String, Long>();
            }
            this.pendingEvents = this.initPendingEvents();
        }
    }

    public void addDataImpl(String ... data) {
        Stack<Event> threadPendingEvents = this.pendingEvents.get();
        if (threadPendingEvents.isEmpty()) {
            throw new IllegalStateException("Tried to add data to an event that never started!");
        }
        Event currentEvent = threadPendingEvents.peek();
        currentEvent.addData(data);
    }

    public void markTimelineImpl(String message) {
        Stack<Event> threadPendingEvents = this.pendingEvents.get();
        Event parent = null;
        if (!threadPendingEvents.isEmpty()) {
            parent = threadPendingEvents.peek();
        }
        MarkTimelineEvent newEvent = new MarkTimelineEvent(parent);
        threadPendingEvents.push(newEvent);
        newEvent.end("message", message);
    }

    void addGcEvents(Event refEvent) {
        if (!this.fileLoggingEnabled) {
            return;
        }
        for (GarbageCollectorMXBean gcMXBean : this.gcMXBeans) {
            String gcName = gcMXBean.getName();
            Long lastGcTime = this.lastGcTimes.get(gcName);
            long currGcTime = gcMXBean.getCollectionTime();
            if (lastGcTime == null) {
                lastGcTime = 0L;
            }
            if (currGcTime <= lastGcTime) continue;
            long gcDurationNanos = (currGcTime - lastGcTime) * 1000000L;
            GcEvent gcEvent = new GcEvent(refEvent, gcName, gcMXBean.getCollectionCount(), gcDurationNanos);
            this.eventsToWrite.add(gcEvent);
            this.lastGcTimes.put(gcName, currGcTime);
        }
    }

    void addOverheadEvent(Event refEvent) {
        Event overheadEvent = new Event(refEvent.devModeSession, refEvent, SpeedTracerEventType.OVERHEAD, new String[0]);
        overheadEvent.setStartsAfter(refEvent);
        overheadEvent.updateDuration();
        refEvent.extendDuration(overheadEvent);
    }

    void endImpl(Event event, String ... data) {
        if (!this.enabled) {
            return;
        }
        if (data.length % 2 == 1) {
            throw new IllegalArgumentException("Unmatched data argument");
        }
        Stack<Event> threadPendingEvents = this.pendingEvents.get();
        if (threadPendingEvents.isEmpty()) {
            throw new IllegalStateException("Tried to end an event that never started!");
        }
        Event currentEvent = threadPendingEvents.pop();
        currentEvent.updateDuration();
        while (currentEvent != event && !threadPendingEvents.isEmpty()) {
            currentEvent.addData("Missed", "This event was closed without an explicit call to Event.end()");
            currentEvent = threadPendingEvents.pop();
            currentEvent.updateDuration();
        }
        if (threadPendingEvents.isEmpty() && currentEvent != event) {
            currentEvent.addData("Missed", "Fell off the end of the threadPending events");
        }
        if (logGcTime) {
            this.addGcEvents(currentEvent);
        }
        currentEvent.addData(data);
        if (logOverheadTime) {
            this.addOverheadEvent(currentEvent);
        }
        if (threadPendingEvents.isEmpty()) {
            if (this.fileLoggingEnabled) {
                this.eventsToWrite.add(currentEvent);
            }
            DashboardNotifierFactory.getNotifier().devModeEventEnd(currentEvent.getDevModeSession(), currentEvent.getType().getName(), currentEvent.getElapsedStartTimeNanos(), currentEvent.getElapsedDurationNanos());
        }
    }

    void flush() {
        if (!this.fileLoggingEnabled) {
            return;
        }
        try {
            this.flushLatch = new CountDownLatch(1);
            this.eventsToWrite.add(this.flushSentinel);
            this.flushLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Event startImpl(DevModeSession session, EventType type, String ... data) {
        if (!this.enabled) {
            return this.dummyEvent;
        }
        if (data.length % 2 == 1) {
            throw new IllegalArgumentException("Unmatched data argument");
        }
        Stack<Event> threadPendingEvents = this.pendingEvents.get();
        Event parent = null;
        if (!threadPendingEvents.isEmpty()) {
            parent = threadPendingEvents.peek();
        } else {
            DashboardNotifierFactory.getNotifier().devModeEventBegin();
            if (logThreadCpuTime) {
                this.threadCpuTimeKeeper.resetTimeBase();
            }
        }
        Event newEvent = new Event(session, parent, type, data);
        if (threadPendingEvents.size() == 0) {
            newEvent.addData("baseTime", "" + this.baseTimeMillis);
        }
        threadPendingEvents.push(newEvent);
        return newEvent;
    }

    private ThreadLocal<Stack<Event>> initPendingEvents() {
        return new ThreadLocal<Stack<Event>>(){

            @Override
            protected Stack<Event> initialValue() {
                return new Stack<Event>();
            }
        };
    }

    private BlockingQueue<Event> openDefaultLogWriter() {
        BufferedWriter writer = null;
        if (this.enabled) {
            try {
                writer = new BufferedWriter(new FileWriter(logFile));
                return this.openLogWriter(writer, logFile);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Unable to open gwt.speedtracerlog '" + logFile + "'", e);
            }
        }
        return null;
    }

    private BlockingQueue<Event> openLogWriter(Writer writer, String fileName) {
        try {
            if (this.outputFormat.equals((Object)Format.HTML)) {
                writer.write("<HTML isdump=\"true\"><body><style>body {font-family:Helvetica; margin-left:15px;}</style><h2>Performance dump from GWT</h2><div>This file contains data that can be viewed with the <a href=\"http://code.google.com/speedtracer\">SpeedTracer</a> extension under the <a href=\"http://chrome.google.com/\">Chrome</a> browser.</div><p><span id=\"info\">(You must install the SpeedTracer extension to open this file)</span></p><div style=\"display: none\" id=\"traceData\" version=\"0.17\">\n");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Unable to write to gwt.speedtracerlog '" + (fileName == null ? "" : fileName) + "'", e);
            return null;
        }
        final LinkedBlockingQueue<Event> eventQueue = new LinkedBlockingQueue<Event>();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    eventQueue.add(SpeedTracerLogger.this.shutDownSentinel);
                    SpeedTracerLogger.this.shutDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        LogWriterThread logWriterWorker = new LogWriterThread(writer, fileName, eventQueue);
        logWriterWorker.setPriority(3);
        logWriterWorker.setDaemon(true);
        logWriterWorker.setName("SpeedTracerLogger writer");
        logWriterWorker.start();
        return eventQueue;
    }

    static {
        boolean bl = jsniCallLoggingEnabled = !SpeedTracerLogger.getBooleanProperty("gwt.speedtracer.disableJsniLogging");
        if (logProcessCpuTime && logThreadCpuTime) {
            throw new RuntimeException("System properties are misconfigured: Specify one or the other of 'gwt.speedtracer.logProcessCpuTime' or 'gwt.speedtracer.logThreadCpuTime', not both.");
        }
    }

    private class MarkTimelineEvent
    extends Event {
        public MarkTimelineEvent(Event parent) {
            if (parent != null) {
                parent.children = Lists.add(parent.children, this);
            }
        }

        @Override
        JsonObject toJson() {
            JsonObject json = JsonObject.create();
            json.put("type", 11L);
            double startMs = SpeedTracerLogger.convertToMilliseconds(this.getStartTimeNanos());
            json.put("time", startMs);
            json.put("duration", 0.0);
            JsonObject jsonData = JsonObject.create();
            for (int i = 0; i < this.data.size(); i += 2) {
                jsonData.put((String)this.data.get(i), (String)this.data.get(i + 1));
            }
            json.put("data", jsonData);
            return json;
        }
    }

    private class LogWriterThread
    extends Thread {
        private static final int FLUSH_TIMER_MSECS = 10000;
        private final String fileName;
        private final BlockingQueue<Event> threadEventQueue;
        private final Writer writer;

        public LogWriterThread(Writer writer, String fileName, BlockingQueue<Event> eventQueue) {
            this.writer = writer;
            this.fileName = fileName;
            this.threadEventQueue = eventQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long nextFlush = System.currentTimeMillis() + 10000L;
            try {
                while (true) {
                    Event event;
                    if ((event = this.threadEventQueue.poll(nextFlush - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) != null) {
                        if (event == SpeedTracerLogger.this.shutDownSentinel) break;
                        if (event == SpeedTracerLogger.this.flushSentinel) {
                            this.writer.flush();
                            SpeedTracerLogger.this.flushLatch.countDown();
                        } else {
                            JsonObject json = event.toJson();
                            json.write(this.writer);
                            this.writer.write(10);
                        }
                    }
                    if (System.currentTimeMillis() < nextFlush) continue;
                    this.writer.flush();
                    nextFlush = System.currentTimeMillis() + 10000L;
                }
                if (SpeedTracerLogger.this.outputFormat.equals((Object)Format.HTML)) {
                    this.writer.write("</div></body></html>\n");
                }
                this.writer.close();
            }
            catch (InterruptedException event) {
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Unable to write to gwt.speedtracerlog '" + (this.fileName == null ? "" : this.fileName) + "'", e);
            }
            finally {
                SpeedTracerLogger.this.shutDownLatch.countDown();
            }
        }
    }

    private static class LazySpeedTracerLoggerHolder {
        public static SpeedTracerLogger singleton = new SpeedTracerLogger();

        private LazySpeedTracerLoggerHolder() {
        }
    }

    private class ThreadNormalizedTimeKeeper {
        private final ThreadMXBean threadMXBean;
        private final ThreadLocal<Long> resettableTimeBase = new ThreadLocal();
        private final long zeroTimeNanos;

        public ThreadNormalizedTimeKeeper() {
            this.threadMXBean = ManagementFactory.getThreadMXBean();
            if (!this.threadMXBean.isCurrentThreadCpuTimeSupported()) {
                throw new RuntimeException("Current thread cpu time not supported");
            }
            this.zeroTimeNanos = System.nanoTime();
        }

        public long normalizedTimeNanos() {
            return this.threadMXBean.getCurrentThreadCpuTime() + this.resettableTimeBase.get();
        }

        public void resetTimeBase() {
            this.resettableTimeBase.set(System.nanoTime() - this.zeroTimeNanos - this.threadMXBean.getCurrentThreadCpuTime());
        }
    }

    private class ProcessNormalizedTimeKeeper {
        private final OperatingSystemMXBean osMXBean;
        private final Method getProcessCpuTimeMethod;
        private final long zeroTimeNanos;

        public ProcessNormalizedTimeKeeper() {
            try {
                this.osMXBean = ManagementFactory.getOperatingSystemMXBean();
                this.getProcessCpuTimeMethod = this.osMXBean.getClass().getMethod("getProcessCpuTime", new Class[0]);
                this.getProcessCpuTimeMethod.setAccessible(true);
                this.zeroTimeNanos = (Long)this.getProcessCpuTimeMethod.invoke((Object)this.osMXBean, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public long normalizedTimeNanos() {
            try {
                return (Long)this.getProcessCpuTimeMethod.invoke((Object)this.osMXBean, new Object[0]) - this.zeroTimeNanos;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private class ElapsedNormalizedTimeKeeper {
        private final long zeroTimeNanos = System.nanoTime();

        public long normalizedTimeNanos() {
            return System.nanoTime() - this.zeroTimeNanos;
        }
    }

    private class GcEvent
    extends Event {
        private Event refEvent;

        GcEvent(Event refEvent, String gcType, long collectionCount, long durationNanos) {
            super(null, null, SpeedTracerEventType.GC, "Collector Type", gcType, "Cumulative Collection Count", Long.toString(collectionCount));
            this.refEvent = refEvent;
            this.elapsedDurationNanos = durationNanos;
        }

        @Override
        public long getDurationNanos() {
            return this.getElapsedDurationNanos();
        }

        @Override
        public long getElapsedStartTimeNanos() {
            return this.refEvent.getElapsedStartTimeNanos() + this.refEvent.getElapsedDurationNanos() - this.getElapsedDurationNanos();
        }

        @Override
        public long getStartTimeNanos() {
            return this.refEvent.getStartTimeNanos() + this.refEvent.getDurationNanos() - this.getDurationNanos();
        }
    }

    private class DummyEvent
    extends Event {
        private DummyEvent() {
        }

        @Override
        public void addData(String ... data) {
        }

        @Override
        public void end(String ... data) {
        }

        @Override
        public String toString() {
            return "Dummy";
        }
    }

    static enum Format {
        HTML,
        RAW;

    }

    public static interface EventType {
        public String getColor();

        public String getName();
    }

    public class Event {
        protected final EventType type;
        List<Event> children;
        List<String> data;
        DevModeSession devModeSession;
        long elapsedDurationNanos;
        long elapsedStartTimeNanos;
        long processCpuDurationNanos;
        long processCpuStartTimeNanos;
        long threadCpuDurationNanos;
        long threadCpuStartTimeNanos;

        Event() {
            if (SpeedTracerLogger.this.enabled) {
                if (logThreadCpuTime) {
                    SpeedTracerLogger.this.threadCpuTimeKeeper.resetTimeBase();
                }
                this.recordStartTime();
                this.data = Lists.create();
                this.children = Lists.create();
            } else {
                this.processCpuStartTimeNanos = 0L;
                this.threadCpuStartTimeNanos = 0L;
                this.elapsedStartTimeNanos = 0L;
                this.data = null;
                this.children = null;
            }
            this.type = null;
        }

        Event(DevModeSession session, Event parent, EventType type, String ... data) {
            if (parent != null) {
                parent.children = Lists.add(parent.children, this);
            }
            this.type = type;
            assert (data.length % 2 == 0);
            this.recordStartTime();
            this.data = Lists.create(data);
            this.children = Lists.create();
            this.devModeSession = session;
        }

        public void addData(String ... data) {
            if (data != null) {
                assert (data.length % 2 == 0);
                this.data = Lists.addAll(this.data, data);
            }
        }

        public void end(String ... data) {
            SpeedTracerLogger.this.endImpl(this, data);
        }

        public DevModeSession getDevModeSession() {
            return this.devModeSession;
        }

        public long getDurationNanos() {
            return logProcessCpuTime ? this.processCpuDurationNanos : (logThreadCpuTime ? this.threadCpuDurationNanos : this.elapsedDurationNanos);
        }

        public long getElapsedDurationNanos() {
            return this.elapsedDurationNanos;
        }

        public long getElapsedStartTimeNanos() {
            return this.elapsedStartTimeNanos;
        }

        public long getStartTimeNanos() {
            return logProcessCpuTime ? this.processCpuStartTimeNanos : (logThreadCpuTime ? this.threadCpuStartTimeNanos : this.elapsedStartTimeNanos);
        }

        public EventType getType() {
            return this.type;
        }

        public String toString() {
            return this.type.getName();
        }

        void extendDuration(Event refEvent) {
            this.elapsedDurationNanos += refEvent.elapsedDurationNanos;
            this.processCpuDurationNanos += refEvent.processCpuDurationNanos;
            this.threadCpuDurationNanos += refEvent.threadCpuDurationNanos;
        }

        void setStartsAfter(Event refEvent) {
            this.elapsedStartTimeNanos = refEvent.elapsedStartTimeNanos + refEvent.elapsedDurationNanos;
            this.processCpuStartTimeNanos = refEvent.processCpuStartTimeNanos + refEvent.processCpuDurationNanos;
            this.threadCpuStartTimeNanos = refEvent.threadCpuStartTimeNanos + refEvent.threadCpuDurationNanos;
        }

        JsonObject toJson() {
            JsonObject json = JsonObject.create();
            json.put("type", -2L);
            json.put("typeName", this.type.getName());
            json.put("color", this.type.getColor());
            double startMs = SpeedTracerLogger.convertToMilliseconds(this.getStartTimeNanos());
            json.put("time", startMs);
            double durationMs = SpeedTracerLogger.convertToMilliseconds(this.getDurationNanos());
            json.put("duration", durationMs);
            JsonObject jsonData = JsonObject.create();
            for (int i = 0; i < this.data.size(); i += 2) {
                jsonData.put(this.data.get(i), this.data.get(i + 1));
            }
            json.put("data", jsonData);
            JsonArray jsonChildren = JsonArray.create();
            for (Event child : this.children) {
                jsonChildren.add(child.toJson());
            }
            json.put("children", jsonChildren);
            return json;
        }

        void updateDuration() {
            long elapsedEndTimeNanos = SpeedTracerLogger.this.elapsedTimeKeeper.normalizedTimeNanos();
            assert (elapsedEndTimeNanos >= this.elapsedStartTimeNanos);
            this.elapsedDurationNanos = elapsedEndTimeNanos - this.elapsedStartTimeNanos;
            if (logProcessCpuTime) {
                long processCpuEndTimeNanos = SpeedTracerLogger.this.processCpuTimeKeeper.normalizedTimeNanos();
                assert (processCpuEndTimeNanos >= this.processCpuStartTimeNanos);
                this.processCpuDurationNanos = processCpuEndTimeNanos - this.processCpuStartTimeNanos;
            } else if (logThreadCpuTime) {
                long threadCpuEndTimeNanos = SpeedTracerLogger.this.threadCpuTimeKeeper.normalizedTimeNanos();
                assert (threadCpuEndTimeNanos >= this.threadCpuStartTimeNanos);
                this.threadCpuDurationNanos = threadCpuEndTimeNanos - this.threadCpuStartTimeNanos;
            }
        }

        private void recordStartTime() {
            this.elapsedStartTimeNanos = SpeedTracerLogger.this.elapsedTimeKeeper.normalizedTimeNanos();
            if (logProcessCpuTime) {
                this.processCpuStartTimeNanos = SpeedTracerLogger.this.processCpuTimeKeeper.normalizedTimeNanos();
            } else if (logThreadCpuTime) {
                this.threadCpuStartTimeNanos = SpeedTracerLogger.this.threadCpuTimeKeeper.normalizedTimeNanos();
            }
        }
    }
}

