/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.log.dashboard;

import com.google.gwt.dev.util.log.dashboard.DashboardNotifier;
import com.google.gwt.dev.util.log.dashboard.NoOpDashboardNotifier;

public class DashboardNotifierFactory {
    private static final NoOpDashboardNotifier defaultNotifier = new NoOpDashboardNotifier();
    private static DashboardNotifier theNotifier;

    public static boolean areNotificationsEnabled() {
        return theNotifier != defaultNotifier;
    }

    public static DashboardNotifier getNotifier() {
        return theNotifier;
    }

    static DashboardNotifier createNotifier(String className) {
        DashboardNotifier notifier = null;
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                notifier = (DashboardNotifier)clazz.newInstance();
            }
            catch (Exception e) {
                new Exception("Unexpected failure while trying to load dashboard class: " + className + ". Notifications to the dashboard will be disabled.", e).printStackTrace();
                return null;
            }
        }
        return notifier;
    }

    static void setNotifier(DashboardNotifier notifier) {
        theNotifier = notifier == null ? defaultNotifier : notifier;
    }

    private DashboardNotifierFactory() {
    }

    static {
        DashboardNotifierFactory.setNotifier(DashboardNotifierFactory.createNotifier(System.getProperty("gwt.dashboard.notifierClass")));
    }
}

