/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.log;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.util.log.AbstractTreeLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;

public final class PrintWriterTreeLogger
extends AbstractTreeLogger {
    private final String indent;
    private final PrintWriter out;
    private final Object mutex = new Object();

    public PrintWriterTreeLogger() {
        this(new PrintWriter(System.out, true));
    }

    public PrintWriterTreeLogger(PrintWriter out) {
        this(out, "");
    }

    public PrintWriterTreeLogger(File logFile) throws IOException {
        boolean existing = logFile.exists();
        this.out = new PrintWriter((Writer)new FileWriter(logFile, true), true);
        this.indent = "";
        if (existing) {
            this.out.println();
        }
    }

    protected PrintWriterTreeLogger(PrintWriter out, String indent) {
        this.out = out;
        this.indent = indent;
    }

    @Override
    protected AbstractTreeLogger doBranch() {
        return new PrintWriterTreeLogger(this.out, this.indent + "   ");
    }

    @Override
    protected void doCommitBranch(AbstractTreeLogger childBeingCommitted, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        this.doLog(childBeingCommitted.getBranchedIndex(), type, msg, caught, helpInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doLog(int indexOfLogEntryWithinParentLogger, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        Object object = this.mutex;
        synchronized (object) {
            URL url;
            this.out.print(this.indent);
            if (type.needsAttention()) {
                this.out.print("[");
                this.out.print(type.getLabel());
                this.out.print("] ");
            }
            this.out.println(msg);
            if (helpInfo != null && (url = helpInfo.getURL()) != null) {
                this.out.print(this.indent);
                this.out.println("For additional info see: " + url.toString());
            }
            if (caught != null) {
                caught.printStackTrace(this.out);
            }
        }
    }
}

