/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.log;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.util.log.CanUpdateMetrics;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.regex.Pattern;

public enum MetricName {
    DECLARED_TYPES_IN_MODULE("DeclaredTypesInModule");

    private static final Pattern VALID_KEY;
    final String key;

    private MetricName(String key) {
        this.key = key;
    }

    public void setAmount(TreeLogger logger, long amount) {
        Preconditions.checkNotNull(logger);
        Preconditions.checkArgument(amount >= 0L, "attempted to set a negative amount");
        if (logger instanceof CanUpdateMetrics) {
            ((CanUpdateMetrics)((Object)logger)).setAmount(this, amount);
        } else {
            logger.log(TreeLogger.Type.DEBUG, "Metric: " + this.key + " = " + amount);
        }
    }

    public static boolean isValidKey(String name) {
        return VALID_KEY.matcher(name).matches();
    }

    static {
        VALID_KEY = Pattern.compile("^[A-Z][A-Za-z0-9]*$");
        for (MetricName counter : MetricName.values()) {
            Preconditions.checkState(MetricName.isValidKey(counter.key), "invalid key: %s", (Object)counter.key);
        }
    }
}

