/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.log;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.util.log.CanUpdateMetrics;
import com.google.gwt.dev.util.log.MetricName;

public class CompositeTreeLogger
extends TreeLogger
implements CanUpdateMetrics {
    private TreeLogger[] loggers;

    public CompositeTreeLogger(TreeLogger ... loggers) {
        this.loggers = loggers;
    }

    @Override
    public TreeLogger branch(TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        TreeLogger[] children = new TreeLogger[this.loggers.length];
        for (int i = 0; i < this.loggers.length; ++i) {
            children[i] = this.loggers[i].branch(type, msg, caught, helpInfo);
        }
        return new CompositeTreeLogger(children);
    }

    @Override
    public boolean isLoggable(TreeLogger.Type type) {
        for (TreeLogger logger : this.loggers) {
            if (!logger.isLoggable(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void log(TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        for (TreeLogger logger : this.loggers) {
            logger.log(type, msg, caught, helpInfo);
        }
    }

    @Override
    public void setAmount(MetricName name, long amount) {
        for (TreeLogger logger : this.loggers) {
            name.setAmount(logger, amount);
        }
    }
}

