/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.log;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.log.CanUpdateMetrics;
import com.google.gwt.dev.util.log.MetricMap;
import com.google.gwt.dev.util.log.MetricName;
import com.google.gwt.thirdparty.guava.common.collect.ComparisonChain;
import java.util.Comparator;
import java.util.HashSet;

public abstract class AbstractTreeLogger
extends TreeLogger
implements CanUpdateMetrics {
    public static final Comparator<String> LOG_LINE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String thisLine, String thatLine) {
            return ComparisonChain.start().compare(thisLine.indexOf(58), thatLine.indexOf(58)).compare((Comparable<?>)((Object)thisLine), (Comparable<?>)((Object)thatLine)).result();
        }
    };
    static final String OUT_OF_MEMORY_MSG = "Out of memory; to increase the amount of memory, use the -Xmx flag at startup (java -Xmx128M ...)";
    static final String STACK_OVERFLOW_MSG = "Stack overflow; to increase the stack size, use the -Xss flag at startup (java -Xss1M ...)";
    protected TreeLogger.Type logLevel = TreeLogger.ALL;
    protected AbstractTreeLogger parent;
    private int indexWithinMyParent;
    private int nextChildIndex;
    private final Object nextChildIndexLock = new Object();
    private UncommittedBranchData uncommitted;
    private volatile MetricMap metricMap = new MetricMap();

    public static String getStackTraceAsString(Throwable e) {
        if (e == null || e instanceof UnableToCompleteException) {
            return null;
        }
        StringBuffer message = new StringBuffer();
        String causedBy = "";
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        for (Throwable currentCause = e; currentCause != null && !seenCauses.contains(currentCause); currentCause = currentCause.getCause()) {
            seenCauses.add(currentCause);
            message.append(causedBy);
            causedBy = "\nCaused by: ";
            message.append(currentCause.getClass().getName());
            message.append(": " + currentCause.getMessage());
            StackTraceElement[] stackElems = currentCause.getStackTrace();
            if (stackElems == null) continue;
            for (int i = 0; i < stackElems.length; ++i) {
                message.append("\n\tat ");
                message.append(stackElems[i].toString());
            }
        }
        return message.toString();
    }

    protected static String getExceptionName(Throwable e) {
        if (e == null || e instanceof UnableToCompleteException) {
            return null;
        }
        return e.getClass().getSimpleName();
    }

    protected AbstractTreeLogger() {
    }

    @Override
    public final synchronized TreeLogger branch(TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        if (msg == null) {
            msg = "(Null branch message)";
        }
        int childIndex = this.allocateNextChildIndex();
        AbstractTreeLogger childLogger = this.doBranch();
        childLogger.logLevel = this.logLevel;
        childLogger.indexWithinMyParent = childIndex;
        childLogger.parent = this;
        childLogger.uncommitted = new UncommittedBranchData(type, msg, caught, helpInfo);
        childLogger.metricMap = this.metricMap;
        String specialErrorMessage = this.causedBySpecialError(caught);
        if (specialErrorMessage != null) {
            type = TreeLogger.ERROR;
            childLogger.log(type, specialErrorMessage, null);
        }
        if (this.isLoggable(type)) {
            childLogger.commitMyBranchEntryInMyParentLogger();
        }
        return childLogger;
    }

    public void resetMetricMap() {
        this.metricMap = new MetricMap();
    }

    public final int getBranchedIndex() {
        return this.indexWithinMyParent;
    }

    public MetricMap getMetricMap() {
        return this.metricMap;
    }

    public final synchronized TreeLogger.Type getMaxDetail() {
        return this.logLevel;
    }

    public final AbstractTreeLogger getParentLogger() {
        return this.parent;
    }

    @Override
    public final synchronized boolean isLoggable(TreeLogger.Type type) {
        return !type.isLowerPriorityThan(this.logLevel);
    }

    @Override
    public final synchronized void log(TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        if (msg == null) {
            msg = "(Null log message)";
        }
        if (this.causedBySpecialError(caught) != null) {
            this.branch(TreeLogger.ERROR, msg, caught);
            return;
        }
        int childIndex = this.allocateNextChildIndex();
        if (this.isLoggable(type)) {
            this.commitMyBranchEntryInMyParentLogger();
            this.doLog(childIndex, type, msg, caught, helpInfo);
        }
    }

    public final synchronized void setMaxDetail(TreeLogger.Type type) {
        if (type == null) {
            type = TreeLogger.INFO;
        }
        this.logLevel = type;
    }

    public String toString() {
        return this.getLoggerId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int allocateNextChildIndex() {
        Object object = this.nextChildIndexLock;
        synchronized (object) {
            return this.nextChildIndex++;
        }
    }

    protected synchronized void commitMyBranchEntryInMyParentLogger() {
        if (this.parent != null && this.uncommitted != null) {
            this.parent.commitMyBranchEntryInMyParentLogger();
            this.parent.doCommitBranch(this, this.uncommitted.type, this.uncommitted.message, this.uncommitted.caught, this.uncommitted.helpInfo);
            this.uncommitted = null;
        }
    }

    protected abstract AbstractTreeLogger doBranch();

    protected abstract void doCommitBranch(AbstractTreeLogger var1, TreeLogger.Type var2, String var3, Throwable var4, TreeLogger.HelpInfo var5);

    protected abstract void doLog(int var1, TreeLogger.Type var2, String var3, Throwable var4, TreeLogger.HelpInfo var5);

    @Override
    public void setAmount(MetricName name, long amount) {
        this.metricMap.setAmount(name, amount);
    }

    private String causedBySpecialError(Throwable t) {
        while (t != null) {
            if (t instanceof OutOfMemoryError) {
                return OUT_OF_MEMORY_MSG;
            }
            if (t instanceof StackOverflowError) {
                return STACK_OVERFLOW_MSG;
            }
            t = t.getCause();
        }
        return null;
    }

    private String getLoggerId() {
        if (this.parent != null) {
            if (this.parent.parent == null) {
                return this.parent.getLoggerId() + this.getBranchedIndex();
            }
            return this.parent.getLoggerId() + "." + this.getBranchedIndex();
        }
        return "#";
    }

    private static class UncommittedBranchData {
        public final Throwable caught;
        public final String message;
        public final TreeLogger.Type type;
        private final TreeLogger.HelpInfo helpInfo;

        public UncommittedBranchData(TreeLogger.Type type, String message, Throwable caught, TreeLogger.HelpInfo helpInfo) {
            this.caught = caught;
            this.message = message;
            this.type = type;
            this.helpInfo = helpInfo;
        }
    }
}

