/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.editdistance;

import com.google.gwt.dev.util.editdistance.CharIndex;
import java.util.Arrays;

public class PatternBitmap {
    public static int[] map(CharSequence s, CharIndex idx, int[] result) {
        int len = s.length();
        assert (len <= 32);
        for (int i = 0; i < len; ++i) {
            int n = idx.lookup(s.charAt(i));
            result[n] = result[n] | 1 << i;
        }
        return result;
    }

    public static int[][] map(CharSequence s, CharIndex idx, int[][] result, int width) {
        assert (width <= 32);
        int len = s.length();
        int rowSize = (len + width - 1) / width;
        int[] nullElement = new int[rowSize];
        Arrays.fill((Object[])result, nullElement);
        int wordIndex = 0;
        int bitWithinWord = 0;
        for (int i = 0; i < s.length(); ++i) {
            int[] r = result[idx.lookup(s.charAt(i))];
            if (r == nullElement) {
                int[] nArray = new int[rowSize];
                result[idx.lookup((char)s.charAt((int)i))] = nArray;
                r = nArray;
            }
            int n = wordIndex++;
            r[n] = r[n] | 1 << bitWithinWord;
            if (++bitWithinWord != width) continue;
            bitWithinWord = 0;
        }
        return result;
    }

    public static long[] map(CharSequence s, CharIndex idx, long[] result) {
        int len = s.length();
        assert (len <= 64);
        for (int i = 0; i < len; ++i) {
            int n = idx.lookup(s.charAt(i));
            result[n] = result[n] | 1L << i;
        }
        return result;
    }

    private PatternBitmap() {
    }
}

