/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.editdistance;

import com.google.gwt.dev.util.editdistance.CharIndex;
import com.google.gwt.dev.util.editdistance.GeneralEditDistance;
import com.google.gwt.dev.util.editdistance.PatternBitmap;
import java.util.Arrays;

public abstract class MyersBitParallelEditDistance
implements GeneralEditDistance,
Cloneable {
    final CharIndex idx;
    int[] indices = new int[0];
    final int m;

    public static MyersBitParallelEditDistance getInstance(CharSequence s) {
        int m = s.length();
        return m <= 32 ? (m == 0 ? new Empty(s) : new TYPEint(s)) : (s.length() <= 64 ? new TYPElong(s) : new Multi(s));
    }

    public static void main(String[] args) {
        MyersBitParallelEditDistance b = MyersBitParallelEditDistance.getInstance(args[0]);
        int k = args.length > 2 ? Integer.parseInt(args[2]) : 0;
        System.out.println("Result: " + b.getDistance(args[1], k));
    }

    protected MyersBitParallelEditDistance(CharSequence s) {
        this.m = s.length();
        this.idx = CharIndex.getInstance(s);
    }

    @Override
    public GeneralEditDistance duplicate() {
        try {
            return (MyersBitParallelEditDistance)this.clone();
        }
        catch (CloneNotSupportedException x) {
            throw new IllegalStateException("Cloneable object would not clone");
        }
    }

    @Override
    public abstract int getDistance(CharSequence var1, int var2);

    protected Object clone() throws CloneNotSupportedException {
        Object obj = super.clone();
        ((MyersBitParallelEditDistance)obj).perThreadInit();
        return obj;
    }

    protected void perThreadInit() {
        this.indices = new int[0];
    }

    static class TYPElong
    extends MyersBitParallelEditDistance {
        final long lastBitPosition;
        final long[] map;

        TYPElong(CharSequence s) {
            super(s);
            this.map = PatternBitmap.map(s, this.idx, new long[this.idx.size()]);
            this.lastBitPosition = 1L << this.m - 1;
        }

        @Override
        public int getDistance(CharSequence s, int k) {
            int len = s.length();
            if (len - this.m > k || this.m - len > k) {
                return k + 1;
            }
            this.indices = this.idx.map(s, this.indices);
            long verticalPositive = -1L;
            long verticalNegative = 0L;
            int distance = this.m;
            int maxMisses = k + len - this.m;
            if (maxMisses < 0) {
                maxMisses = Integer.MAX_VALUE;
            }
            for (int j = 0; j < len; ++j) {
                long diagonalZero = this.map[this.indices[j]] | verticalNegative;
                diagonalZero |= (diagonalZero & verticalPositive) + verticalPositive ^ verticalPositive;
                long horizontalPositive = verticalNegative | (diagonalZero | verticalPositive) ^ 0xFFFFFFFFFFFFFFFFL;
                long horizontalNegative = diagonalZero & verticalPositive;
                if ((horizontalNegative & this.lastBitPosition) != 0L) {
                    --distance;
                } else if ((horizontalPositive & this.lastBitPosition) != 0L) {
                    ++distance;
                    if ((maxMisses -= 2) < 0) {
                        break;
                    }
                } else if (--maxMisses < 0) break;
                horizontalPositive = horizontalPositive << 1 | 1L;
                verticalPositive = horizontalNegative << 1 | (diagonalZero | horizontalPositive) ^ 0xFFFFFFFFFFFFFFFFL;
                verticalNegative = diagonalZero & horizontalPositive;
            }
            return distance;
        }
    }

    static class TYPEint
    extends MyersBitParallelEditDistance {
        final int lastBitPosition;
        final int[] map;

        TYPEint(CharSequence s) {
            super(s);
            this.map = PatternBitmap.map(s, this.idx, new int[this.idx.size()]);
            this.lastBitPosition = 1 << this.m - 1;
        }

        @Override
        public int getDistance(CharSequence s, int k) {
            int len = s.length();
            if (len - this.m > k || this.m - len > k) {
                return k + 1;
            }
            this.indices = this.idx.map(s, this.indices);
            int verticalPositive = -1;
            int verticalNegative = 0;
            int distance = this.m;
            int maxMisses = k + len - this.m;
            if (maxMisses < 0) {
                maxMisses = Integer.MAX_VALUE;
            }
            for (int j = 0; j < len; ++j) {
                int diagonalZero = this.map[this.indices[j]] | verticalNegative;
                diagonalZero |= (diagonalZero & verticalPositive) + verticalPositive ^ verticalPositive;
                int horizontalPositive = verticalNegative | ~(diagonalZero | verticalPositive);
                int horizontalNegative = diagonalZero & verticalPositive;
                if ((horizontalNegative & this.lastBitPosition) != 0) {
                    --distance;
                } else if ((horizontalPositive & this.lastBitPosition) != 0) {
                    ++distance;
                    if ((maxMisses -= 2) < 0) {
                        break;
                    }
                } else if (--maxMisses < 0) break;
                horizontalPositive = horizontalPositive << 1 | 1;
                verticalPositive = horizontalNegative << 1 | ~(diagonalZero | horizontalPositive);
                verticalNegative = diagonalZero & horizontalPositive;
            }
            return distance;
        }
    }

    static class Multi
    extends MyersBitParallelEditDistance {
        int count;
        final int lastBitPosition;
        final int[][] positions;
        int[] verticalNegativesReusable;
        int[] verticalPositivesReusable;
        final int wordMask = Integer.MAX_VALUE;
        final int wordSize = 31;

        Multi(CharSequence s) {
            super(s);
            this.count = (this.m + 31 - 1) / 31;
            this.positions = PatternBitmap.map(s, this.idx, new int[this.idx.size()][], 31);
            this.lastBitPosition = 1 << (this.m - 1) % 31;
            this.perThreadInit();
        }

        @Override
        public int getDistance(CharSequence s, int k) {
            this.indices = this.idx.map(s, this.indices);
            int[] verticalPositives = this.verticalPositivesReusable;
            Arrays.fill(verticalPositives, Integer.MAX_VALUE);
            int[] verticalNegatives = this.verticalNegativesReusable;
            Arrays.fill(verticalNegatives, 0);
            int distance = this.m;
            int len = s.length();
            int maxMisses = k + len - this.m;
            if (maxMisses < 0) {
                maxMisses = Integer.MAX_VALUE;
            }
            block0: for (int j = 0; j < len; ++j) {
                int[] position = this.positions[this.indices[j]];
                int sum = 0;
                int horizontalPositiveShift = 1;
                int horizontalNegativeShift = 0;
                for (int i = 0; i < this.count; ++i) {
                    int verticalNegative = verticalNegatives[i];
                    int patternMatch = position[i] | verticalNegative;
                    int verticalPositive = verticalPositives[i];
                    sum = (verticalPositive & patternMatch) + verticalPositive + (sum >>> 31);
                    int diagonalZero = sum & Integer.MAX_VALUE ^ verticalPositive | patternMatch;
                    int horizontalPositive = verticalNegative | ~(diagonalZero | verticalPositive);
                    int horizontalNegative = diagonalZero & verticalPositive;
                    if (i == this.count - 1) {
                        if ((horizontalNegative & this.lastBitPosition) != 0) {
                            --distance;
                        } else if ((horizontalPositive & this.lastBitPosition) != 0) {
                            ++distance;
                            if ((maxMisses -= 2) < 0) {
                                break block0;
                            }
                        } else if (--maxMisses < 0) break block0;
                    }
                    horizontalPositive = horizontalPositive << 1 | horizontalPositiveShift;
                    horizontalPositiveShift = horizontalPositive >>> 31;
                    horizontalNegative = horizontalNegative << 1 | horizontalNegativeShift;
                    horizontalNegativeShift = horizontalNegative >>> 31;
                    verticalPositives[i] = (horizontalNegative | ~(diagonalZero | horizontalPositive)) & Integer.MAX_VALUE;
                    verticalNegatives[i] = diagonalZero & horizontalPositive & Integer.MAX_VALUE;
                }
            }
            return distance;
        }

        @Override
        protected void perThreadInit() {
            super.perThreadInit();
            this.verticalPositivesReusable = new int[this.count];
            this.verticalNegativesReusable = new int[this.count];
        }
    }

    static class Empty
    extends MyersBitParallelEditDistance {
        Empty(CharSequence s) {
            super(s);
        }

        @Override
        public GeneralEditDistance duplicate() {
            return this;
        }

        @Override
        public int getDistance(CharSequence s, int k) {
            return s.length();
        }
    }
}

