/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.editdistance;

import com.google.gwt.dev.util.editdistance.GeneralEditDistance;

public class ModifiedBerghelRoachEditDistance
implements GeneralEditDistance {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] currentLeft = EMPTY_INT_ARRAY;
    private int[] currentRight = EMPTY_INT_ARRAY;
    private int[] lastLeft = EMPTY_INT_ARRAY;
    private int[] lastRight = EMPTY_INT_ARRAY;
    private final char[] pattern;
    private int[] priorLeft = EMPTY_INT_ARRAY;
    private int[] priorRight = EMPTY_INT_ARRAY;

    public static ModifiedBerghelRoachEditDistance getInstance(CharSequence pattern) {
        return ModifiedBerghelRoachEditDistance.getInstance(pattern.toString());
    }

    public static ModifiedBerghelRoachEditDistance getInstance(String pattern) {
        return new ModifiedBerghelRoachEditDistance(pattern.toCharArray());
    }

    private ModifiedBerghelRoachEditDistance(char[] pattern) {
        this.pattern = pattern;
    }

    @Override
    public ModifiedBerghelRoachEditDistance duplicate() {
        return new ModifiedBerghelRoachEditDistance(this.pattern);
    }

    @Override
    public int getDistance(CharSequence targetSequence, int limit) {
        int j;
        int targetLength = targetSequence.length();
        int main = this.pattern.length - targetLength;
        int distance = Math.abs(main);
        if (distance > limit) {
            return Integer.MAX_VALUE;
        }
        char[] target = new char[targetLength];
        for (int i = 0; i < targetLength; ++i) {
            target[i] = targetSequence.charAt(i);
        }
        if (main <= 0) {
            this.ensureCapacityRight(distance, false);
            for (j = 0; j <= distance; ++j) {
                this.lastRight[j] = distance - j - 1;
                this.priorRight[j] = -1;
            }
        } else {
            this.ensureCapacityLeft(distance, false);
            for (j = 0; j <= distance; ++j) {
                this.lastLeft[j] = -1;
                this.priorLeft[j] = -1;
            }
        }
        boolean even = true;
        while (true) {
            int immediateLeft;
            int offDiagonal = (distance - main) / 2;
            this.ensureCapacityRight(offDiagonal, true);
            if (even) {
                this.lastRight[offDiagonal] = -1;
            }
            int immediateRight = -1;
            while (offDiagonal > 0) {
                this.currentRight[offDiagonal] = immediateRight = this.computeRow(main + offDiagonal, distance - offDiagonal, this.pattern, target, this.priorRight[offDiagonal - 1], this.lastRight[offDiagonal], immediateRight);
                --offDiagonal;
            }
            offDiagonal = (distance + main) / 2;
            this.ensureCapacityLeft(offDiagonal, true);
            if (even) {
                this.lastLeft[offDiagonal] = (distance - main) / 2 - 1;
            }
            int n = immediateLeft = even ? -1 : (distance - main) / 2;
            while (offDiagonal > 0) {
                this.currentLeft[offDiagonal] = immediateLeft = this.computeRow(main - offDiagonal, distance - offDiagonal, this.pattern, target, immediateLeft, this.lastLeft[offDiagonal], this.priorLeft[offDiagonal - 1]);
                --offDiagonal;
            }
            int mainRow = this.computeRow(main, distance, this.pattern, target, immediateLeft, this.lastLeft[0], immediateRight);
            if (mainRow == targetLength || ++distance > limit || distance < 0) break;
            this.currentLeft[0] = this.currentRight[0] = mainRow;
            int[] tmp = this.priorLeft;
            this.priorLeft = this.lastLeft;
            this.lastLeft = this.currentLeft;
            this.currentLeft = this.priorLeft;
            tmp = this.priorRight;
            this.priorRight = this.lastRight;
            this.lastRight = this.currentRight;
            this.currentRight = tmp;
            even = !even;
        }
        return distance;
    }

    private int computeRow(int k, int p, char[] a, char[] b, int knownLeft, int knownAbove, int knownRight) {
        int t;
        assert (Math.abs(k) <= p);
        assert (p >= 0);
        int tmax = Math.min(b.length, a.length - k);
        for (t = p == 0 ? 0 : Math.max(Math.max(knownAbove, knownRight) + 1, knownLeft); t < tmax && b[t] == a[t + k]; ++t) {
        }
        return t;
    }

    private void ensureCapacityLeft(int index, boolean copy) {
        if (this.currentLeft.length <= index) {
            this.priorLeft = this.resize(this.priorLeft, ++index, copy);
            this.lastLeft = this.resize(this.lastLeft, index, copy);
            this.currentLeft = this.resize(this.currentLeft, index, false);
        }
    }

    private void ensureCapacityRight(int index, boolean copy) {
        if (this.currentRight.length <= index) {
            this.priorRight = this.resize(this.priorRight, ++index, copy);
            this.lastRight = this.resize(this.lastRight, index, copy);
            this.currentRight = this.resize(this.currentRight, index, false);
        }
    }

    private int[] resize(int[] array, int size, boolean copy) {
        int[] result = new int[size];
        if (copy) {
            System.arraycopy(array, 0, result, 0, array.length);
        }
        return result;
    }
}

