/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.editdistance;

import com.google.gwt.dev.util.editdistance.GeneralEditDistance;
import com.google.gwt.dev.util.editdistance.ModifiedBerghelRoachEditDistance;
import com.google.gwt.dev.util.editdistance.MyersBitParallelEditDistance;

public class GeneralEditDistances {
    public static int atMostOneError(CharSequence s1, CharSequence s2) {
        int s1Length = s1.length();
        int s2Length = s2.length();
        int errors = 0;
        switch (s2Length - s1Length) {
            case 0: {
                for (int i = 0; i < s2Length && (s2.charAt(i) == s1.charAt(i) || errors++ == 0); ++i) {
                }
                return errors;
            }
            case 1: {
                for (int i = 0; i < s1Length; ++i) {
                    if (s2.charAt(i) == s1.charAt(i)) continue;
                    while (i < s1Length) {
                        if (s2.charAt(i + 1) != s1.charAt(i)) {
                            return 2;
                        }
                        ++i;
                    }
                    return 1;
                }
                return 1;
            }
            case -1: {
                for (int i = 0; i < s2Length; ++i) {
                    if (s2.charAt(i) == s1.charAt(i)) continue;
                    while (i < s2Length) {
                        if (s2.charAt(i) != s1.charAt(i + 1)) {
                            return 2;
                        }
                        ++i;
                    }
                    return 1;
                }
                return 1;
            }
        }
        return 2;
    }

    public static GeneralEditDistance getLevenshteinDistance(CharSequence pattern) {
        return new Levenshtein(pattern);
    }

    private GeneralEditDistances() {
    }

    private static class Levenshtein
    implements GeneralEditDistance {
        private ModifiedBerghelRoachEditDistance berghel;
        private MyersBitParallelEditDistance myers;
        private final CharSequence pattern;
        private final int patternLength;

        private Levenshtein(CharSequence pattern) {
            this.pattern = pattern;
            this.patternLength = pattern.length();
        }

        @Override
        public GeneralEditDistance duplicate() {
            Levenshtein dup = new Levenshtein(this.pattern);
            if (this.myers != null) {
                dup.myers = (MyersBitParallelEditDistance)this.myers.duplicate();
            }
            return dup;
        }

        @Override
        public int getDistance(CharSequence target, int limit) {
            if (limit <= 1) {
                return limit == 0 ? (this.pattern.equals(target) ? 0 : 1) : GeneralEditDistances.atMostOneError(this.pattern, target);
            }
            if (this.patternLength > 64 && limit < target.length() / 10) {
                if (this.berghel == null) {
                    this.berghel = ModifiedBerghelRoachEditDistance.getInstance(this.pattern);
                }
                return this.berghel.getDistance(target, limit);
            }
            if (this.myers == null) {
                this.myers = MyersBitParallelEditDistance.getInstance(this.pattern);
            }
            return this.myers.getDistance(target, limit);
        }
    }
}

