/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.editdistance;

import java.util.HashMap;

public abstract class CharIndex {
    public static CharIndex getInstance(CharSequence s) {
        CharIndex result = Straight.generate(s);
        if (result != null) {
            return result;
        }
        result = Masked.generate(s);
        if (result != null) {
            return result;
        }
        return new FullHash(s);
    }

    public abstract int lookup(char var1);

    public abstract int[] map(CharSequence var1, int[] var2);

    public abstract int nullElement();

    public abstract int size();

    public static class Straight
    extends CharIndex {
        static final int MAX = 128;
        static final int MASK = -128;
        static final int NULL_ELEMENT = 128;

        static Straight generate(CharSequence s) {
            for (int i = 0; i < s.length(); ++i) {
                if ((s.charAt(i) & 0xFFFFFF80) == 0) continue;
                return null;
            }
            return new Straight();
        }

        private Straight() {
        }

        @Override
        public int lookup(char c) {
            return (c & 0xFFFFFF80) == 0 ? c : 128;
        }

        @Override
        public int[] map(CharSequence s, int[] mapped) {
            int len = s.length();
            if (mapped.length < len) {
                mapped = new int[len];
            }
            for (int i = 0; i < len; ++i) {
                int c = s.charAt(i);
                mapped[i] = (c & 0xFFFFFF80) == 0 ? c : 128;
            }
            return mapped;
        }

        @Override
        public int nullElement() {
            return 128;
        }

        @Override
        public int size() {
            return 129;
        }
    }

    public static class Masked
    extends CharIndex {
        static final int SIZE = 256;
        static final int MASK = 255;
        static final int NULL_ELEMENT = 256;
        final char[] contains;

        static Masked generate(CharSequence s) {
            char[] contains = new char[256];
            contains[0] = '\u0001';
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                int index = c & 0xFF;
                if (contains[index] == c) continue;
                if ((contains[index] & 0xFF) == index) {
                    return null;
                }
                contains[index] = c;
            }
            return new Masked(contains);
        }

        private Masked(char[] contains) {
            this.contains = contains;
        }

        @Override
        public int lookup(char c) {
            int index = c & 0xFF;
            return c == this.contains[index] ? index : 256;
        }

        @Override
        public int[] map(CharSequence s, int[] mapped) {
            int len = s.length();
            if (mapped.length < len) {
                mapped = new int[len];
            }
            for (int i = 0; i < len; ++i) {
                int index;
                char c = s.charAt(i);
                mapped[i] = c == this.contains[index = c & 0xFF] ? index : 256;
            }
            return mapped;
        }

        @Override
        public int nullElement() {
            return 256;
        }

        @Override
        public int size() {
            return 257;
        }
    }

    public static class FullHash
    extends CharIndex {
        static final int NULL_ELEMENT = 0;
        protected int lastUsed = 0;
        final HashMap<Char, Integer> map;

        FullHash(CharSequence s) {
            int len = s.length();
            int power = Integer.highestOneBit(len);
            this.map = new HashMap(power << (power == len ? 1 : 2));
            Char test = new Char();
            for (int i = 0; i < s.length(); ++i) {
                test.c = s.charAt(i);
                if (this.map.get(test) != null) continue;
                this.map.put(test, new Integer(++this.lastUsed));
                test = new Char();
            }
        }

        @Override
        public int lookup(char c) {
            Char lookupTest = new Char();
            lookupTest.c = c;
            Integer result = this.map.get(lookupTest);
            return result != null ? result : 0;
        }

        @Override
        public int[] map(CharSequence s, int[] mapped) {
            Char lookupTest = new Char();
            int len = s.length();
            if (mapped.length < len) {
                mapped = new int[len];
            }
            for (int i = 0; i < len; ++i) {
                lookupTest.c = s.charAt(i);
                Integer result = this.map.get(lookupTest);
                mapped[i] = result != null ? result : 0;
            }
            return mapped;
        }

        @Override
        public int nullElement() {
            return 0;
        }

        @Override
        public int size() {
            return this.lastUsed + 1;
        }

        static class Char {
            char c;

            Char() {
            }

            public boolean equals(Object x) {
                return x != null && ((Char)x).c == this.c;
            }

            public int hashCode() {
                return this.c;
            }

            public String toString() {
                return "'" + this.c + "'";
            }
        }
    }
}

