/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.collect;

import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Stack<T>
implements Iterable<T> {
    private ArrayList<T> elements = Lists.newArrayList();

    public int size() {
        return this.elements.size();
    }

    public boolean contains(T element) {
        return this.elements.contains(element);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    public T peek() {
        return this.elements.get(this.elements.size() - 1);
    }

    public T peekAt(int index) {
        return this.elements.get(index);
    }

    public T pop() {
        return this.elements.remove(this.elements.size() - 1);
    }

    public List<T> pop(int count) {
        int size = this.elements.size();
        List<T> nodesToPop = this.elements.subList(size - count, size);
        ArrayList<T> result = Lists.newArrayList(nodesToPop);
        nodesToPop.clear();
        return result;
    }

    public void push(T value) {
        this.elements.add(value);
    }

    public static <T> Stack<T> create() {
        return new Stack<T>();
    }
}

