/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.collect;

import com.google.gwt.dev.util.collect.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class Sets {
    private static final Class<?> MULTI_SET_CLASS = HashSet.class;
    private static final Class<?> SINGLETON_SET_CLASS = Collections.singleton(null).getClass();

    public static <T> Set<T> add(Set<T> set, T toAdd) {
        switch (set.size()) {
            case 0: {
                return Sets.create(toAdd);
            }
            case 1: {
                if (set.contains(toAdd)) {
                    return set;
                }
                HashSet<T> result = new HashSet<T>();
                result.add(set.iterator().next());
                result.add(toAdd);
                return result;
            }
        }
        set.add(toAdd);
        return set;
    }

    public static <T> Set<T> addAll(Set<T> set, Collection<T> toAdd) {
        switch (toAdd.size()) {
            case 0: {
                return set;
            }
            case 1: {
                return Sets.add(set, toAdd.iterator().next());
            }
        }
        switch (set.size()) {
            case 0: {
                return new HashSet<T>(toAdd);
            }
            case 1: {
                HashSet<T> result = new HashSet<T>();
                result.add(set.iterator().next());
                result.addAll(toAdd);
                return result;
            }
        }
        set.addAll(toAdd);
        return set;
    }

    public static <T> Set<T> create() {
        return Collections.emptySet();
    }

    public static <T> Set<T> create(T item) {
        return Collections.singleton(item);
    }

    public static <T> Set<T> create(T ... items) {
        switch (items.length) {
            case 0: {
                return Sets.create();
            }
            case 1: {
                return Sets.create(items[0]);
            }
        }
        return new HashSet<T>(items);
    }

    public static <T> Set<T> normalize(Set<T> set) {
        switch (set.size()) {
            case 0: {
                return Sets.create();
            }
            case 1: {
                if (set.getClass() == SINGLETON_SET_CLASS) {
                    return set;
                }
                return Sets.create(set.iterator().next());
            }
        }
        if (set.getClass() == MULTI_SET_CLASS) {
            return set;
        }
        HashSet<T> result = new HashSet<T>();
        result.addAll(set);
        return result;
    }
}

