/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.collect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Lists {
    private static final Class<?> MULTI_LIST_CLASS = ArrayList.class;
    private static final Class<?> SINGLETON_LIST_CLASS = Collections.singletonList(null).getClass();

    public static <T> List<T> add(List<T> list, int index, T toAdd) {
        switch (list.size()) {
            case 0: {
                if (index != 0) {
                    throw Lists.newIndexOutOfBounds(list, index);
                }
                return Collections.singletonList(toAdd);
            }
            case 1: {
                ArrayList<T> result = new ArrayList<T>(2);
                switch (index) {
                    case 0: {
                        result.add(toAdd);
                        result.add(list.get(0));
                        return result;
                    }
                    case 1: {
                        result.add(list.get(0));
                        result.add(toAdd);
                        return result;
                    }
                }
                throw Lists.newIndexOutOfBounds(list, index);
            }
        }
        list.add(index, toAdd);
        return list;
    }

    public static <T> List<T> add(List<T> list, T toAdd) {
        switch (list.size()) {
            case 0: {
                return Collections.singletonList(toAdd);
            }
            case 1: {
                ArrayList<T> result = new ArrayList<T>(2);
                result.add(list.get(0));
                result.add(toAdd);
                return result;
            }
        }
        list.add(toAdd);
        return list;
    }

    public static <T> List<T> addAll(List<T> list, List<T> toAdd) {
        switch (toAdd.size()) {
            case 0: {
                return list;
            }
            case 1: {
                return Lists.add(list, toAdd.get(0));
            }
        }
        switch (list.size()) {
            case 0: {
                return new ArrayList<T>(toAdd);
            }
            case 1: {
                ArrayList<T> result = new ArrayList<T>(1 + toAdd.size());
                result.add(list.get(0));
                result.addAll(toAdd);
                return result;
            }
        }
        list.addAll(toAdd);
        return list;
    }

    public static <T> List<T> addAll(List<T> list, T ... toAdd) {
        switch (toAdd.length) {
            case 0: {
                return list;
            }
            case 1: {
                return Lists.add(list, toAdd[0]);
            }
        }
        switch (list.size()) {
            case 0: {
                return new ArrayList<T>(Arrays.asList(toAdd));
            }
            case 1: {
                ArrayList<T> result = new ArrayList<T>(1 + toAdd.length);
                result.add(list.get(0));
                result.addAll(Arrays.asList(toAdd));
                return result;
            }
        }
        list.addAll(Arrays.asList(toAdd));
        return list;
    }

    public static <T> List<T> create() {
        return Collections.emptyList();
    }

    public static <T> List<T> create(Collection<T> collection) {
        switch (collection.size()) {
            case 0: {
                return Lists.create();
            }
            case 1: {
                return Lists.create(collection.iterator().next());
            }
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> create(T item) {
        return Collections.singletonList(item);
    }

    public static <T> List<T> create(T ... items) {
        switch (items.length) {
            case 0: {
                return Lists.create();
            }
            case 1: {
                return Lists.create(items[0]);
            }
        }
        return new ArrayList<T>(Arrays.asList(items));
    }

    public static <T> List<T> normalize(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Lists.create();
            }
            case 1: {
                if (list.getClass() == SINGLETON_LIST_CLASS) {
                    return list;
                }
                return Lists.create(list.get(0));
            }
        }
        if (list.getClass() == MULTI_LIST_CLASS) {
            return list;
        }
        return new ArrayList<T>(list);
    }

    public static <T> List<T> normalizeUnmodifiable(List<T> list) {
        if (list.size() < 2) {
            return Lists.normalize(list);
        }
        return Arrays.asList(list.toArray());
    }

    public static <T> List<T> remove(List<T> list, int toRemove) {
        switch (list.size()) {
            case 0: {
                throw Lists.newIndexOutOfBounds(list, toRemove);
            }
            case 1: {
                if (toRemove == 0) {
                    return Collections.emptyList();
                }
                throw Lists.newIndexOutOfBounds(list, toRemove);
            }
            case 2: {
                switch (toRemove) {
                    case 0: {
                        return Collections.singletonList(list.get(1));
                    }
                    case 1: {
                        return Collections.singletonList(list.get(0));
                    }
                }
                throw Lists.newIndexOutOfBounds(list, toRemove);
            }
        }
        list.remove(toRemove);
        return list;
    }

    public static <T> List<T> set(List<T> list, int index, T e) {
        switch (list.size()) {
            case 0: {
                throw Lists.newIndexOutOfBounds(list, index);
            }
            case 1: {
                if (index == 0) {
                    return Collections.singletonList(e);
                }
                throw Lists.newIndexOutOfBounds(list, index);
            }
        }
        list.set(index, e);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> sort) {
        if (list.size() > 1) {
            Collections.sort(list, sort);
        }
        return list;
    }

    private static <T> IndexOutOfBoundsException newIndexOutOfBounds(List<T> list, int index) {
        return new IndexOutOfBoundsException("Index: " + index + ", Size: " + list.size());
    }
}

