/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.collect;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import java.io.Serializable;

public class IntMultimap
implements Serializable {
    protected OpenIntObjectHashMap map = new OpenIntObjectHashMap();

    public void clear() {
        this.map.clear();
    }

    public boolean equals(Object object) {
        if (object instanceof IntMultimap) {
            IntMultimap that = (IntMultimap)object;
            if (this.map.size() != that.map.size()) {
                return false;
            }
            IntArrayList keys = this.map.keys();
            for (int i = 0; i < keys.size(); ++i) {
                int key = keys.get(i);
                if (this.get(key).equals(that.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public IntArrayList get(int key) {
        return (IntArrayList)this.map.get(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        IntArrayList keys = this.map.keys();
        for (int i = 0; i < keys.size(); ++i) {
            int key = keys.get(i);
            result = 31 * result + key;
            IntArrayList values = this.get(key);
            if (values == null) continue;
            for (int j = 0; j < values.size(); ++j) {
                int value = values.get(j);
                result = 31 * result + value;
            }
        }
        return result;
    }

    public IntArrayList keys() {
        return this.map.keys();
    }

    public void put(int key, int value) {
        Object objectValues = this.map.get(key);
        if (objectValues != null) {
            IntArrayList listValues = (IntArrayList)objectValues;
            listValues.add(value);
        } else {
            IntArrayList listValues = new IntArrayList();
            listValues.add(value);
            this.map.put(key, listValues);
        }
    }

    public void putAll(IntMultimap thatMap) {
        IntArrayList keys = thatMap.map.keys();
        for (int key : keys.elements()) {
            IntArrayList values = (IntArrayList)thatMap.map.get(key);
            this.map.put(key, values.copy());
        }
    }

    public IntArrayList remove(int key) {
        IntArrayList values = this.get(key);
        this.map.removeKey(key);
        return values;
    }

    public boolean remove(int key, int value) {
        int valueIndex;
        IntArrayList values = this.get(key);
        if (values != null && (valueIndex = values.indexOf(value)) != -1) {
            values.remove(valueIndex);
            return true;
        }
        return false;
    }
}

