/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.collect;

import com.google.gwt.dev.util.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class IdentitySingletonMap<K, V>
implements Map<K, V>,
Serializable {
    final K key;
    final V value;

    public IdentitySingletonMap(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object k) {
        return this.key == k;
    }

    @Override
    public boolean containsValue(Object v) {
        return this.value == v;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Sets.create(new IdentityEntry());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        return this.entrySet().equals(other.entrySet());
    }

    @Override
    public V get(Object k) {
        return this.key == k ? (V)this.value : null;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.key) ^ System.identityHashCode(this.value);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<K> keySet() {
        return Sets.create(this.key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return 1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32 * this.size());
        buf.append('{');
        buf.append((Object)(this.key == this ? "(this Map)" : this.key)).append('=').append((Object)(this.value == this ? "(this Map)" : this.value));
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Collection<V> values() {
        return Sets.create(this.value);
    }

    private class IdentityEntry
    implements Map.Entry<K, V> {
        private IdentityEntry() {
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return IdentitySingletonMap.this.key == entry.getKey() && IdentitySingletonMap.this.value == entry.getValue();
        }

        @Override
        public K getKey() {
            return IdentitySingletonMap.this.key;
        }

        @Override
        public V getValue() {
            return IdentitySingletonMap.this.value;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(IdentitySingletonMap.this.key) ^ System.identityHashCode(IdentitySingletonMap.this.value);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return IdentitySingletonMap.this.key + "=" + IdentitySingletonMap.this.value;
        }
    }
}

