/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.collect;

import com.google.gwt.dev.util.collect.IdentityHashSet;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentitySets {
    private static final Class<?> MULTI_SET_CLASS = IdentityHashSet.class;
    private static final Class<?> SINGLETON_SET_CLASS = IdentitySingletonSet.class;

    public static <T> Set<T> add(Set<T> set, T toAdd) {
        switch (set.size()) {
            case 0: {
                return new IdentitySingletonSet<T>(toAdd);
            }
            case 1: {
                if (set.contains(toAdd)) {
                    return set;
                }
                IdentityHashSet<T> result = new IdentityHashSet<T>();
                result.add(set.iterator().next());
                result.add(toAdd);
                return result;
            }
        }
        set.add(toAdd);
        return set;
    }

    public static <T> Set<T> create() {
        return Collections.emptySet();
    }

    public static <T> Set<T> create(T item) {
        return new IdentitySingletonSet<T>(item);
    }

    public static <T> Set<T> normalize(Set<T> set) {
        switch (set.size()) {
            case 0: {
                return IdentitySets.create();
            }
            case 1: {
                if (set.getClass() == SINGLETON_SET_CLASS) {
                    return set;
                }
                return IdentitySets.create(set.iterator().next());
            }
        }
        if (set.getClass() == MULTI_SET_CLASS) {
            return set;
        }
        IdentityHashSet<T> result = new IdentityHashSet<T>();
        result.addAll(set);
        return result;
    }

    public static <T> Set<T> remove(Set<T> set, T toRemove) {
        switch (set.size()) {
            case 0: {
                return set;
            }
            case 1: {
                if (set.contains(toRemove)) {
                    return IdentitySets.create();
                }
                return set;
            }
            case 2: {
                if (set.remove(toRemove)) {
                    return IdentitySets.create(set.iterator().next());
                }
                return set;
            }
        }
        set.remove(toRemove);
        return set;
    }

    private static final class SingletonIterator<T>
    implements Iterator<T> {
        private static final Object EMPTY = new Object();
        private T item;

        SingletonIterator(T item) {
            this.item = item;
        }

        @Override
        public boolean hasNext() {
            return this.item != EMPTY;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T toReturn = this.item;
            this.item = EMPTY;
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IdentitySingletonSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private final E item;

        IdentitySingletonSet(E item) {
            this.item = item;
        }

        @Override
        public boolean contains(Object o) {
            return o == this.item;
        }

        @Override
        public Iterator<E> iterator() {
            return new SingletonIterator<E>(this.item);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[1]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < 1) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            }
            a[0] = this.item;
            int i = 1;
            while (i < a.length) {
                a[i++] = null;
            }
            return a;
        }
    }
}

