/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.collect;

import com.google.gwt.dev.util.collect.IdentityHashMap;
import com.google.gwt.dev.util.collect.IdentitySingletonMap;
import java.util.Collections;
import java.util.Map;

public class IdentityMaps {
    private static final Class<?> MULTI_MAP_CLASS = IdentityHashMap.class;
    private static final Class<?> SINGLETON_MAP_CLASS = IdentitySingletonMap.class;

    public static <K, V> Map<K, V> create() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> create(K key, V value) {
        return new IdentitySingletonMap<K, V>(key, value);
    }

    public static <K, V> Map<K, V> normalize(Map<K, V> map) {
        switch (map.size()) {
            case 0: {
                return IdentityMaps.create();
            }
            case 1: {
                if (map.getClass() == SINGLETON_MAP_CLASS) {
                    return map;
                }
                K key = map.keySet().iterator().next();
                return IdentityMaps.create(key, map.get(key));
            }
        }
        if (map.getClass() == MULTI_MAP_CLASS) {
            return map;
        }
        return new IdentityHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> normalizeUnmodifiable(Map<K, V> map) {
        if (map.size() < 2) {
            return IdentityMaps.normalize(map);
        }
        return Collections.unmodifiableMap(IdentityMaps.normalize(map));
    }
}

