/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.arg;

import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.util.tools.Utility;

public enum SourceLevel {
    JAVA8("1.8", "8"),
    JAVA9("9", "1.9"),
    JAVA10("10", "1.10"),
    JAVA11("11", "1.11"),
    JAVA17("17", "1.17");

    public static final SourceLevel DEFAULT_SOURCE_LEVEL;
    private final String stringValue;
    private final String altStringValue;

    private SourceLevel(String stringValue, String altStringValue) {
        this.stringValue = stringValue;
        this.altStringValue = altStringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String getAltStringValue() {
        return this.altStringValue;
    }

    public String toString() {
        return this.stringValue;
    }

    public static SourceLevel fromString(String sourceLevelString) {
        if (sourceLevelString == null) {
            return null;
        }
        for (SourceLevel sourceLevel : SourceLevel.values()) {
            if (!sourceLevel.stringValue.equals(sourceLevelString) && !sourceLevel.altStringValue.equals(sourceLevelString)) continue;
            return sourceLevel;
        }
        return null;
    }

    private static SourceLevel getJvmBestMatchingSourceLevel() {
        String javaSpecLevel = System.getProperty("java.specification.version");
        return SourceLevel.getBestMatchingVersion(javaSpecLevel);
    }

    @VisibleForTesting
    public static SourceLevel getBestMatchingVersion(String javaVersionString) {
        try {
            SourceLevel[] sourceLevels = SourceLevel.values();
            for (int i = sourceLevels.length - 1; i >= 0; --i) {
                if (Utility.versionCompare(javaVersionString, sourceLevels[i].stringValue) < 0) continue;
                return sourceLevels[i];
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return JAVA8;
    }

    public static SourceLevel getHighest() {
        return SourceLevel.values()[SourceLevel.values().length - 1];
    }

    static {
        DEFAULT_SOURCE_LEVEL = SourceLevel.getJvmBestMatchingSourceLevel();
    }
}

