/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.arg;

import com.google.gwt.dev.util.arg.OptionSourceLevel;
import com.google.gwt.dev.util.arg.SourceLevel;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.util.tools.ArgHandlerString;

public class ArgHandlerSourceLevel
extends ArgHandlerString {
    private static final String AUTO_SELECT = "auto";
    private final OptionSourceLevel options;

    public ArgHandlerSourceLevel(OptionSourceLevel options) {
        this.options = options;
    }

    @Override
    public String[] getDefaultArgs() {
        return new String[]{this.getTag(), SourceLevel.JAVA8.getStringValue()};
    }

    @Override
    public String getPurpose() {
        return "Specifies Java source level (defaults to " + SourceLevel.JAVA8.getStringValue() + ")";
    }

    @Override
    public String getTag() {
        return "-sourceLevel";
    }

    @Override
    public String[] getTagArgs() {
        return new String[]{"[" + Joiner.on(", ").skipNulls().join(AUTO_SELECT, null, (Object[])SourceLevel.values()) + "]"};
    }

    @Override
    public boolean setString(String value) {
        if (value.equals(AUTO_SELECT)) {
            this.options.setSourceLevel(SourceLevel.DEFAULT_SOURCE_LEVEL);
            return true;
        }
        SourceLevel level = SourceLevel.fromString(value);
        if (level == null) {
            System.err.println("Source level must be one of [" + Joiner.on(", ").skipNulls().join(AUTO_SELECT, null, (Object[])SourceLevel.values()) + "].");
            return false;
        }
        this.options.setSourceLevel(level);
        return true;
    }
}

