/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.arg;

import com.google.gwt.dev.util.arg.OptionGenerateJsInteropExports;
import com.google.gwt.util.tools.ArgHandler;

public class ArgHandlerFilterJsInteropExports
extends ArgHandler {
    private final OptionGenerateJsInteropExports options;

    public ArgHandlerFilterJsInteropExports(OptionGenerateJsInteropExports options) {
        this.options = options;
    }

    @Override
    public String getPurpose() {
        return "Include/exclude members and classes while generating JsInterop exports. Flag could be set multiple times to expand the pattern. (The flag has only effect if exporting is enabled via -generateJsInteropExports)";
    }

    @Override
    public String getTag() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getTags() {
        return new String[]{"-includeJsInteropExports", "-excludeJsInteropExports"};
    }

    @Override
    public String getHelpTag() {
        return "-includeJsInteropExports/excludeJsInteropExports";
    }

    @Override
    public String[] getTagArgs() {
        return new String[]{"regex"};
    }

    @Override
    public int handle(String[] args, int startIndex) {
        if (startIndex + 1 >= args.length) {
            return -1;
        }
        String tagName = args[startIndex];
        boolean excludePattern = tagName.equals("-excludeJsInteropExports");
        if (excludePattern && this.options.getJsInteropExportFilter().isEmpty()) {
            System.err.println("-excludeJsInteropExports must be preceeded by -includeJsInteropExports");
            return -1;
        }
        String regex = args[startIndex + 1];
        if (regex.startsWith("+") || regex.startsWith("-")) {
            System.err.println(tagName + " regex cannot start with '+' or '-'");
            return -1;
        }
        try {
            this.options.getJsInteropExportFilter().add(excludePattern ? "-" + regex : regex);
        }
        catch (IllegalArgumentException e) {
            System.err.println(tagName + " regex is invalid: " + e.getMessage());
            return -1;
        }
        return 1;
    }
}

