/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.arg;

import com.google.gwt.dev.util.arg.OptionEnableGeneratingOnShards;
import com.google.gwt.util.tools.ArgHandlerFlag;

public class ArgHandlerDisableGeneratingOnShards
extends ArgHandlerFlag {
    private OptionEnableGeneratingOnShards options;

    public ArgHandlerDisableGeneratingOnShards(OptionEnableGeneratingOnShards options) {
        this.options = options;
        this.addTagValue("-XdisableGeneratingOnShards", false);
    }

    @Override
    public String getPurposeSnippet() {
        return "Run generators on CompilePerms shards for a likely speedup.";
    }

    @Override
    public String getLabel() {
        return "generateOnShards";
    }

    @Override
    public boolean isUndocumented() {
        return true;
    }

    @Override
    public boolean setFlag(boolean value) {
        this.options.setEnabledGeneratingOnShards(value);
        return true;
    }

    @Override
    public boolean isExperimental() {
        return true;
    }

    @Override
    public boolean getDefaultValue() {
        return this.options.isEnabledGeneratingOnShards();
    }
}

