/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util.arg;

import com.google.gwt.dev.util.arg.OptionBindAddress;
import com.google.gwt.util.tools.ArgHandlerString;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ArgHandlerBindAddress
extends ArgHandlerString {
    private static final String BIND_ADDRESS_TAG = "-bindAddress";
    public static final String DEFAULT_BIND_ADDRESS = "127.0.0.1";
    private final OptionBindAddress options;

    public ArgHandlerBindAddress(OptionBindAddress options) {
        this.options = options;
    }

    @Override
    public String[] getDefaultArgs() {
        return new String[]{BIND_ADDRESS_TAG, DEFAULT_BIND_ADDRESS};
    }

    @Override
    public String getPurpose() {
        return "Specifies the bind address for the code server and web server (defaults to 127.0.0.1)";
    }

    @Override
    public String getTag() {
        return BIND_ADDRESS_TAG;
    }

    @Override
    public String[] getTagArgs() {
        return new String[]{"host-name-or-address"};
    }

    @Override
    public boolean setString(String value) {
        try {
            InetAddress address = InetAddress.getByName(value);
            this.options.setBindAddress(value);
            if (address.isAnyLocalAddress()) {
                this.options.setConnectAddress(InetAddress.getLocalHost().getHostAddress());
            } else {
                this.options.setConnectAddress(value);
            }
            return true;
        }
        catch (UnknownHostException e) {
            System.err.println("-bindAddress host \"" + value + "\" unknown");
            return false;
        }
    }
}

