/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.StringInterningObjectInputStream;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.util.tools.Utility;
import com.google.gwt.util.tools.shared.StringUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class Util {
    public static String DEFAULT_ENCODING = "UTF-8";
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_PROTOCOL = "jar";
    private static final int THREAD_LOCAL_BUF_SIZE = 16384;
    private static final ThreadLocal<byte[]> threadLocalBuf = new ThreadLocal();

    public static String computeStrongName(byte[] content) {
        return Util.computeStrongName(new byte[][]{content});
    }

    public static String computeStrongName(byte[][] contents) {
        int i;
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error initializing MD5", e);
        }
        ByteBuffer b = ByteBuffer.allocate((contents.length + 1) * 4);
        b.putInt(contents.length);
        for (i = 0; i < contents.length; ++i) {
            b.putInt(contents[i].length);
        }
        b.flip();
        md5.update(b);
        for (i = 0; i < contents.length; ++i) {
            md5.update(contents[i]);
        }
        return StringUtils.toHexString(md5.digest());
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            Util.copyNoClose(is, os);
        }
        finally {
            Utility.close(is);
            Utility.close(os);
        }
    }

    public static void copy(TreeLogger logger, InputStream is, OutputStream os) throws UnableToCompleteException {
        try {
            Util.copy(is, os);
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Error during copy", e);
            throw new UnableToCompleteException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyNoClose(InputStream is, OutputStream os) throws IOException {
        byte[] buf = Util.takeThreadLocalBuf();
        try {
            int i;
            while ((i = is.read(buf)) != -1) {
                os.write(buf, 0, i);
            }
        }
        finally {
            Util.releaseThreadLocalBuf(buf);
        }
    }

    public static Reader createReader(TreeLogger logger, URL url) throws UnableToCompleteException {
        try {
            return new InputStreamReader(url.openStream());
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to open resource: " + url, e);
            throw new UnableToCompleteException();
        }
    }

    public static boolean equalsNullCheck(Object thisObject, Object thatObject) {
        if (thisObject == null) {
            return thatObject == null;
        }
        return thisObject.equals(thatObject);
    }

    public static String escapeXml(String unescaped) {
        StringBuilder builder = new StringBuilder();
        Util.escapeXml(unescaped, 0, unescaped.length(), true, builder);
        return builder.toString();
    }

    public static void escapeXml(String code, int start, int end, boolean quoteApostrophe, StringBuilder builder) {
        int lastIndex = 0;
        int len = end - start;
        char[] c = new char[len];
        code.getChars(start, end, c, 0);
        block7: for (int i = 0; i < len; ++i) {
            switch (c[i]) {
                case '&': {
                    builder.append(c, lastIndex, i - lastIndex);
                    builder.append("&amp;");
                    lastIndex = i + 1;
                    continue block7;
                }
                case '>': {
                    builder.append(c, lastIndex, i - lastIndex);
                    builder.append("&gt;");
                    lastIndex = i + 1;
                    continue block7;
                }
                case '<': {
                    builder.append(c, lastIndex, i - lastIndex);
                    builder.append("&lt;");
                    lastIndex = i + 1;
                    continue block7;
                }
                case '\"': {
                    builder.append(c, lastIndex, i - lastIndex);
                    builder.append("&quot;");
                    lastIndex = i + 1;
                    continue block7;
                }
                case '\'': {
                    if (!quoteApostrophe) continue block7;
                    builder.append(c, lastIndex, i - lastIndex);
                    builder.append("&apos;");
                    lastIndex = i + 1;
                    continue block7;
                }
            }
        }
        builder.append(c, lastIndex, len - lastIndex);
    }

    public static URL findSourceInClassPath(ClassLoader cl, String sourceTypeName) {
        String toTry = sourceTypeName.replace('.', '/') + ".java";
        URL foundURL = cl.getResource(toTry);
        if (foundURL != null) {
            return foundURL;
        }
        int i = sourceTypeName.lastIndexOf(46);
        if (i != -1) {
            return Util.findSourceInClassPath(cl, sourceTypeName.substring(0, i));
        }
        return null;
    }

    public static byte[] getBytes(String s) {
        try {
            return s.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The JVM does not support the compiler's default encoding.", e);
        }
    }

    public static String getClassName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public static String getFileFromInstallPath(String relativePath) {
        String installPath = Utility.getInstallPath();
        File file = new File(installPath + '/' + relativePath);
        return Util.readFileAsString(file);
    }

    public static String getPackageName(String qualifiedName) {
        int idx = qualifiedName.lastIndexOf(46);
        if (idx > 0) {
            return qualifiedName.substring(0, idx);
        }
        return "";
    }

    public static long getResourceModifiedTime(URL url) {
        long lastModified;
        block6: {
            lastModified = 0L;
            try {
                File file;
                if (url.getProtocol().equals(JAR_PROTOCOL)) {
                    JarURLConnection jarConn = (JarURLConnection)url.openConnection();
                    url = jarConn.getJarFileURL();
                }
                if (!url.getProtocol().equals(FILE_PROTOCOL)) break block6;
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException uriEx) {
                    file = new File(url.getPath());
                }
                lastModified = file.lastModified();
            }
            catch (IOException iOException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return lastModified;
    }

    public static boolean isValidJavaIdent(String token) {
        if (token.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(token.charAt(0))) {
            return false;
        }
        int n = token.length();
        for (int i = 1; i < n; ++i) {
            if (Character.isJavaIdentifierPart(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static File makeRelativeFile(File from, File to) {
        String currentFromPath;
        File currentFrom;
        String toPath = Util.tryMakeCanonical(to).getAbsolutePath();
        int numberOfBackups = 0;
        for (currentFrom = Util.tryMakeCanonical(from.isDirectory() ? from : from.getParentFile()); currentFrom != null && !toPath.startsWith(currentFromPath = currentFrom.getPath()); currentFrom = currentFrom.getParentFile()) {
            ++numberOfBackups;
        }
        if (currentFrom == null) {
            return null;
        }
        String trailingToPath = toPath.substring(currentFrom.getAbsolutePath().length());
        if (currentFrom.getParentFile() != null && trailingToPath.length() > 0) {
            trailingToPath = trailingToPath.substring(1);
        }
        File relativeFile = new File(trailingToPath);
        for (int i = 0; i < numberOfBackups; ++i) {
            relativeFile = new File("..", relativeFile.getPath());
        }
        return relativeFile;
    }

    public static String makeRelativePath(File from, File to) {
        File f = Util.makeRelativeFile(from, to);
        return f != null ? f.getPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsBytes(File file) {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int length = (int)file.length();
            byArray = Util.readBytesFromInputStream(fileInputStream, length);
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                byArray2 = null;
            }
            catch (Throwable throwable) {
                Utility.close(fileInputStream);
                throw throwable;
            }
            Utility.close(fileInputStream);
            return byArray2;
        }
        Utility.close(fileInputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T readFileAsObject(File file, Class<T> type) throws ClassNotFoundException, IOException {
        Serializable serializable;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            serializable = (Serializable)Util.readStreamAsObject(fileInputStream, type);
        }
        catch (Throwable throwable) {
            Utility.close(fileInputStream);
            throw throwable;
        }
        Utility.close(fileInputStream);
        return (T)serializable;
    }

    public static String readFileAsString(File file) {
        byte[] bytes = Util.readFileAsBytes(file);
        if (bytes != null) {
            return Util.toString(bytes, DEFAULT_ENCODING);
        }
        return null;
    }

    public static byte[] readStreamAsBytes(InputStream in) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Util.copy(in, out);
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readStreamAsObject(InputStream inputStream, Class<T> type) throws ClassNotFoundException, IOException {
        T t;
        StringInterningObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new StringInterningObjectInputStream(inputStream);
            t = type.cast(objectInputStream.readObject());
        }
        catch (Throwable throwable) {
            Utility.close(objectInputStream);
            throw throwable;
        }
        Utility.close(objectInputStream);
        return t;
    }

    public static String readStreamAsString(InputStream in) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Util.copy(in, out);
            return out.toString(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The JVM does not support the compiler's default encoding.", e);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] readURLAsBytes(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            return Util.readURLConnectionAsBytes(conn);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static char[] readURLAsChars(URL url) {
        byte[] bytes = Util.readURLAsBytes(url);
        if (bytes != null) {
            return Util.toString(bytes, DEFAULT_ENCODING).toCharArray();
        }
        return null;
    }

    public static String readURLAsString(URL url) {
        byte[] bytes = Util.readURLAsBytes(url);
        if (bytes != null) {
            return Util.toString(bytes, DEFAULT_ENCODING);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readURLConnectionAsBytes(URLConnection connection) {
        InputStream input = null;
        try {
            input = connection.getInputStream();
            int contentLength = connection.getContentLength();
            if (contentLength < 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = Util.readBytesFromInputStream(input, contentLength);
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            Utility.close(input);
        }
    }

    public static void recursiveDelete(File file, boolean childrenOnly) {
        Util.recursiveDelete(file, childrenOnly, null);
    }

    public static void recursiveDelete(File file, boolean childrenOnly, FileFilter filter) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    Util.recursiveDelete(children[i], false, filter);
                }
            }
            if (childrenOnly) {
                return;
            }
        }
        if (filter == null || filter.accept(file)) {
            file.delete();
        }
    }

    public static void releaseThreadLocalBuf(byte[] buf) {
        assert (buf.length == 16384);
        threadLocalBuf.set(buf);
    }

    public static String stripJarPathPrefix(String absolutePath) {
        int bang;
        if (absolutePath != null && (bang = absolutePath.lastIndexOf(33)) != -1) {
            return absolutePath.substring(bang + 2);
        }
        return absolutePath;
    }

    public static byte[] takeThreadLocalBuf() {
        byte[] buf = threadLocalBuf.get();
        if (buf == null) {
            buf = new byte[16384];
        } else {
            threadLocalBuf.set(null);
        }
        return buf;
    }

    public static <T> T[] toArray(Class<? super T> componentType, Collection<? extends T> coll) {
        int n = coll.size();
        Object[] a = (Object[])Array.newInstance(componentType, n);
        return coll.toArray(a);
    }

    public static String toString(byte[] bytes) {
        return Util.toString(bytes, DEFAULT_ENCODING);
    }

    public static File tryMakeCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public static void writeBytesToFile(TreeLogger logger, File where, byte[] what) throws UnableToCompleteException {
        Util.writeBytesToFile(logger, where, new byte[][]{what});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void writeBytesToFile(TreeLogger logger, File where, byte[][] what) throws UnableToCompleteException {
        IOException caught;
        block8: {
            FileOutputStream f = null;
            try {
                where.getParentFile().mkdirs();
                f = new FileOutputStream(where);
                for (int i = 0; i < what.length; ++i) {
                    f.write(what[i]);
                }
                Utility.close(f);
                return;
            }
            catch (FileNotFoundException e) {
                caught = e;
            }
            catch (IOException e2) {
                caught = e2;
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Utility.close(f);
            }
        }
        String msg = "Unable to write file '" + where + "'";
        logger.log(TreeLogger.ERROR, msg, caught);
        throw new UnableToCompleteException();
    }

    public static void writeObjectAsFile(TreeLogger logger, File file, Object ... objects) throws UnableToCompleteException {
        SpeedTracerLogger.Event writeObjectAsFileEvent = SpeedTracerLogger.start(CompilerEventType.WRITE_OBJECT_AS_FILE, new String[0]);
        FileOutputStream stream = null;
        try {
            file.getParentFile().mkdirs();
            stream = new FileOutputStream(file);
            Util.writeObjectToStream(stream, objects);
        }
        catch (IOException e) {
            try {
                logger.log(TreeLogger.ERROR, "Unable to write file: " + file.getAbsolutePath(), e);
                throw new UnableToCompleteException();
            }
            catch (Throwable throwable) {
                Utility.close(stream);
                writeObjectAsFileEvent.end(new String[0]);
                throw throwable;
            }
        }
        Utility.close(stream);
        writeObjectAsFileEvent.end(new String[0]);
    }

    public static void writeObjectToStream(OutputStream stream, Object ... objects) throws IOException {
        ObjectOutputStream objectStream = null;
        objectStream = new ObjectOutputStream(stream);
        for (Object object : objects) {
            objectStream.writeObject(object);
        }
        objectStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeStringAsFile(File file, String string) {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        BufferedWriter buffered = null;
        try {
            file.getParentFile().mkdirs();
            stream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)stream, DEFAULT_ENCODING);
            buffered = new BufferedWriter(writer);
            buffered.write(string);
        }
        catch (IOException e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                Utility.close(buffered);
                Utility.close(writer);
                Utility.close(stream);
                throw throwable;
            }
            Utility.close(buffered);
            Utility.close(writer);
            Utility.close(stream);
            return bl;
        }
        Utility.close(buffered);
        Utility.close(writer);
        Utility.close(stream);
        return true;
    }

    public static void writeStringAsFile(TreeLogger logger, File file, String string) throws UnableToCompleteException {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        BufferedWriter buffered = null;
        try {
            stream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)stream, DEFAULT_ENCODING);
            buffered = new BufferedWriter(writer);
            file.getParentFile().mkdirs();
            buffered.write(string);
        }
        catch (IOException e) {
            try {
                logger.log(TreeLogger.ERROR, "Unable to write file: " + file.getAbsolutePath(), e);
                throw new UnableToCompleteException();
            }
            catch (Throwable throwable) {
                Utility.close(buffered);
                Utility.close(writer);
                Utility.close(stream);
                throw throwable;
            }
        }
        Utility.close(buffered);
        Utility.close(writer);
        Utility.close(stream);
    }

    public static void writeUtf8(StringBuilder builder, OutputStream out) throws IOException {
        int buflen = 1024;
        char[] inBuf = new char[buflen];
        byte[] outBuf = new byte[4 * buflen];
        int length = builder.length();
        int start = 0;
        while (start < length) {
            int end = Math.min(start + buflen, length);
            builder.getChars(start, end, inBuf, 0);
            int index = 0;
            int len = end - start;
            for (int i = 0; i < len; ++i) {
                int x;
                int y;
                int c = inBuf[i] & 0xFFFF;
                if (c < 128) {
                    outBuf[index++] = (byte)c;
                    continue;
                }
                if (c < 2048) {
                    y = c >> 8;
                    x = c & 0xFF;
                    outBuf[index++] = (byte)(0xC0 | y << 2 | x >> 6);
                    outBuf[index++] = (byte)(0x80 | x & 0x3F);
                    continue;
                }
                if (c < 55296 || c > 57343) {
                    y = c >> 8 & 0xFF;
                    x = c & 0xFF;
                    outBuf[index++] = (byte)(0xE0 | y >> 4);
                    outBuf[index++] = (byte)(0x80 | y << 2 & 0x3C | x >> 6);
                    outBuf[index++] = (byte)(0x80 | x & 0x3F);
                    continue;
                }
                if (i + 1 >= len) continue;
                int hi = c & 0x3FF;
                int lo = inBuf[i + 1] & 0x3FF;
                int full = 65536 + (hi << 10 | lo);
                int z = full >> 16 & 0xFF;
                int y2 = full >> 8 & 0xFF;
                int x2 = full & 0xFF;
                outBuf[index++] = (byte)(0xF0 | z >> 5);
                outBuf[index++] = (byte)(0x80 | z << 4 & 0x30 | y2 >> 4);
                outBuf[index++] = (byte)(0x80 | y2 << 2 & 0x3C | x2 >> 6);
                outBuf[index++] = (byte)(0x80 | x2 & 0x3F);
                ++i;
            }
            out.write(outBuf, 0, index);
            start = end;
        }
    }

    private static byte[] readBytesFromInputStream(InputStream input, int byteLength) {
        try {
            int bytesReadCount;
            byte[] bytes = new byte[byteLength];
            for (int byteOffset = 0; byteOffset < byteLength; byteOffset += bytesReadCount) {
                bytesReadCount = input.read(bytes, byteOffset, byteLength - byteOffset);
                if (bytesReadCount != -1) continue;
                return null;
            }
            return bytes;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String toString(byte[] bytes, String charsetName) {
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static void writeAttribute(PrintWriter w, Attr attr, int depth) throws IOException {
        w.write(attr.getName());
        w.write(61);
        for (Node c = attr.getFirstChild(); c != null; c = c.getNextSibling()) {
            w.write(34);
            Util.writeNode(w, c, depth);
            w.write(34);
        }
    }

    private static void writeDocument(PrintWriter w, Document d) throws IOException {
        w.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
            Util.writeNode(w, c, 0);
        }
    }

    private static void writeElement(PrintWriter w, Element el, int depth) throws IOException {
        String tagName = el.getTagName();
        Util.writeIndent(w, depth);
        w.write(60);
        w.write(tagName);
        NamedNodeMap attrs = el.getAttributes();
        int n = attrs.getLength();
        for (int i = 0; i < n; ++i) {
            w.write(32);
            Util.writeNode(w, attrs.item(i), depth);
        }
        Node c = el.getFirstChild();
        if (c != null) {
            w.println('>');
            while (c != null) {
                Util.writeNode(w, c, depth + 1);
                w.println();
                c = c.getNextSibling();
            }
            Util.writeIndent(w, depth);
            w.write("</");
            w.write(tagName);
            w.print('>');
        } else {
            w.print("/>");
        }
    }

    private static void writeIndent(PrintWriter w, int depth) {
        for (int i = 0; i < depth; ++i) {
            w.write(9);
        }
    }

    private static void writeNode(PrintWriter w, Node node, int depth) throws IOException {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: {
                Util.writeElement(w, (Element)node, depth);
                break;
            }
            case 2: {
                Util.writeAttribute(w, (Attr)node, depth);
                break;
            }
            case 9: {
                Util.writeDocument(w, (Document)node);
                break;
            }
            case 3: {
                Util.writeText(w, (Text)node);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported DOM node type: " + nodeType);
            }
        }
    }

    private static void writeText(PrintWriter w, Text text) throws DOMException {
        String nodeValue = text.getNodeValue();
        String escaped = Util.escapeXml(nodeValue);
        w.write(escaped);
    }

    private Util() {
    }
}

