/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.dev.util.StringInterner;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class StringInterningObjectInputStream
extends ObjectInputStream {
    public static final int MAX_INTERNED_STRING_SIZE = 2048;

    public StringInterningObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.enableResolveObject(true);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        Object resolvedObject = super.resolveObject(obj);
        if (resolvedObject instanceof String && ((String)resolvedObject).length() < 2048) {
            return StringInterner.get().intern((String)resolvedObject);
        }
        return resolvedObject;
    }
}

