/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PerfCounter {
    private static boolean enabled = Boolean.parseBoolean(System.getProperty("gwt.perfcounters"));
    private static final ThreadLocal<Map<String, Long>> operationsStartTime = new ThreadLocal<Map<String, Long>>(){

        @Override
        protected Map<String, Long> initialValue() {
            return new HashMap<String, Long>();
        }
    };
    private static final Map<String, OperationStats> operationStats = new HashMap<String, OperationStats>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end(String operation, long slowThresholdNano) {
        Long startTime;
        Map<String, Long> startTimes;
        if (!enabled) {
            return;
        }
        long finishTime = System.nanoTime();
        Map<String, Object> map = startTimes = operationsStartTime.get();
        synchronized (map) {
            startTime = startTimes.remove(operation);
        }
        Preconditions.checkNotNull(startTime);
        map = operationStats;
        synchronized (map) {
            OperationStats stats = PerfCounter.getStats(operation);
            stats.count++;
            long elapsedTime = finishTime - startTime;
            stats.totalTimeNanos += elapsedTime;
            stats.maxTimeNanos = Math.max(stats.maxTimeNanos, elapsedTime);
            if (elapsedTime > slowThresholdNano) {
                stats.slowCount++;
                stats.totalSlowTimeNanos += elapsedTime;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inc(String operation) {
        Map<String, OperationStats> map = operationStats;
        synchronized (map) {
            OperationStats stats = PerfCounter.getStats(operation);
            stats.count++;
            stats.isCounter = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print() {
        if (!enabled) {
            return;
        }
        System.out.println("------------- Perf Counters -------------");
        Map<String, OperationStats> map = operationStats;
        synchronized (map) {
            ArrayList<String> keys = new ArrayList<String>(operationStats.keySet());
            Collections.sort(keys);
            for (String operation : keys) {
                System.out.println(operation + ": " + operationStats.get(operation));
            }
        }
        System.out.println("-----------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String operation) {
        Map<String, Long> startTimes;
        if (!enabled) {
            return;
        }
        Map<String, Long> map = startTimes = operationsStartTime.get();
        synchronized (map) {
            Preconditions.checkState(!startTimes.containsKey(operation));
            long startTime = System.nanoTime();
            startTimes.put(operation, new Long(startTime));
        }
    }

    private static OperationStats getStats(String operation) {
        OperationStats stats = operationStats.get(operation);
        if (stats == null) {
            stats = new OperationStats();
            operationStats.put(operation, stats);
        }
        return stats;
    }

    private static class OperationStats {
        private long count = 0L;
        private boolean isCounter = false;
        private long maxTimeNanos = 0L;
        private long slowCount = 0L;
        private long totalSlowTimeNanos = 0L;
        private long totalTimeNanos = 0L;

        private OperationStats() {
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (!this.isCounter) {
                result.append(this.count);
                result.append("/");
                result.append((double)this.totalTimeNanos / 1.0E9);
                result.append("/");
                result.append((double)this.totalTimeNanos / 1.0E9 / (double)this.count);
                result.append("/");
                result.append((double)this.maxTimeNanos / 1.0E9);
                result.append("/");
                result.append(this.slowCount);
                result.append("/");
                result.append((double)this.totalSlowTimeNanos * 1.0 / (double)this.totalTimeNanos);
                result.append(" ");
                result.append("(count/total_time/avg_time/max_time/slow_count/slow_ratio)");
            } else {
                result.append(this.count);
                result.append(" (count)");
            }
            return result.toString();
        }
    }
}

