/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.dev.util.NullOutputFileSet;
import com.google.gwt.dev.util.OutputFileSet;
import com.google.gwt.dev.util.collect.HashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class OutputFileSetOnJar
extends OutputFileSet {
    public static final boolean normalizeTimestamps = Boolean.parseBoolean(System.getProperty("gwt.normalizeTimestamps", "false"));
    private Set<String> createdDirs = new HashSet<String>();
    private final JarOutputStream jar;
    private final String pathPrefix;
    private final Set<String> seenEntries = new HashSet<String>();

    private static String getParentPath(String path) {
        assert (!path.endsWith("/"));
        int pos = path.lastIndexOf(47);
        return pos >= 0 ? path.substring(0, pos) : null;
    }

    public OutputFileSetOnJar(File jarFile, String pathPrefix) throws IOException {
        super(jarFile.getAbsolutePath());
        jarFile.delete();
        this.jar = new JarOutputStream(new FileOutputStream(jarFile));
        this.pathPrefix = pathPrefix;
    }

    @Override
    public void close() throws IOException {
        this.jar.close();
    }

    @Override
    public OutputStream createNewOutputStream(String path, long lastModifiedTime) throws IOException {
        String fullPath = this.pathPrefix + path;
        if (this.seenEntries.contains(fullPath)) {
            return new NullOutputFileSet.NullOutputStream();
        }
        this.seenEntries.add(fullPath);
        this.mkzipDirs(OutputFileSetOnJar.getParentPath(fullPath));
        ZipEntry zipEntry = new ZipEntry(fullPath);
        if (normalizeTimestamps) {
            zipEntry.setTime(0L);
        } else if (lastModifiedTime >= 0L) {
            zipEntry.setTime(lastModifiedTime);
        }
        this.jar.putNextEntry(zipEntry);
        return new OutputStreamOnJarEntry();
    }

    private void mkzipDirs(String path) throws IOException {
        if (path == null) {
            return;
        }
        if (this.createdDirs.contains(path)) {
            return;
        }
        this.mkzipDirs(OutputFileSetOnJar.getParentPath(path));
        ZipEntry entry = new ZipEntry(path + '/');
        entry.setSize(0L);
        entry.setCompressedSize(0L);
        entry.setCrc(0L);
        entry.setMethod(0);
        if (normalizeTimestamps) {
            entry.setTime(0L);
        }
        this.jar.putNextEntry(entry);
        this.createdDirs.add(path);
    }

    private final class OutputStreamOnJarEntry
    extends OutputStream {
        private OutputStreamOnJarEntry() {
        }

        @Override
        public void close() throws IOException {
            OutputFileSetOnJar.this.jar.closeEntry();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputFileSetOnJar.this.jar.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            OutputFileSetOnJar.this.jar.write(b);
        }
    }
}

