/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.dev.util.NullOutputFileSet;
import com.google.gwt.dev.util.OutputFileSet;
import com.google.gwt.dev.util.collect.HashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;

public class OutputFileSetOnDirectory
extends OutputFileSet {
    private final Set<String> createdDirs = new HashSet<String>();
    private final File dir;
    private final String prefix;

    public OutputFileSetOnDirectory(File dir, String prefix) {
        super(dir.getAbsolutePath());
        this.dir = dir;
        this.prefix = prefix;
    }

    @Override
    public void close() {
    }

    @Override
    protected OutputStream createNewOutputStream(String path, final long timeStampMillis) throws IOException {
        final File file = this.pathToFile(path);
        if (file.exists() && timeStampMillis != -1L && file.lastModified() > timeStampMillis) {
            return new NullOutputFileSet.NullOutputStream();
        }
        this.mkdirs(file.getParentFile());
        return new FileOutputStream(file){

            @Override
            public void close() throws IOException {
                super.close();
                if (timeStampMillis != -1L) {
                    file.setLastModified(timeStampMillis);
                }
            }
        };
    }

    private void mkdirs(File dir) throws IOException {
        if (dir == null) {
            return;
        }
        String path = dir.getPath();
        if (this.createdDirs.contains(path)) {
            return;
        }
        this.createdDirs.add(path);
        if (!dir.exists()) {
            this.mkdirs(dir.getParentFile());
            if (!dir.mkdir()) {
                throw new IOException("unable to create directory: " + dir.getAbsolutePath());
            }
        }
    }

    private File pathToFile(String path) throws IOException {
        return new File(this.dir, this.prefix + path).getCanonicalFile();
    }
}

