/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.PersistenceBackedObject;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.io.Serializable;

public class MemoryBackedObject<T extends Serializable>
implements PersistenceBackedObject<T> {
    private T data;
    private final Class<T> clazz;

    public MemoryBackedObject(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean exists() {
        return this.data != null;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public T newInstance(TreeLogger logger) throws UnableToCompleteException {
        T result = this.data;
        this.data = null;
        return result;
    }

    @Override
    public void set(TreeLogger logger, T object) throws IllegalStateException, UnableToCompleteException {
        assert (this.clazz.isInstance(object));
        Preconditions.checkState(this.data == null);
        this.data = object;
    }

    public String toString() {
        return "MemoryBackedObject<" + this.clazz.getName() + ">";
    }
}

