/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;

public class Memory {
    private static final int NUM_GC_COLLECTIONS = 4;
    private static final String PROPERTY_DUMP_HEAP = "gwt.memory.dumpHeap";
    private static final String PROPERTY_DUMP_MEMORY = "gwt.memory.usage";
    private static long startTime;

    public static void initialize() {
        if (System.getProperty(PROPERTY_DUMP_MEMORY) != null) {
            System.out.println("Will print mem usage");
        }
        if (System.getProperty(PROPERTY_DUMP_HEAP) != null) {
            System.out.println("Will dump heap into: *-" + System.getProperty(PROPERTY_DUMP_HEAP));
        }
        startTime = System.currentTimeMillis();
    }

    public static void main(String[] args) {
        Memory.initialize();
        System.setProperty(PROPERTY_DUMP_MEMORY, "");
        Memory.maybeDumpMemory("test");
    }

    public static void maybeDumpMemory(String info) {
        String dumpFile;
        long elapsed = System.currentTimeMillis() - startTime;
        if (System.getProperty(PROPERTY_DUMP_MEMORY) != null) {
            for (int i = 0; i < 4; ++i) {
                System.gc();
            }
            long heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
            long nonHeap = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
            String infoString = String.format("[%.18s]", info);
            System.out.println(String.format("%-20s %10d heap, %10d nonheap, %10d total, %10.2fs", infoString, heap, nonHeap, heap + nonHeap, (double)elapsed / 1000.0));
        }
        if ((dumpFile = System.getProperty(PROPERTY_DUMP_HEAP)) != null) {
            String procName = ManagementFactory.getRuntimeMXBean().getName();
            dumpFile = info + "-" + procName + dumpFile;
            new File(dumpFile).delete();
            try {
                Class<?> beanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                Object bean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", beanClass);
                Method dumpHeapMethod = beanClass.getDeclaredMethod("dumpHeap", String.class, Boolean.TYPE);
                dumpHeapMethod.invoke(bean, dumpFile, true);
                System.out.println("(" + info + ") dumped heap into: " + dumpFile);
            }
            catch (Throwable e) {
                System.err.println("Unable to dump heap");
                e.printStackTrace();
            }
        }
        startTime = System.currentTimeMillis();
    }
}

