/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.dev.util.Empty;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsniRef {
    public static final String CLASS = "class";
    public static final String NEW = "new";
    public static final String WILDCARD_PARAM_LIST = "*";
    private static Pattern JsniRefPattern = Pattern.compile("@?([^:@\\[\\]]*)((?:\\[\\])*)::([^(]+)(\\((.*)\\))?");
    private final String className;
    private String resolvedClassName;
    private String resolvedNemberSignature;
    private final String memberName;
    private final String[] paramTypes;
    private final String paramTypesString;
    private final int arrayDimensions;

    public static JsniRef parse(String refString) {
        Matcher matcher = JsniRefPattern.matcher(refString);
        if (!matcher.matches()) {
            return null;
        }
        String className = matcher.group(1);
        int arrayDimensions = matcher.group(2).length() / 2;
        String memberName = matcher.group(3);
        String paramTypesString = null;
        String[] paramTypes = null;
        if (matcher.group(4) != null && !(paramTypesString = matcher.group(5)).equals(WILDCARD_PARAM_LIST) && (paramTypes = JsniRef.computeParamTypes(paramTypesString)) == null) {
            return null;
        }
        return new JsniRef(className, arrayDimensions, memberName, paramTypesString, paramTypes);
    }

    private static String[] computeParamTypes(String paramTypesString) {
        ArrayList<String> types = Lists.newArrayList();
        StringBuilder nextType = new StringBuilder();
        boolean inRef = false;
        block5: for (char c : paramTypesString.toCharArray()) {
            nextType.append(c);
            if (inRef) {
                if (c != ';') continue;
                types.add(StringInterner.get().intern(nextType.toString()));
                nextType.setLength(0);
                inRef = false;
                continue;
            }
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    types.add(StringInterner.get().intern(nextType.toString()));
                    nextType.setLength(0);
                    continue block5;
                }
                case '[': {
                    continue block5;
                }
                case 'L': {
                    inRef = true;
                    continue block5;
                }
                default: {
                    return null;
                }
            }
        }
        return types.toArray(Empty.STRINGS);
    }

    protected JsniRef(String className, int arrayDimensions, String memberName, String paramTypesString, String[] paramTypes) {
        this.className = className;
        this.memberName = memberName;
        this.arrayDimensions = arrayDimensions;
        this.paramTypesString = paramTypesString;
        this.paramTypes = paramTypes;
    }

    public String className() {
        return this.className;
    }

    public boolean equals(Object obj) {
        return obj instanceof JsniRef && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isField() {
        return this.paramTypesString == null;
    }

    public boolean isMethod() {
        return this.paramTypesString != null;
    }

    public boolean matchesAnyOverload() {
        return this.paramTypesString.equals(WILDCARD_PARAM_LIST);
    }

    public String memberName() {
        return this.memberName;
    }

    public String memberSignature() {
        String ret = this.memberName;
        if (this.isMethod()) {
            ret = ret + "(" + this.paramTypesString + ")";
        }
        return ret;
    }

    public String[] paramTypes() {
        assert (!this.matchesAnyOverload());
        return this.paramTypes;
    }

    public String paramTypesString() {
        return this.paramTypesString;
    }

    public void setResolvedClassName(String resolvedClassName) {
        this.resolvedClassName = StringInterner.get().intern(resolvedClassName);
    }

    public void setResolvedMemberWithSignature(String resolvedMemberSignature) {
        this.resolvedNemberSignature = StringInterner.get().intern(resolvedMemberSignature);
    }

    public String getResolvedClassName() {
        return this.resolvedClassName;
    }

    public String getFullResolvedClassName() {
        return this.resolvedClassName == null ? null : this.resolvedClassName + Strings.repeat("[]", this.arrayDimensions);
    }

    public String getResolvedReference() {
        String fullResolvedClassName = this.getFullResolvedClassName();
        return fullResolvedClassName == null || this.resolvedClassName == null ? null : "@" + fullResolvedClassName + "::" + this.resolvedNemberSignature;
    }

    public String getResolvedMemberSignature() {
        return this.resolvedNemberSignature;
    }

    public String fullClassName() {
        return this.className + Strings.repeat("[]", this.arrayDimensions);
    }

    public String toString() {
        return "@" + this.fullClassName() + "::" + this.memberSignature();
    }

    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    public int getDimensions() {
        return this.arrayDimensions;
    }
}

