/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.PersistenceBackedObject;
import com.google.gwt.dev.util.Util;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;

public class FileBackedObject<T extends Serializable>
implements PersistenceBackedObject<T> {
    private boolean alreadyWritten = false;
    private final File backingFile;
    private final Class<T> clazz;

    public FileBackedObject(Class<T> clazz) throws IOException {
        this(clazz, File.createTempFile("fileBackedObject", ".ser"));
        this.backingFile.deleteOnExit();
    }

    public FileBackedObject(Class<T> clazz, File backingFile) {
        this.clazz = clazz;
        this.backingFile = backingFile;
    }

    @Override
    public boolean exists() {
        return this.backingFile.exists();
    }

    @Override
    public String getPath() {
        return this.backingFile.getAbsolutePath();
    }

    @Override
    public T newInstance(TreeLogger logger) throws UnableToCompleteException {
        try {
            return Util.readFileAsObject(this.backingFile, this.clazz);
        }
        catch (ClassNotFoundException e) {
            logger.log(TreeLogger.ERROR, "Missing class definition", e);
            throw new UnableToCompleteException();
        }
        catch (InvalidClassException e) {
            logger.log(TreeLogger.ERROR, "Incompatible version of class " + this.clazz.getSimpleName() + ".", e);
            throw new UnableToCompleteException();
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to instantiate object", e);
            throw new UnableToCompleteException();
        }
    }

    @Override
    public void set(TreeLogger logger, T object) throws IllegalStateException, UnableToCompleteException {
        assert (this.clazz.isInstance(object));
        Preconditions.checkState(!this.alreadyWritten);
        this.alreadyWritten = true;
        Util.writeObjectAsFile(logger, this.backingFile, object);
    }

    public String toString() {
        return this.backingFile.toString() + "<" + this.clazz.getName() + ">";
    }
}

