/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import com.google.gwt.dev.util.DiskCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DiskCacheToken
implements Serializable {
    private transient DiskCache diskCache;
    private transient long token;

    public DiskCacheToken(long token) {
        this(DiskCache.INSTANCE, token);
    }

    DiskCacheToken(DiskCache diskCache, long token) {
        assert (token >= 0L);
        this.diskCache = diskCache;
        this.token = token;
    }

    public synchronized byte[] readByteArray() {
        return this.diskCache.readByteArray(this.token);
    }

    public <T> T readObject(Class<T> type) {
        return this.diskCache.readObject(this.token, type);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException {
        this.diskCache = DiskCache.INSTANCE;
        this.token = this.diskCache.transferFromStream(inputStream);
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        this.diskCache.transferToStream(this.token, outputStream);
    }
}

